/***************************************************************************
    smb4kprint  -  The printing core class.
                             -------------------
    begin                : Tue Mar 30 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KPRINT_H
#define SMB4KPRINT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <QObject>
#include <QString>
#include <QQueue>

// KDE includes
#include <kprocess.h>
#include <kdemacros.h>

// application specific includes
#include <smb4kprintinfo.h>


/**
 * This is a core class. It provides the interface for printing documents over
 * the network neighborhood.
 *
 * You shouldn't use this class directly but access it through Smb4KCore.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class KDE_EXPORT Smb4KPrint : public QObject
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     *
     * @param parent        The parent object.
     */
    Smb4KPrint( QObject *parent = 0 );

    /**
     * The destructor.
     */
    ~Smb4KPrint();

    /**
     * This function starts the printing of a file. It returns TRUE if the print
     * process was initialized and FALSE otherwise.
     *
     * @param info        The Smb4KPrintInfo object
     *
     * @returns TRUE if the print process was initialized successfully.
     */
    bool print( Smb4KPrintInfo *info );

    /**
     * Aborts the print process.
     */
    void abort();

    /**
     * This function returns TRUE if the printer handler is running and
     * FALSE otherwise.
     *
     * @returns           TRUE is the printer handler is running and FALSE otherwise.
     */
    bool isRunning() { return m_working; }

  signals:
    /**
     * This signal emits the run state.
     *
     * @param state       The so-called run state. There are several defined
     *                    in the smb4kdefs.h header file.
     */
    void state( int state );

  protected:
    /**
     * Reimplemented from QObject to process the queue.
     *
     * @param event             The QTimerEvent event
     */
    void timerEvent( QTimerEvent *event );

  protected slots:
    /**
     * This slot is called, when the process exited.
     *
     * @param exitCode           The exit code of the process
     *
     * @param exitStatus         The exit status of the process (@see QProcess::ExitStatus)
     */
    void slotProcessFinished( int exitCode,
                              QProcess::ExitStatus exitStatus );

    /**
     * This slot is invoked when an error occurred with the process.
     *
     * @param errorCode       The error code returned by the process
     */
    void slotProcessError( QProcess::ProcessError errorCode );

  private:

    /**
     * The KProcess object.
     */
    KProcess *m_proc;

    /**
     * This boolean is TRUE if the printer handler is running and
     * FALSE otherwise.
     */
    bool m_working;

    /**
     * The print info object
     */
    Smb4KPrintInfo m_info;

    /**
     * Sets the device URI
     */
    void setDeviceURI();

    /**
     * Do normal printing.
     */
    void printNormal();

    /**
     * Print DVI files.
     */
    void printDVI();

    /**
     * Print text files
     */
    void printText();

    /**
     * The queue that holds the print requests
     */
    QQueue<Smb4KPrintInfo> m_queue;

    /**
     * If the process was aborted, this property is TRUE and FALSE
     * otherwise
     */
    bool m_aborted;

    /**
     * The process error code
     */
    QProcess::ProcessError m_process_error;
};

#endif
