#include <limits.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <alloca.h>
#include <iconv.h>
#include <stdbool.h>
#include "ut.h"

int Verbose;

enum{ EU16_08,EU16_13,U16E_08,U16E_13,EU8_08,EU8_13,
      U16U8,CNVMAX};
iconv_t Icv[CNVMAX];

__attribute__((constructor))
void iconv_ini(void)
{
    const char UTF16[]="utf-16le",UTF8[]="utf-8",
	       EUCJP[]="euc-jp",EUCX0213[]="euc-jisx0213";
    const char *cs[][2]={ /* to,from */
	{UTF16,EUCJP},
	{UTF16,EUCX0213},
	{EUCJP,UTF16},
	{EUCX0213,UTF16},
	{UTF8,EUCJP},
	{UTF8,EUCX0213},
	{UTF8,UTF16},
    };
    for(unsigned n=0; n<ITEMS(Icv); ++n)
	Icv[n] = iconv_open(cs[n][0],cs[n][1]);
}

__attribute__((destructor))
void iconv_fin(void)
{
    for(unsigned n=0; n<ITEMS(Icv); ++n)
	iconv_close(Icv[n]);
}

uint16_t* Swap2p(void *x,int dist)
{
    unsigned char *a,*b,c;
    a = (unsigned char*)x;
    b = a+dist;
    c = *a; *a = *b; *b = c;
    return (uint16_t*)x;
}

uint16_t Swap2(uint16_t x)
{
    return *Swap2p(&x,1);
}

uint16_t Swap2c(const void *x)
{
    return Swap2(*(const uint16_t*)x);
}

unsigned char* rev_copy(unsigned char* to,const unsigned char* from,int len)
{
    unsigned char* r = to;
    from += len;
    while(--len >= 0)
	*(to++) = *(--from);
    return r;
}

int* RevInt(int* x)
{
    int x0 = *x;
    return (int*)rev_copy((unsigned char*)x,(const unsigned char*)&x0,sizeof(int));
}

/*
  wchar_t礭gccwinegccǰ㤦
  ̤Υǥ쥯ȥgccȤǽ⤢Τǡ𤷤ʤ褦wchar_t,wcs...()
  Ȥ鷺˼δؿ뤳Ȥˤ롣
*/
int WcLen(const uint16_t* s)
{
    const uint16_t* s0 = s;
    while(*(s++) != 0)
	;
    return s-s0-1;
}
uint16_t* WcChr(uint16_t* s,uint16_t c)
{
    while(*s!=0 && *s!=c)
	++s;
    return (*s!=0 || c==0) ? s : NULL;
}
uint16_t* WcCpy(uint16_t* dst,const uint16_t* src)
{
    return memcpy(dst,src,(WcLen(src)+1)*2);
}

//ʸꥹȤn(>=0)ܤǤ֤
uint16_t* StrListNthWc(uint16_t* s,int nmax,int n)
{
    int x;
    for(x=0; x<n && x<nmax && *s!=0; ++x){
	s += WcLen(s)+1; //̥ʸμ
    }
    return (x<nmax && *s!=0) ? s : NULL;
}

/*
  canna eucjpwcharʸcharʸˤ롣
  ͤfree뤳ȡ
  cannaʤΤsrcβӥåȤ裱Хȡ壸ӥåȤ裲ХȤˤʤ롣
  Ⱦѥʤ0x8eĤƤʤ(裱ХȤϣ)
  cannajisx0212򣲥ХȤǰ裱ХȤѴ褦
*/
char* ToMb(const uint16_t* src)
{
    unsigned char uc,*dp;
    Array dst;
    
    ArNew(&dst,1,NULL);
    for(; *src!=0; ++src){
	if((*src & 0xff) != 0){
	    if((*src>>8) & 0x80){
		*(uint16_t*)ArExpand(&dst,2) = *src;
	    }else{ //jisx0212
		*(dp = ArExpand(&dst,3)) = 0x8f;
		*(uint16_t*)(dp+1) = *src|0x8000;
	    }
	}else{
	    uc = (unsigned char)(*src>>8);
	    if(uc>=0xa1 && uc<=0xdf){ //Ⱦѥ
		dp = ArExpand(&dst,2);
		*(dp++) = 0x8e;
	    }else
		dp = ArExpand(&dst,1);
	    *dp = uc;
	}
    }
    *(char*)ArExpand(&dst,1) = 0;
    return ArAdr(&dst);
}

/*
  eucjpcanna wcharˤ롣
  cannaʤΤsrcβӥåȤ裱Хȡ壸ӥåȤ裲ХȤˤʤ롣
  Ⱦѥʤ0x8eĤƤʤ(裱ХȤϣ)
  cannajisx0212򣲥ХȤǰ裱ХȤѴ褦
*/
uint16_t* ToWc(uint16_t* dst,const char* src)
{
    uint16_t *dst0,wc;

    if(dst == NULL)
	dst = malloc((EjLen(src)+1)*2);
    dst0 = dst;

    while(*src != 0){
	switch((uint8_t)*src){
	case 0x8e: //Ⱦѥ
	    wc = ((uint16_t)*(++src))<<8;
	    ++src;
	    break;
	case 0x8f: //0212
	    wc = *(uint16_t*)(++src) & 0x7fff;
	    src += 2;
	    break;
	case 0xa1 ... 0xff: //0208
	    wc = *(uint16_t*)src;
	    src += 2;
	    break;
	default: //ascii
	    wc = ((uint16_t)*(src++))<<8;
	}
	*(dst++) = wc;
    }
    *dst = 0;
    return dst0;
}

Array* Dump1(const char *fmt,const void *adr,int num,Array* a)
{
    const uint8_t *p = (const uint8_t *)adr;
    if(a == NULL)
	ArNew(a = malloc(sizeof(*a)),1,NULL);
    while(--num >= 0)
	ArPrint(a,fmt,*(p++));
    return a;
}
Array* Dump2(char *fmt,void *adr,int num,Array* a)
{
    uint16_t *p = (uint16_t*)adr;
    if(a == NULL)
	ArNew(a = malloc(sizeof(*a)),1,NULL);
    while(--num >= 0)
	ArPrint(a,fmt,*(p++));
    return a;
}
Array* Dump2le(char *fmt,void *adr,int num,Array* a)
{
    uint16_t *p = (uint16_t*)adr;
    if(a == NULL)
	ArNew(a = malloc(sizeof(*a)),1,NULL);
    for(; --num >= 0; ++p)
	ArPrint(a,fmt,((*p>>8)|(*p<<8))&0xffff);
    return a;
}
Array* Dump4(char *fmt,void *adr,int num,Array* a)
{
    uint32_t *p = (uint32_t*)adr;
    if(a == NULL)
	ArNew(a = malloc(sizeof(*a)),1,NULL);
    while(--num >= 0)
	ArPrint(a,fmt,*(p++));
    return a;
}

/*
  ɤʸ޻ˤ
*/
char* Zen2Roman(char* dest,const char* ej0)
{
    static const char* tab[]={
	"xa","a","xi","i","xu","u","xe","e","xo","o",
	"ka","ga","ki","gi","ku","gu","ke","ge","ko","go",
	"sa","za","si","zi","su","zu","se","ze","so","zo",
	"ta","da","ti","di","xtu","tu","du","te","de","to","do",
	"na","ni","nu","ne","no",
	"ha","ba","pa","hi","bi","pi","hu","bu","pu","he","be","pe","ho","bo","po",
	"ma","mi","mu","me","mo",
	"xya","ya","xyu","yu","xyo","yo",
	"ra","ri","ru","re","ro",
	"xwa","wa","wi","we","wo","nn"
    };
    static const char sym[]={ /* 0xa1xx */
	' ', 	',', 	'.', 	',', 	'.',	0,	':',	//a1
	';',	'?',	'!',	0,	0,	0,	'`',	0,	//a8
	'^',	'~',	'_',	0,	0,	0,	0,	0,	//b0
	0,	0,	0, 	0,	'-',	0,	0,	'/',	//b8
	'\\',	'-',	0,	'|',	0,	0,	0,	0,	//c0
	0,	0,	'(',	')',	0,	0,	'[',	']',	//c8
	'{',	'}',	'<',	'>',	0,	0,	'[',	']',	//d0
	0,	0,	0,	0,	'+',	'-',	0,	'*',	//d8
	'/',	'=',	0,	'<',	'>',	0,	0,	0,	//e0
	0,	0,	0,	0,	0,	0,	0,	'\\',	//e8
	'$',	0,	0,	'%',	'#',	'&',	'*',	'@'	//f0
    };
    const char* s;
    char* dest0=dest;
    unsigned char *ej=(unsigned char*)ej0;
    while(*ej != 0){
	if((*ej & 0x80) == 0){
	    //ascii
	    *(dest++) = *(ej++);
	}else{
	    switch(*(ej++)){
	    case 0xa1: //
		if(*ej>=0xa1 && *ej<=0xf7)
		    *(dest++) = sym[*ej-0xa1];
		++ej;
		break;
	    case 0xa3: //ե٥å
		*(dest++) = *(ej++)-0xb0+0x30;
		break;
	    case 0xa4:
		s = tab[*(ej++)-0xa1];
		strcpy(dest,s);
		dest += strlen(s);
	    }
	}
    }
    *dest = 0;
    return dest0;
}

/*
  sjisȾѥʤutf-16ѤҤ餬ʤľ
  ssz=srcΣʸΥХȿ
  opt=src˲û
  syn=
  ͡ȾѤǻȤäʸιǣʸȤȤ⤢
  dstsrcƱǤokssz==1ΤȤϼΥХȤ񤭤롣
*/
int sj_han_to_u16_zen(uint16_t* dst,const char* src,int ssz,unsigned char opt,int syn)
{
    static uint16_t as20[]={
	0x3000/* */,	0xff01/*!*/,	0x201d/*"*/,	0xff03/*#*/,	/*20*/
	0xff04/*$*/,	0xff05/*%*/,	0xff06/*&*/,	0x2019/*'*/,	/*24*/
	0xff08/*(*/,	0xff09/*)*/,	0xff0a/***/,	0xff0b/*+*/,	/*28*/
	0xff0c/*,*/,	0x2212/*-*/,	0xff0e/*.*/,	0xff0f/*/*/,	/*2c*/
	0xff10/*0*/,	0xff11/*1*/,	0xff12/*2*/,	0xff13/*3*/,	/*30*/
	0xff14/*4*/,	0xff15/*5*/,	0xff16/*6*/,	0xff17/*7*/,	/*34*/
	0xff18/*8*/,	0xff19/*9*/,	0xff1a/*:*/,	0xff1b/*;*/,	/*38*/
	0xff1c/*<*/,	0xff1d/*=*/,	0xff1e/*>*/,	0xff1f/*?*/,	/*3c*/
	0xff20/*@*/,	0xff21/*A*/,	0xff22/*B*/,	0xff23/*C*/,	/*40*/
	0xff24/*D*/,	0xff25/*E*/,	0xff26/*F*/,	0xff27/*G*/,	/*44*/
	0xff28/*H*/,	0xff29/*I*/,	0xff2a/*J*/,	0xff2b/*K*/,	/*48*/
	0xff2c/*L*/,	0xff2d/*M*/,	0xff2e/*N*/,	0xff2f/*O*/,	/*4c*/
	0xff30/*P*/,	0xff31/*Q*/,	0xff32/*R*/,	0xff33/*S*/,	/*50*/
	0xff34/*T*/,	0xff35/*U*/,	0xff36/*V*/,	0xff37/*W*/,	/*54*/
	0xff38/*X*/,	0xff39/*Y*/,	0xff3a/*Z*/,	0xff3b/*[*/,	/*58*/
	0xff3c/*bs*/,	0xff3d/*]*/,	0xff3e/*^*/,	0xff3f/*_*/,	/*5c*/
	0xff40/*`*/,	0xff41/*a*/,	0xff42/*b*/,	0xff43/*c*/,	/*60*/
	0xff44/*d*/,	0xff45/*e*/,	0xff46/*f*/,	0xff47/*g*/,	/*64*/
	0xff48/*h*/,	0xff49/*i*/,	0xff4a/*j*/,	0xff4b/*k*/,	/*68*/
	0xff4c/*l*/,	0xff4d/*m*/,	0xff4e/*n*/,	0xff4f/*o*/,	/*6c*/
	0xff50/*p*/,	0xff51/*q*/,	0xff52/*r*/,	0xff53/*s*/,	/*70*/
	0xff54/*t*/,	0xff55/*u*/,	0xff56/*v*/,	0xff57/*w*/,	/*74*/
	0xff58/*x*/,	0xff59/*y*/,	0xff5a/*z*/,	0xff5b/*{*/,	/*78*/
	0xff5c/*|*/,	0xff5d/*}*/,	0x301c/*~*/,	0x3000		/*7c*/
    };
    static uint16_t wk[]={
	0x3002/**/,	0x300c/**/,	0x300d/**/,	0x3001/**/,	/*0*/
	0x30fb/**/,	0x3092/**/,	0x3041/**/,	0x3043/**/,	/*1*/
	0x3045/**/,	0x3047/**/,	0x3049/**/,	0x3083/**/,	/*2*/
	0x3085/**/,	0x3087/**/,	0x3063/**/,	0x30fc/**/,	/*3*/
	0x3042/**/,	0x3044/**/,	0x3046/**/,	0x3048/**/,	/*4*/
	0x304a/**/,	0x304b/**/,	0x304d/**/,	0x304f/**/,	/*5*/
	0x3051/**/,	0x3053/**/,	0x3055/**/,	0x3057/**/,	/*6*/
	0x3059/**/,	0x305b/**/,	0x305d/**/,	0x305f/**/,	/*7*/
	0x3061/**/,	0x3064/**/,	0x3066/**/,	0x3068/**/,	/*8*/
	0x306a/**/,	0x306b/**/,	0x306c/**/,	0x306d/**/,	/*9*/
	0x306e/**/,	0x306f/**/,	0x3072/**/,	0x3075/**/,	/*10*/
	0x3078/**/,	0x307b/**/,	0x307e/**/,	0x307f/**/,	/*11*/
	0x3080/**/,	0x3081/**/,	0x3082/**/,	0x3084/**/,	/*12*/
	0x3086/**/,	0x3088/**/,	0x3089/**/,	0x308a/**/,	/*13*/
	0x308b/**/,	0x308c/**/,	0x308d/**/,	0x308f/**/,	/*14*/
	0x3093/**/,	0x309b/**/,	0x309c/**/
    };
    static uint16_t wd[]={
	0/**/,	0/**/,	0/**/,	0/**/,	/*0*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*1*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*2*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*3*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*4*/
	0/**/,	0x304c/**/,	0x304e/**/,	0x3050/**/,	/*5*/
	0x3052/**/,	0x3054/**/,	0x3056/**/,	0x3058/**/,	/*6*/
	0x305a/**/,	0x305c/**/,	0x305e/**/,	0x3060/**/,	/*7*/
	0x3062/**/,	0x3065/**/,	0x3067/**/,	0x3069/**/,	/*8*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*9*/
	0/**/,	0x3070/**/,	0x3073/**/,	0x3076/**/,	/*10*/
	0x3079/**/,	0x307c/**/,	0/**/,	0/**/,	/*11*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*12*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*13*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*14*/
	0/**/,	0/**/,	0/**/
    };
    static uint16_t wp[]={
	0/**/,	0/**/,	0/**/,	0/**/,	/*0*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*1*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*2*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*3*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*4*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*5*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*6*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*7*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*8*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*9*/
	0/**/,	0x3071/**/,	0x3074/**/,	0x3077/**/,
	0x307a/**/,	0x307d/**/,	0/**/,	0/**/,	/*11*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*12*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*13*/
	0/**/,	0/**/,	0/**/,	0/**/,	/*14*/
	0/**/,	0/**/,	0/**/
    };
    static uint16_t *wdp[]={wd,wp};

    char cc,nc;
    int len=1;
    uint16_t z;

    if(*src>0 && *(src+1)==0){
	z = as20[*src-0x20];
    }else{
	cc = *src+opt - 0xa1;
	nc = *(src+ssz)+opt - 0xde;
	if(syn && (nc==0 || nc==1) && (z=wdp[nc][cc])!=0){
	    ++len;
	}else
	    z = wk[cc];
    }
    *dst = z;
    return len;
}

/*
  sjisȾѥʸutf-16ѤҤ餬ʸľ
  srcΥ̥ʸlenʸ(Ⱦѥʤǿ)ޤǡ
  dstκǸ˥̥ʸɲä롣
  ͡ѤȾѥʸ
  dstsrcƱǤokssz==1ΤȤϤޤȤưʤ
 */
int SjHan2UniZen(uint16_t* dst,const char* src,int ssz,unsigned char opt,int syn,int len)
{
    int n;
    const char *src0=src;
    while(len>0 && *src!=0){
	n = sj_han_to_u16_zen(dst++,src,ssz,opt,syn);
	len -= n;
	src += n*ssz;
    }
    *dst = 0;
    return (src-src0)/ssz;
}

//eucjpʸƬnʸư롣
char* ForwardEj(char* ej,int n)
{
    while(--n >= 0 && *ej!=0){
	if(*ej == (char)0x8f)
	    ++ej;
	if(*(++ej) < 0)
	    ++ej;
    }
    return ej;
}

/*
  euc-jpʸ
*/
int EjLen(const char* ej)
{
    int len=0;
    while(*ej != 0){
	ej = ForwardEj((char*)ej,1);
	++len;
    }
    return len;
}

/*
  numˤEU16_08,U16E_08Ϥȡ
  08ǥ顼Ф13ȤȤꤢʸɤ¸ϤǤ롣
  08˻ȤΤ''ԣʸѴǤʤݤϽФʤϤåƤ
  ??? iconv*in˽񤭹ꤹ
*/
bool conv(int num,char** in,size_t* ileft,char** out,size_t* oleft)
{
    bool st;
    char *in0 = *in, *out0=*out;
    size_t ileft0 = *ileft;

    st = (iconv(Icv[num],in,ileft,out,oleft)!=(size_t)-1);
    if(st && *out==out0){
	*in = in0;
	*ileft = ileft0;
	st = false;
    }
    if(!st){
	st = (iconv(Icv[num+1],in,ileft,out,oleft)!=(size_t)-1);
    }
    return st;
}

//euc-jp --> ucs2
uint16_t* EjToU16(uint16_t* dst,char* src)
{
    uint16_t *dst0;
    size_t ileft=strlen(src),oleft=EjLen(src)*2;

    if(dst == NULL)
	dst = malloc(oleft+2);
    dst0 = dst;
    while(!conv(EU16_08,&src,&ileft,(char**)&dst,&oleft)){
	*(dst++) = 0xa125; //e-a2a2 u-25a1 ''
	oleft -= 2;
	if(*src == (char)0x8f){
	    ++src;
	    --ileft;
	}
	src += 2;
	ileft -= 2;
    }
    *dst = 0;
    //iconv(Icv[E2U08],NULL,NULL,NULL,NULL);
    //iconv(Icv[E2U13],NULL,NULL,NULL,NULL);
    return dst0;
}

//canna ej --> ucs2
uint16_t* CejToU16(uint16_t* dst,uint16_t* src)
{
    char *ej;

    dst = EjToU16(dst,ej = ToMb(src));
    free(ej);
    return dst;
}

/* ucs2 -->euc-jp
   ??? euc-jisx0213''ԣʸλϤ줺in-ptr,ileft롣
   euc-jpΤȤʤ櫓狼ʤ
   iconv(1)ǤϤɤäƤ
*/
char* U16ToEj(char* dst,uint16_t* src,int src_len)
{
    char *dst0;
    size_t ileft,oleft;

    if(src_len < 0)
	src_len = WcLen(src);
    ileft = src_len*2;
    oleft = src_len*3;
    if(dst == NULL)
	dst = malloc(oleft+1);
    dst0 = dst;
    while(!conv(U16E_08,(char**)&src,&ileft,&dst,&oleft)){
	*(dst++) = 0xa2; *(dst++) = 0xa2; //e-a2a2 u-25a1 ''
	oleft -= 2;
	++src;
	ileft -= 2;
    }
    *dst = 0;
    //iconv(Icv[U16E_08],NULL,NULL,NULL,NULL);
    //iconv(Icv[U16E_13],NULL,NULL,NULL,NULL);
    return dst0;
}

//ucs2 --> canna ej
uint16_t* U16ToCej(uint16_t* dst,uint16_t* src,int src_len)
{
    char *ej;

    ej = U16ToEj(NULL,src,src_len);
    dst = ToWc(dst,ej);
    free(ej);
    return dst;
}


//euc-jp --> utf8
char* EjToU8(char* dst,const char* src00)
{
    if(src00 == NULL)
	return NULL;

    size_t ileft=strlen(src00),oleft=EjLen(src00)*8;
    int tofu = 0xa196e2; //e-a2a2 u-25a1 t-e296a1 ''
    char *dst0,*src0,*src;

    src0 = src = strdup(src00);
    if(dst == NULL)
	dst = malloc(oleft+1);
    dst0 = dst;
    while(!conv(EU8_08,&src,&ileft,&dst,&oleft)){
	memcpy(dst,&tofu,3);
	dst += 3;
	oleft -= 3;
	if(*src == (char)0x8f){
	    ++src;
	    --ileft;
	}
	src += 2;
	ileft -= 2;
    }
    *dst = 0;
    free(src0);
    return dst0;
}

//utf16 --> utf8
char* U16ToU8(char* dst,uint16_t* src,int src_len)
{
    size_t ileft,oleft;
    char *dst0;

    if(src == NULL)
	return NULL;
    if(src_len < 0)
	src_len = WcLen(src);
    ileft = src_len*2;
    oleft = src_len*5;
    if(dst == NULL)
	dst = malloc(oleft+1);
    dst0 = dst;
    conv(U16U8,(char**)&src,&ileft,&dst,&oleft);
    *dst = 0;
    return dst0;
}

/*
  eucjpѥɤȾѥɤˤ
  ͡ȾѥɤǤʸ(1 or 2)
  dst˥̥ʸĤΤ,5Хɬס
*/
int EjZen2Han(char *dst,const char *src)
{
    /*
      ѤҤ餬(''(0xa4a1)...''(0xa4f4))Ⱦѥ
      1 1
      2 Ⱦ
      3 ȾѤΥ
    */
    static uint16_t hira2hkana[]={
	'','','','','','','','','','','',1,'',1,'',1,'',1,'',1,
	'',1,'',1,'',1,'',1,'',1,'',1,'',1,'','',1,'',1,'',1,'',
	'','','','','',1,2,'',1,2,'',1,2,'',1,2,'',1,2,'','','',
	'','','','','','','','','','','','','','','','','',
	'','',3
    };

    union {
	uint8_t u1[4];
	uint16_t u2[2];
	uint32_t u4;
    } wc;
    int len=1,moji=1,idx;

    wc.u1[1] = *(src++);
    if((wc.u1[1] & 0x80) == 0){
	//ascii
	*(dst++) = wc.u1[1];
	*dst = 0;
	return 1;
    }

    wc.u1[0] = *(src++);
    switch(wc.u2[0]){
    case '': wc.u1[1]=' '; break;
    case '': wc.u1[1]='!'; break;
    case '': wc.u1[1]='"'; break;
    case '': wc.u1[1]='#'; break;
    case '': wc.u1[1]='$'; break;
    case '': wc.u1[1]='%'; break;
    case '': wc.u1[1]='&'; break;
    case '': wc.u1[1]='\''; break;
    case '': wc.u1[1]='('; break;
    case '': wc.u1[1]=')'; break;
    case '': wc.u1[1]='*'; break;
    case '': wc.u1[1]='+'; break;
    case '': wc.u1[1]=','; break;
    case '': wc.u1[1]='-'; break;
    case '': wc.u1[1]='.'; break;
    case '': wc.u1[1]='/'; break;
    case '': wc.u1[1]=':'; break;
    case '': wc.u1[1]=';'; break;
    case '': wc.u1[1]='<'; break;
    case '': wc.u1[1]='='; break;
    case '': wc.u1[1]='>'; break;
    case '': wc.u1[1]='?'; break;
    case '': wc.u1[1]='@'; break;
    case '': wc.u1[1]='['; break;
    case '': wc.u1[1]='\\'; break;
    case '': wc.u1[1]=']'; break;
    case '': wc.u1[1]='^'; break;
    case '': wc.u1[1]='_'; break;
    case '': wc.u1[1]='`'; break;
    case '': wc.u1[1]='{'; break;
    case '': wc.u1[1]='|'; break;
    case '': wc.u1[1]='}'; break;
    case '': wc.u1[1]='~'; break;

    case '': wc.u2[0]=''; ++len; break;
    case '': wc.u2[0]=''; ++len; break;
    case '': wc.u2[0]=''; ++len; break;
    case '': wc.u2[0]=''; ++len; break;
    case '': wc.u2[0]=''; ++len; break;
    case '': wc.u2[0]=''; ++len; break;
    case '': wc.u2[0]=''; ++len; break;
    case '': wc.u2[0]=''; ++len; break;
    case '' ... '':
	wc.u1[1]=(uint8_t)(wc.u2[0]-''+'0'); break;
    case '' ... '':
	++len;
	wc.u2[0] = hira2hkana[idx=wc.u2[0]-''];
        switch(wc.u2[0]){
	case 1:
	    wc.u2[0] = hira2hkana[idx-1];
	    wc.u2[1] = '';
	    len += 2;
	    ++moji;
	    break;
	case 2:
	    wc.u2[0] = hira2hkana[idx-2];
	    wc.u2[1] = '';
	    len += 2;
	    ++moji;
	    break;
	case 3:
	    wc.u2[0] = '';
	    wc.u2[1] = '';
	    len += 2;
	    ++moji;
	}
	break;
    default:
	fprintf(stderr,"%s:illegal code 0x%04x\n",__FUNCTION__,wc.u2[0]);
    }
    for(idx=0; idx<4; idx+=2){
	dst[idx] = wc.u1[idx+1];
	dst[idx+1] = wc.u1[idx];
    }
    dst[len] = 0;
    return moji;
}

//////////////////////////////////////////////////////////////////////////

Array* wstr_add_nwcs(Array* s,const uint16_t *cs,int len)
{
    memcpy(ArExpand(s,len),cs,len*s->blocksize);
    return s;
}
Array* wstr_add_wc(Array* s,uint16_t c)
{
    return wstr_add_nwcs(s,&c,1);
}
Array* wstr_add_wcs(Array* s,const uint16_t* cs)
{
    return wstr_add_nwcs(s,cs,WcLen(cs));
}
Array* wstr_add_wstr(Array* s,const Array* p)
{
    return wstr_add_nwcs(s,p->adr,p->use);
}

//asciiϥȥ륨ǥǵϿ
Array *wstr_add_zen2han_ej(Array* out,const uint16_t* h)
{
    int m,n;
    uint16_t dst[3];

    for(; *h!=0; ++h){
	m = EjZen2Han((char*)dst,(char*)h);
	for(n=0; n<m; ++n){
	    if(dst[n]<0x100)
		dst[n] = Swap2(dst[n]);
	    wstr_add_wc(out,dst[n]);
	}
    }
    return out;
}
Array* wstr_add_hira2kata_ej(Array* s,const uint16_t* h)
{
    uint16_t c;
    for(; *h!=0; ++h){
	c = Swap2(*h);
	if(c>=0xa4a1 && c<=0xa4f4)
	    c += 0x100; //0xa4xx --> 0xa5xx
	wstr_add_wc(s,Swap2(c));
    }
    return s;
}
