#ifndef WIME_UT_H
#define WIME_UT_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include "array.h"

#define ITEMS(v) (sizeof(v)/sizeof(v[0]))
#define MEMBERSIZE(s,m) sizeof(((s*)0)->m)
#define OFFSETOF(type,member) ((int)&(((type*)0)->member))
#define UNUSED __attribute__((unused))

int WcLen(const uint16_t* s);
uint16_t* WcChr(uint16_t* s,uint16_t c);
uint16_t* WcCpy(uint16_t* dst,const uint16_t* src);
uint16_t* StrListNthWc(uint16_t* s,int nmax,int n);
char* ToMb(const uint16_t *src);
uint16_t* ToWc(uint16_t* dst,const char* src);

uint16_t* Swap2p(void *x,int dist);
uint16_t Swap2(uint16_t x);
uint16_t Swap2c(const void *x);
#define Swap4 __builtin_bswap32
static inline int32_t Swap4c(const void *x){return Swap4(*(int32_t*)x);}
int* RevInt(int* x);

    Array* wstr_add_nwcs(Array* s,const uint16_t *cs,int len);
    Array* wstr_add_wc(Array* s,uint16_t c);
    Array* wstr_add_wcs(Array* s,const uint16_t *cs);
    Array* wstr_add_wstr(Array* s,const Array* p);
    Array* wstr_add_zen2han_ej(Array *s,const uint16_t *h);
    Array* wstr_add_hira2kata_ej(Array* s,const uint16_t* h);

Array* Dump1(const char *fmt,const void *adr,int num,Array* a);
Array* Dump2(char *fmt,void *adr,int num,Array* a);
Array* Dump2le(char *fmt,void *adr,int num,Array* a);
Array* Dump4(char *fmt,void *adr,int num,Array* a);
char* ForwardEj(char* ej,int n);
int EjLen(const char* ej);
int EjZen2Han(char *dst,const char *src);
char* Zen2Roman(char* dest,const char* ej);
    int SjHan2UniZen(uint16_t* dst,const char* src,int ssz,unsigned char opt,int syn,int len);

    uint16_t* EjToU16(uint16_t* dst,char* src);
    uint16_t* CejToU16(uint16_t* dst,uint16_t* src);
    char* U16ToEj(char* dst,uint16_t* src,int src_len);
    uint16_t* U16ToCej(uint16_t* dst,uint16_t* src,int src_len);
    char* EjToU8(char* dst,const char* src0);
    char* U16ToU8(char* dst,uint16_t* src,int src_len);

#ifdef __cplusplus
}
#endif

#endif
