#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <signal.h>
#include <semaphore.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/mman.h>
#include "corr.h"
#include "wimeapi.h"
#include "ut.h"

/*
  initialize,finalizeʳlongjmpǽ롣
*/

int Fd = -1;
int GlobalCxn;
jmp_buf WimeJmp;

int LogMark; //catch_restart_wimeѤ˻äƤåɽˤȤ
#define LOGMARK LogMark

Array LibCxn;
#define EMPTY_CXN_CELL -1

#define SEMNAME "/wimesem"
#define SHMNAME "/.wimeshm"
sem_t *Sem;
pid_t *Pid;
int PidOffset;
#define PIDTAB_SIZE (sizeof(*Pid)*PID_MAX)
struct sigaction RestartSigLink; //WIMERESTARTSIGˤȤȤä

//wimeio.c
const char* MakeSocketPath(int socket_num);
extern char SocketPath[];

//wimeƥȤΥʥ
//!!! LibCxnΥϥå٤
void catch_restart_wime(int signum UNUSED)
{
    int x,*cxp;
    int16_t cxn;

    wime_disconnect();
    WimeInitialize(0,0);
    MSG("recreate context\n");

    for(x=0,cxp=ArAdr(&LibCxn); x<ArUsing(&LibCxn); ++x,++cxp){
	if(*cxp != EMPTY_CXN_CELL){
	    if(!Snd1(Fd,CANNA_CREATE_CONTEXT) || !Rcv5(Fd,&cxn) || cxn==-1)
		ERR("can not create context\n");
	    else
		*cxp = cxn;
	}
    }
}

__attribute__((constructor))
void wime_api_init(void)
{
    /*
      åȤΥե뤬ĤäƤsocket()ΤFdĤ뤬
      ˽񤭹⤦ȤSIGPIPE롣
      !!!äΤSIGPIPEΥ顼ϥɥ餫longjmp狼䤹
    */
    signal(SIGPIPE,SIG_IGN);

    struct sigaction a;
    memset(&a,0,sizeof(a));
    a.sa_handler = catch_restart_wime;
    sigaction(WIMERESTARTSIG,&a,&RestartSigLink);
}

void wime_disconnect(void)
{
    if(Fd != -1){
	close(Fd);
	Fd = -1;
    }
}

bool wime_connect(void)
{
    if(Fd != -1)
	return true;

    bool st;
    struct sockaddr_un sock_name;
    if((Fd = socket(AF_UNIX,SOCK_STREAM,0)) == -1)
	return false;
    sock_name.sun_family = AF_UNIX;
    strcpy(sock_name.sun_path,SocketPath);
    if(!(st=(connect(Fd,(struct sockaddr*)&sock_name,SUN_LEN(&sock_name))==0)))
	wime_disconnect();
    return st;
}

//logmark==0ΤȤϺƥȥʥϥɥ餫θƤӽФ
void wime_shm_init(int logmark)
{
    struct stat sb;
    int shm;
    pid_t pid = getpid();

    if(logmark != 0)
	LogMark = logmark;

    Sem = sem_open(SEMNAME,O_CREAT,0666,1);
    sem_wait(Sem);
    shm = shm_open(SHMNAME,O_RDWR|O_CREAT,0666);
    fstat(shm,&sb);
    if(sb.st_size == 0){ //
	ftruncate(shm,PIDTAB_SIZE);
    }
    Pid = mmap(NULL,PIDTAB_SIZE,PROT_READ|PROT_WRITE,MAP_SHARED,shm,0);
    close(shm);
    if(LogMark == SERVER_MARK){
	//wime
	if(Pid[PID_WIME] != 0){ //Ǥpid=Ƶư
	    for(int x=PID_CLIENT; x<PID_MAX; ++x){
		if(Pid[x] != 0){
		    MSG("send restart signal to pid %d\n",Pid[x]);
		    if(kill(Pid[x],WIMERESTARTSIG) != 0)
			Pid[x] = 0; //̵pidä
		}
	    }
	}
	PidOffset = PID_WIME;
    }else{
	//xim,gim
	//wimeκƵưˤ³ǤФǤpidϿƤ
	for(PidOffset=PID_CLIENT; PidOffset<PID_MAX; ++PidOffset)
	    if(Pid[PidOffset] == pid)
		break;
	if(PidOffset == PID_MAX){
	    for(PidOffset=PID_CLIENT; PidOffset<PID_MAX; ++PidOffset)
		if(Pid[PidOffset] == 0)
		    break;
	    if(PidOffset == PID_MAX)
		ERR("PID TABLE FULL.\n");
	}
    }
    if(PidOffset < PID_MAX){
	Pid[PidOffset] = pid;
	msync(Pid+PidOffset,sizeof(*Pid),MS_SYNC);
    }
    sem_post(Sem);
}

void wime_shm_fin(void)
{
    int use_shm;

    sem_wait(Sem);
    if(PidOffset < PID_MAX){
	Pid[PidOffset] = 0;
	msync(Pid+PidOffset,sizeof(*Pid),MS_SYNC);
    }
    for(use_shm=0; use_shm<PID_MAX; ++use_shm)
	if(Pid[use_shm] != 0)
	    break;
    sem_post(Sem);
    munmap(Pid,PIDTAB_SIZE);
    sem_close(Sem);
    if(use_shm == PID_MAX){ //ȤäƤץʤʤä
	shm_unlink(SHMNAME);
	sem_unlink(SEMNAME);
    }
}

//LibCxnζν
void libcxn_ctr(void* adr)
{
    *(int*)adr = EMPTY_CXN_CELL;
}

//logmark==0ΤȤϺƥȥʥϥɥ餫θƤӽФ
bool WimeInitialize(int socket_num,int logmark)
{
    //3.3λͽ3.6p4ä2.0äꤷƤ뤬,Ȥꤢ3.6ˤƤ
    //???ĶѿUSERɬȤƤΤ
    bool st=false;
    int x,cxn;

    if(MakeSocketPath(socket_num) && wime_connect()
       && Snd0(Fd,"3.6",getenv("USER")) && (cxn = Rcv0(Fd,&x))!=-1){
	st = true;

	//LibCxn[0]ϥХ륳ƥ
	if(logmark == 0)
	    *(int*)ArAdr(&LibCxn) = cxn;
	else
	    *(int*)ArAlloc(ArNewPs(&LibCxn,sizeof(int),libcxn_ctr,16),1) = cxn;

	wime_shm_init(logmark);
    }else
	wime_disconnect();
    return st;
}

bool WimeFinalize(void)
{
    bool st = false;
    char code;
    int x,*cxp;
    if(Fd != -1){
	//Ƥ륳ƥȤĤ
	cxp = ArAdr(&LibCxn);
	for(x=0; ++cxp,x<ArUsing(&LibCxn); ++x){
	    if(*cxp != EMPTY_CXN_CELL)
		WimeCloseContext(*cxp);
	}
	ArDelete(&LibCxn);

	st = (Snd1(Fd,CANNA_FINALIZE) && Rcv2(Fd,&code) && code==0);
	wime_disconnect();
	wime_shm_fin();
    }
    return st;
}

//connect()ǤɤʤΤǡtrueǤwimeʤǽ⤢
bool WimeIsConnected()
{
    return (Fd!=-1);
}

void error_jump(void)
{
    wime_disconnect();
    longjmp(WimeJmp,1);
}

int translate_cx(int n)
{
    if(n<0 || n>=ArUsing(&LibCxn))
	longjmp(WimeJmp,1);
    return *(int*)ArElem(&LibCxn,n);
}
	
//顼λ-1
int WimeCreateContext(void)
{
    int16_t cxn;
    int idx=-1,*adr,emp=EMPTY_CXN_CELL;

    if(!Snd1(Fd,CANNA_CREATE_CONTEXT) || !Rcv5(Fd,&cxn))
	error_jump();
    if(cxn != -1){
	if((idx = ArFind(&LibCxn,PID_CLIENT,&emp)) == -1){
	    idx = ArUsing(&LibCxn);
	    adr = ArExpand(&LibCxn,1);
	}else
	    adr = ArElem(&LibCxn,idx);
	*adr = cxn;
    }
    return idx;
}

bool WimeCloseContext(int cxn)
{
    char code;
    int *adr;
    bool st;

    adr = ArElem(&LibCxn,cxn);
    if(adr==NULL || !Snd2(Fd,CANNA_CLOSE_CONTEXT,*adr) || !Rcv2(Fd,&code))
	error_jump();
    if((st = (code == 0)))
	*adr = EMPTY_CXN_CELL;
    return st;
}

int WimeGetGlobalContext(void)
{
    return 0;
}

/*
  ĥץȥֹ֤
  顼λ0
*/
int query_extension(const char* name)
{
    int num=0;
    char code;
    const char *names[]={name,NULL};
    if(!Snd17a(Fd,CANNA_QUERY_EXTENSIONS,names) || !Rcv2(Fd,&code))
	error_jump();
    num = code+1; //ֹ֤"ץȥֹ-1"+1Τǥ顼λ0ˤʤ
    if(num != 0)
	num |= 0x0100;
    return num;
}

bool WimeOpenIMEDialog(int type)
{
    static int prn=0;
    char code=-1;

    if(prn == 0)
	prn = query_extension(__func__);
    if(prn!=0){
	if(!Snd2(Fd,prn,(int16_t)type) || !Rcv2(Fd,&code))
	    error_jump();
    }
    return code!=-1;
}

bool WimeKillServer(void)
{
    char code;
    if(!Snd1(Fd,CANNA_KILL_SERVER) || !Rcv2(Fd,&code))
	error_jump();
    return code==0;
}

bool WimeAutoConvert(int cxn,int bufsize,int mode)
{
    char code;
    cxn = translate_cx(cxn);
    if(!Snd5(Fd,CANNA_AUTO_CONVERT,(int16_t)cxn,(uint16_t)bufsize,(int32_t)mode) || !Rcv2(Fd,&code))
	error_jump();
    return code==0;
}

/*
  ͤmallocǳݤ
*/
int* WimeListContext(int* len)
{
    static int prn=0;
    int *lst=NULL;
    Rply7_t *r;

    *len = 0;
    if(prn==0)
	prn = query_extension(__func__);
    if(prn!=0){
	if(!Snd1(Fd,prn) || (r = RcvN(Fd,NULL,0))==NULL)
	    error_jump();
	lst = malloc((*len = r->p1)*sizeof(int));
	for(int x=0; x<*len; ++x)
	    lst[x] = Swap2(r->p2[x]);
	free(r);
    }
    return lst;
}

//ɲðint
bool WimeSetCompWin(int cxn,int style,...)
{
    static int prn=0;
    char code=false;

    if(prn==0)
	prn = query_extension(__func__);
    if(prn!=0){
	int pn;
	uint16_t params[4];
	va_list vl;

	va_start(vl,style);
	switch(style){
	case WIME_POS_DEFAULT:
	    pn = 0;
	    break;
	case WIME_POS_FORCE:
	case WIME_POS_POINT:
	    pn = 2;
	    break;
	case WIME_POS_RECT:
	    pn = 4;
	}
	for(int n=0; n<pn; ++n)
	    params[n] = va_arg(vl,int);
	va_end(vl);
	cxn = translate_cx(cxn);
	if(!Snd11r(Fd,prn,cxn,style,params,pn) || !Rcv2(Fd,&code))
	    error_jump();
    }
    return code;
}

/*
  ime˽줿Ȥtrue
  sc	8bit=winβۥ,8bit=winΥեȥӥå
  ʸ󤬤mallocres֤
*/
bool WimeSendKey(int cxn,unsigned sc,char** res)
{
    static int prn=0;
    int16_t proc=0;

    cxn = translate_cx(cxn);
    if(prn==0)
	prn = query_extension(__func__);
    if(prn!=0)
	if(!Snd3(Fd,prn,cxn,sc) || !Rcv6(Fd,&proc,res))
	    error_jump();
    return (proc>0);
}

/*
  en_ime=imeѲǽˤ롣
  use_st=ơɥɽ롣en_ime==falseΤȤ̵뤵falseˤʤ롣
  use_comp=Ѵɥɽ롣en_ime==falseΤȤ̵뤵falseˤʤ롣
*/
bool WimeEnableIme(int cxn,bool en_ime,bool use_st,bool use_comp)
{
    static int prn=0;
    char code=false;

    cxn = translate_cx(cxn);
    if(prn==0)
	prn = query_extension(__func__);
    if(prn!=0)
	if(!Snd9(Fd,prn,cxn,en_ime,use_st,use_comp) || !Rcv2(Fd,&code))
	    error_jump();
    return code;
}

/*
  imcıƥɥΰ֤礭ѹ
  (x,y),(w,h)줾Τɤ餫ǤлѤʤ
*/
bool WimeMoveShadowWin(int cxn,int x,int y,int w,int h)
{
    static int prn=0;
    int16_t ax[]={x,y,w,h};
    char code=false;

    cxn = translate_cx(cxn);
    if(prn==0)
	prn = query_extension(__func__);
    if(prn!=0)
	if(!Snd11r(Fd,prn,cxn,0,(uint16_t*)ax,ITEMS(ax)) || !Rcv2(Fd,&code))
	    error_jump();
    return code;
}

/*
  ѴɥΥեȤطʿꤹ
  ͡եȤι⤵(ԥ)顼λ0
*/
int WimeSetCompFont(int cxn,const char* font,unsigned bg)
{
    static int prn=0;
    int16_t h=0;

    cxn = translate_cx(cxn);
    if(prn==0)
	prn = query_extension(__func__);
    if(prn!=0)
	if(!Snd15(Fd,prn,bg,cxn,font) || !Rcv5(Fd,&h))
	    error_jump();
    return h;
}

/*
  ơɥɽ
*/
bool WimeShowStatusWindow(int cxn,bool shw)
{
    static int prn=0;
    int16_t st=false;

    cxn = translate_cx(cxn);
    if(prn==0)
	prn = query_extension(__func__);
    if(prn!=0)
	if(!Snd3(Fd,prn,cxn,shw) || !Rcv5(Fd,&st))
	    error_jump();
    return st;
}

/*
  Ѵʸȥ롣
  ʸmallocǳݤ롣
 */
char* WimeGetCompStr(int cxn,WimeCompStrInfo* si)
{
    static int prn=0;
    char status,*str=NULL,*dum=NULL;

    str = dum = NULL;
    cxn = translate_cx(cxn);
    if(prn==0)
	prn = query_extension(__func__);
    if(prn!=0)
	if(!Snd2(Fd,prn,cxn) || !Rcv10(Fd,&status,&str,&dum,(int32_t*)si))
	    error_jump();
    free(dum);
    if(status < 0){ //ѴʸϤʤä
	free(str);
	str = NULL;
    }
    return str;
}

/*
  ImmGetCompositionWindow
  :WIME_POS_xxx
	顼λ0
*/
int WimeGetCompWin(int cxn,int* x,int* y,int* w,int* h)
{
    static int prn=0;
    int v[5],*vp;
    char st=false;

    cxn = translate_cx(cxn);
    if(prn==0)
	prn = query_extension(__func__);
    if(prn!=0)
	if(!Snd2(Fd,prn,cxn) || !Rcv4(Fd,&st,vp=v))
	    error_jump();
    if(st){
	++vp; //style
	*x = *(vp++);
	*y = *(vp++);
	*w = *(vp++);
	*h = *vp;
    }else
	v[0] = 0;
    return v[0];
}

/*
  style=WIME_POS_POINT,WIME_POS_EXCLUDE
  WIME_POS_EXCLUDEΤȤɲðx,y,w,h
*/
bool WimeSetCandWin(int cxn,int style,int x,int y,...)
{
    static int prn=0;
    int16_t ax[6]={x,y};
    char code=false;

    cxn = translate_cx(cxn);
    if(prn==0)
	prn = query_extension(__func__);
    if(style == WIME_POS_EXCLUDE){
	va_list vl;
	va_start(vl,y);
	for(int n=0; n<4; ++n)
	    ax[2+n] = va_arg(vl,int);
	va_end(vl);
    }
    if(prn!=0)
	if(!Snd11r(Fd,prn,cxn,style,(uint16_t*)ax,ITEMS(ax)) || !Rcv2(Fd,&code))
	    error_jump();
    return code;
}

/*
  cxnбXΥɥϿ롣
*/
void WimeRegXWindow(int cxn,unsigned w)
{
    static int prn=0;

    if(prn==0)
	prn = query_extension(__func__);
    if(prn!=0){
	PktRegXWin p = {translate_cx(cxn),w};
	if(!SndN(Fd,prn,&p,sizeof(p)))
	    error_jump();
    }
}

/*
  ʸutf16֤
  ͤfree뤳ȡ
*/
uint16_t* WimeGetResultStr(int cxn)
{
    static int prn=0;
    CanHeader *q=NULL;

    if(prn==0)
	prn = query_extension(__func__);
    if(prn!=0){
	PktCxNum p = {translate_cx(cxn)};
	if(!SndN(Fd,prn,&p,sizeof(p)) || (q=RcvN(Fd,NULL,0))==NULL)
	    error_jump();
	if(q->Length == 0){
	    free(q);
	    q = NULL;
	}else
	    memcpy(q,q+1,q->Length);
    }
    return (uint16_t*)q;
}

/*
  ejѴλʸȤcxn롣
  cxnλϤͤwime serverǤΥƥidȤƤΤޤ޻Ȥ
*/
bool WimeSetResultStr(int cxn,const char* ej)
{
    static int prn=0;
    bool st=false;

    if(prn==0)
	prn = query_extension(__func__);
    if(prn!=0){
	char buf[sizeof(PktResultStr)+strlen(ej)+1];
	PktResultStr *p = (typeof(p))buf;
	p->cxn = cxn>0 ? translate_cx(cxn) : -cxn;
	strcpy(p->str,ej);
	if(!SndN(Fd,prn,&buf,sizeof(buf)))
	    error_jump();
	st = true;
    }
    return st;
}
