#ifndef WIME_WIMEAPI_H
#define WIME_WIMEAPI_H

#include <setjmp.h>
#include <sys/types.h>

//winβۥɤξ̥Х
#define WINMODKEY_SHIFT		1
#define WINMODKEY_CTRL		2
#define WINMODKEY_ALT		4
#define WINMODKEY_HANKAKU	8
#define VKMODKEY(m)		((m)<<8)

#define AUX_INPUT_MOD	(Mod1Mask|Mod2Mask|Mod3Mask|Mod4Mask|Mod5Mask)

#include <stdbool.h>
#include <stdint.h>
#include <semaphore.h>

typedef struct{
    int32_t	CursorPos;	//
    int32_t	DeltaStart;
    int32_t	TargetClause;	//ʸƬ(ʤ-1)
    int32_t	TargetClLen;	//ʸʸ
    int32_t	Length;		//ʸ
} WimeCompStrInfo;

enum{
    WIME_ERROR,

    //CFS_xxx
    WIME_POS_DEFAULT,
    WIME_POS_FORCE,
    WIME_POS_POINT,
    WIME_POS_RECT,
    WIME_POS_EXCLUDE
};

//WimeGetCompFontǻȤեȾ(32bit)
typedef struct{
    int32_t Height, Width, Weight, Italic;
} WimeCompFontInfo;

bool wime_connect(void);
void wime_disconnect(void);
void wime_shm_init(int logmark);
void wime_shm_fin(void);

bool WimeIsConnected();
bool WimeInitialize(int socket_num,int logmark);
bool WimeFinalize(void);
int WimeCreateContext(void);
bool WimeCloseContext(int cxn);
int WimeGetGlobalContext(void);
bool WimeOpenIMEDialog(int type);
bool WimeKillServer(void);
bool WimeAutoConvert(int cxn,int bufsize,int mode);
int* WimeListContext(int* sz);
bool WimeSetCompWin(int cxn,int style,...);
int WimeGetCompWin(int cxn,int* x,int* y,int* w,int* h);
bool WimeSendKey(int cxn,unsigned sc,char** res);
bool WimeEnableIme(int cxn,bool en_ime,bool use_st,bool use_comp);
bool WimeMoveShadowWin(int cxn,int x,int y,int w,int h);
int WimeSetCompFont(int cxn,const char* font,unsigned bg);
bool WimeShowStatusWindow(int cxn,bool shw);
char* WimeGetCompStr(int cxn,WimeCompStrInfo*);
bool WimeSetCandWin(int cxn,int style,int x,int y,...);
void WimeRegXWindow(int cxn,unsigned w);
uint16_t* WimeGetResultStr(int cxn);
bool WimeSetResultStr(int cxn,const char* ej);

#define WIMERESTARTSIG SIGUSR1
enum{
    PID_WIME,
    PID_CLIENT,
    PID_MAX=256
};
extern pid_t *Pid;

extern int GlobalCxn;
extern jmp_buf WimeJmp;

#include "wimelog.h"

#endif
