#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <string.h>
#include <stdint.h>
#include <stdlib.h>
#include <locale.h>
#include "wimexim.h"
#include "link.h"
#include "wimeapi.h"
#include "winkey.h"
#include "xres.h"

ToggleKey *ToggleKeys; //Ѵȥ륭ȥեȾ
char *DefaultCompFont;	//ѴɥΥե

#define SERVERNAME "wime"

void on_selection_request(Display* disp,Window win,XSelectionRequestEvent* ev);
void on_client_message(Display* disp,Window win,XClientMessageEvent* ev);
Window make_server(int ac,char* av[],Display* disp);
void context_list_cr(void* p);
Window add_proxy(Display* disp,Window c);
void get_comp_font(Display* disp);
void destroy_client(XDestroyWindowEvent* ev);
void reset_req_func_tab(bool enable_wime);

//windowXimHeaderWxContextõ
WxContext* none_imic(Window,XimHeader*,int*,int*);
WxContext* have_imic(Window,XimHeader*,int*,int*);
WxContext* have_im(Window,XimHeader*,int*,int*);

enum{
    WIMEXIM_PROP,	// _XIM_WIMEXIM_PROP
    XIM_PROTOCOL,	// _XIM_PROTOCOL
    SERVER,		// @server=wime
    XIM_SERVERS,	// XIM_SERVERS

    //ΣĤ˺äƤʤSelectionRequestǤʤߤ
    XIM_XCONNECT,	// _XIM_XCONNECT
    LOCALES,		// LOCALES
    TRANSPORT,		// TRANSPORT

    ATOM_MAX
};
Atom Atm[ATOM_MAX];

Array ContextList;

int main(int ac,char* av[])
{
    Display* disp;
    Window win;
    XEvent ev;
    const char *atom_str[]={
	"_XIM_WIMEXIM_PROP",
	"_XIM_PROTOCOL",
	"@server=" SERVERNAME,
	"XIM_SERVERS",
	"_XIM_XCONNECT",
	"LOCALES",
	"TRANSPORT"
    };

    if(setlocale(LC_ALL,"") == NULL){
	ERR("cannot set locale\n");
	return 1;
    }
    if(!XSupportsLocale()){
	ERR("not support locale\n");
	return 1;
    }
    if(!WimeInitialize(0,LOGMARK)){
	ERR("cannot connect wime\n");
    }

    Verbose = 1;
    disp = XOpenDisplay(NULL);
    InitDatabase(disp,"xim");
    ToggleKeys = GetConvKeyFromResource(disp);
    get_comp_font(disp);
    ArNew(&ContextList,sizeof(WxContext),context_list_cr);
    for(int i=0; i<ATOM_MAX; ++i)
	Atm[i] = XInternAtom(disp,atom_str[i],False);
    win = make_server(ac,av,disp);

    while(1){
	XNextEvent(disp,&ev);
	switch(ev.type){
	case SelectionRequest:
	    on_selection_request(disp,win,(XSelectionRequestEvent*)&ev);
	    break;
	case ClientMessage:
	    on_client_message(disp,win,(XClientMessageEvent*)&ev);
	    break;
	case DestroyNotify:
	    destroy_client((XDestroyWindowEvent*)&ev);
	    break;
	case ConfigureNotify: //root windowϤԽư
	    MoveInputWindow(disp,(XConfigureEvent*)&ev);
	    break;
#if 0
	default:
	    MSG("EVENT:%d\n",ev.type);
#endif
	}
    }
    WimeFinalize();
    XCloseDisplay(disp);
    return 0;
}

//饤ȥɥĤ줿
void destroy_client(XDestroyWindowEvent* ev)
{
    int imid,icid;
    WxContext *cx;

    if((cx = none_imic(ev->window,NULL,&imid,&icid)) != NULL){
	LOG("destroy notify proxy %p client %p\n",cx->Proxy,cx->Client);
	if(setjmp(WimeJmp) == 0)
	    DisconnectClient(NULL,cx);
    }
}

bool proc_client_message(Display* disp,Window win,XClientMessageEvent* ev,XimHeader* h);
XimHeader* get_message(Display* disp,Window win,XClientMessageEvent* ev);
void preconnect(Display* disp,XClientMessageEvent* ev);

typedef struct{
    Display *disp;
    Window win;
    XClientMessageEvent ev;
    XimHeader *pkt; //ץѥƥͳΥǡΥɥ쥹롣
} QueueData;
BiLink *EventQ;

void on_client_message(Display* disp,Window win,XClientMessageEvent* ev)
{
    QueueData *q;
    XimHeader *h,*qh;
    bool st;

    if(ev->message_type == Atm[XIM_XCONNECT]){
	preconnect(disp,ev);
    }else if(ev->message_type == Atm[XIM_PROTOCOL]){
	h = get_message(disp,ev->window,ev);
	st = proc_client_message(disp,win,ev,h);

	//塼˻ĤäƤѥåȤнƤߤ
	BiLink* c=EventQ;
	while(c!=NULL){
	    LOG("check queue\n");
	    q = c->obj;
	    qh = q->pkt!=NULL ? q->pkt : get_message(q->disp,q->win,&q->ev);
	    if(proc_client_message(q->disp,q->win,&q->ev,qh)){
		//ǤΤǡ塼ƥ塼ƬƸ
		if((char*)qh != q->ev.data.b)
		    XFree(qh);
		free(LkRemove(&EventQ,c));
		c = EventQ;
		continue;
	    }
	    c = c->next;
	}

	if(st){
	    if((char*)h != ev->data.b) //XGetWindowPropertyǤǡ
		XFree(h);
	}else{
	    q = malloc(sizeof(QueueData));
	    q->disp = disp;
	    q->win = win;
	    q->ev = *ev;
	    q->pkt = (char*)h!=ev->data.b ? h : NULL;
	    LkPushEnd(&EventQ,q);
	}
    }
}

/*
  ³ _XIM_XCONNECTν
*/
void preconnect(Display* disp,XClientMessageEvent* ev)
{
    XEvent ne;
    ne.xclient.type = ClientMessage;
    ne.xclient.window = ev->data.l[0];
    ne.xclient.message_type = Atm[XIM_XCONNECT];
    ne.xclient.format = 32;
    ne.xclient.data.l[0] = add_proxy(disp,ev->data.l[0]);
    ne.xclient.data.l[1] = 0; //only-CM and
    ne.xclient.data.l[2] = 0; // property-with-CM
    ne.xclient.data.l[3] = PACKET_MAX_SIZE; //CMİʾλϥץѥƥȤ
    XSendEvent(disp,ne.xclient.window,False,NoEventMask,&ne);
    LOG("xconnect:client-id=%lx version=%ld/%ld proxy-window=%lx\n",ev->data.l[0],ev->data.l[1],ev->data.l[2],ne.xclient.data.l[0]);
    /*
      ʹ_XIM_PROTOCOLǥǡ櫓windowФϼ
      ʬʥСˤˤʤäƤ롣ȤȤïФʬ
      ʤʤΤǡ³ȤwindowĤ뤳Ȥˤ롣
      windowФˤwindowäƤΤǡбɽ
      Х饤windowʬ롣
    */
}

Window make_server(int ac,char* av[],Display* disp)
{
    Atom *data,type;
    int format;
    unsigned long ndata,r;
    Window win,root;
    const char name[]=SERVERNAME;
    XTextProperty np={(unsigned char*)name,XA_STRING,8,sizeof(name)-1};

    root = DefaultRootWindow(disp);
    win = XCreateSimpleWindow(disp,root,0,0,1,1,0,0,WhitePixel(disp,DefaultScreen(disp)));
    LOG("create disp=%p win=%x\n",disp,(unsigned)win);
    XSetWMProperties(disp,win,&np,&np,av,ac,NULL,NULL,NULL);

    XSetSelectionOwner(disp,Atm[SERVER],win,CurrentTime);

    //XIM_SERVERSɲä
    if(XGetWindowProperty(disp,root,Atm[XIM_SERVERS],0,40*1024/4,False,XA_ATOM,&type,&format,&ndata,&r,(unsigned char**)&data) == Success){
	unsigned long n;
	for(n=0; n<ndata && data[n]!=Atm[SERVER]; ++n)
	    ;
	if(n < ndata){ //ǤϿƤ
	    data[n] = data[--ndata]; //ָΥǡǾ
	    XChangeProperty(disp,root,Atm[XIM_SERVERS],XA_ATOM,32,PropModeReplace,(unsigned char*)data,ndata);
	}
	XFree(data);
    }
    XChangeProperty(disp,root,Atm[XIM_SERVERS],XA_ATOM,32,PropModeAppend,(unsigned char*)&Atm[SERVER],1);

    return win;
}

//LOCALESTRANSPORT
void on_selection_request(Display* disp,Window win,XSelectionRequestEvent* ev)
{
    VERBOSE(MSG("disp=%p win=%x\n",disp,(unsigned)win);
	    MSG("\t%s %s %s\n",XGetAtomName(disp,ev->selection),XGetAtomName(disp,ev->target),XGetAtomName(disp,ev->property)));

    char *val;
    if(ev->target == Atm[LOCALES]){
	//EUC-JPǧʤäeucjpʳΤja_JPʤɤƤ
	//虜虜ja_JP.eucJPꤷʤƤjaǤΤ
	val = "@locale=ja_JP.eucJP,ja_JP,ja";
    }else if(ev->target == Atm[TRANSPORT]){
	val = "@transport=X/";
    }

    XChangeProperty(disp,ev->requestor,ev->property,ev->target,8,PropModeReplace,(unsigned char*)val,strlen(val));

    XEvent ne;
    ne.xselection.type = SelectionNotify;
    ne.xselection.selection = ev->selection;
    ne.xselection.target = ev->target;
    ne.xselection.property = ev->property;
    ne.xselection.requestor = ev->requestor;
    ne.xselection.send_event = True;
    ne.xselection.time = CurrentTime;
    ne.xselection.display = disp;
    XSendEvent(disp,ev->requestor,False,0,&ne);
}

typedef int (*ProtoFunc_t)(Display*,WxContext*,XimHeader*);
typedef WxContext* (*GetCxFunc_t)(Window,XimHeader*,int*,int*);
typedef struct{
    ProtoFunc_t rf;
    GetCxFunc_t cf;
    ProtoFunc_t cnd[2]; //[0]wime³ǤȤ [1]ǤƤʤȤ
} ReqFunc_t;
#define DEFREQ(r,c) {(ProtoFunc_t)r,c,{NULL,NULL}}
#define NWMREQ(r,c) {(ProtoFunc_t)r,c,{(ProtoFunc_t)r,(ProtoFunc_t)r##_nwm}}
#define UNDEFREQ    {NULL,NULL,{NULL,NULL}}
ReqFunc_t NormalReqFunc[]={
    [XIM_CONNECT]
    DEFREQ(Connect,none_imic),
    UNDEFREQ,
    NWMREQ(Disconnect,none_imic),
    UNDEFREQ,

    [XIM_AUTH_REQUIRED]
    UNDEFREQ,	//XIM_AUTH_REQUIRED		=10,
    UNDEFREQ,	//XIM_AUTH_REPLY,
    UNDEFREQ,	//XIM_AUTH_NEXT,
    UNDEFREQ,	//XIM_AUTH_SETUP,
    UNDEFREQ,	//XIM_AUTH_NG,

    [XIM_ERROR]
    DEFREQ(Error,none_imic),			//20

    [XIM_OPEN]
    DEFREQ(Open,none_imic),		//=30,
    UNDEFREQ,				//XIM_OPEN_REPLY,
    DEFREQ(Close,have_im),
    UNDEFREQ,				//XIM_CLOSE_REPLY,
    UNDEFREQ,				//XIM_REGISTER_TRIGGERKEYS,
    DEFREQ(TriggerNotify,have_imic),
    UNDEFREQ,				//XIM_TRIGGER_NOTIFY_REPLY,
    UNDEFREQ,				//XIM_SET_EVENT_MASK,
    DEFREQ(EncodingNego,have_im),
    UNDEFREQ,				//XIM_ENCODING_NEGOTIATION_REPLY,
    DEFREQ(QueryExtension,have_im),
    UNDEFREQ,				//XIM_QUERY_EXTENSION_REPLY,
    UNDEFREQ,				//XIM_SET_IM_VALUES,
    UNDEFREQ,				//XIM_SET_IM_VALUES_REPLY,
    DEFREQ(GetImValues,have_im),
    UNDEFREQ,				//XIM_GET_IM_VALUES_REPLY,

    [XIM_CREATE_IC]
    NWMREQ(CreateIc,have_im),		//=50,
    UNDEFREQ,				//XIM_CREATE_IC_REPLY,
    NWMREQ(DestroyIc,have_imic),
    UNDEFREQ,				//XIM_DESTROY_IC_REPLY,
    DEFREQ(SetIcValues,have_imic),
    UNDEFREQ,				//XIM_SET_IC_VALUES_REPLY,
    DEFREQ(GetIcValues,have_imic),
    UNDEFREQ,				//XIM_GET_IC_VALUES_REPLY,
    NWMREQ(SetIcFocus,have_imic),
    NWMREQ(UnsetIcFocus,have_imic),
    NWMREQ(ForwardEvent,have_imic),
    UNDEFREQ,				//XIM_SYNC,
    DEFREQ(SyncReply,have_imic),
    UNDEFREQ,				//XIM_COMMIT,
    UNDEFREQ,				//XIM_RESET_IC,
    UNDEFREQ,				//XIM_RESET_IC_REPLY,

    [XIM_GEOMETRY]
    UNDEFREQ,			//XIM_GEOMETRY		=70,
    UNDEFREQ,			//XIM_STR_CONVERTION,
    UNDEFREQ,			//XIM_STR_CONVERTION_REPLY,
    UNDEFREQ,			//XIM_PREEDIT_START,
    DEFREQ(PreeditStartReply,have_imic),
    UNDEFREQ,			//XIM_PREEDIT_DRAW,
    UNDEFREQ,			//XIM_PREEDIT_CARET,
    UNDEFREQ,			//XIM_PREEDIT_CARET_REPLY,
    UNDEFREQ,			//XIM_PREEDIT_DONE,
    UNDEFREQ,			//XIM_STATUS_START,
    UNDEFREQ,			//XIM_STATUS_DRAW,
    UNDEFREQ,			//XIM_STATUS_DONE,
    UNDEFREQ			//XIM_PREEDITSTATE,
};

ReqFunc_t ExtReqFunc[]={
    UNDEFREQ	//XIM_EXT_SET_EVENT_MASK	=XIM_EXT_BEGIN,
};
    
ReqFunc_t* ReqFuncs[]={ NormalReqFunc, ExtReqFunc };
unsigned ReqFuncMax[]={XIM_PROTO_END,XIM_EXT_END-XIM_EXT_BEGIN};

void error_notify(Display* disp,Window win,XimErrorCode err_code,int imid,int icid,const char* msg);

int tab_index(int mj,int* ext)
{
    if(mj >= XIM_EXT_BEGIN){ //ĥꥯ
	mj -= XIM_EXT_BEGIN;
	*ext = 1;
    }else
	*ext = 0;
    return mj;
}
    
/*
  win=С
  true:̾ｪλ
  false:塼
*/
bool proc_client_message(Display* disp,Window win,XClientMessageEvent* ev,XimHeader* h)
{
    bool st=true; //塼Ȥfalse
    unsigned f_id;
    int ext,imid,icid;
    WxContext *cx;

    LOG("major %hhd\n",h->major);
    f_id = tab_index(h->major,&ext);
    if(f_id<ReqFuncMax[ext] && ReqFuncs[ext][f_id].rf!=NULL){
	if((cx = ReqFuncs[ext][f_id].cf(ev->window,h,&imid,&icid)) != NULL){
	    if(cx->Sync!=0 && cx->Sync!=h->major && h->major!=XIM_ERROR){
		//ƱꥯȤԤƤ㤦Τ褿
		LOG("queue this request %d\n",f_id);
		st=false;
	    }else{
		if(setjmp(WimeJmp) != 0){
		    ERR("Disconnect wime, major-code %hhd\n",h->major);
		    reset_req_func_tab(false);
		}
		cx->Sync = ReqFuncs[ext][f_id].rf(disp,cx,h);
	    }
	}else{
	    //бץɥʤimicޥåʤʤ
	    MSG("*** BAD CLIENT WINDOW %p\n",ev->window);
	    error_notify(disp,win,BAD_CLIENT_WINDOW,imid,icid,"WimeXim Error");
	}
    }else{
	//BadProtocol:̤ꥯ
	MSG("*** BAD PROTOCOL %hhd ***\n",h->major);
	int dum1,dum2;
	cx = none_imic(ev->window,h,&dum1,&dum2);
	if(cx == NULL)
	    MSG("	not found context for window 0x%x\n",ev->window);
	else
	    error_notify(disp,cx->Client,BAD_PROTOCOL,imid,icid,"WimeXim Error");
    }
    return st;
}

void error_notify(Display* disp,Window win,XimErrorCode err_code,int imid,int icid,const char* msg)
{
    int msglen = strlen(msg);
    int bufsize = sizeof(XimError)+msglen+Pad(msglen);
    char buf[bufsize];
    XimError *e = memset(buf,0,bufsize);
    if((e->imid = imid) != 0)
	e->flag |= 1;
    if((e->icid = icid) != 0)
	e->flag |= 2;
    e->code = err_code;
    e->length = msglen;
    memcpy(e->detail,msg,msglen);
    send_n(disp,win,XIM_ERROR,e,bufsize);
}

XimHeader* get_message(Display* disp,Window proxy,XClientMessageEvent* ev)
{
    Atom type;
    int format;
    unsigned long items,left;
    XimHeader *h;

    switch(ev->format){
    case 8: //dataˤ
	h = (XimHeader*)ev->data.b;
	break;
    case 32: //ץѥƥͳ
	if(XGetWindowProperty(disp,proxy,ev->data.l[1],0,ev->data.l[0]*4,True,AnyPropertyType,&type,&format,&items,&left,(unsigned char**)&h)!=Success){
	    MSG("FAIL XGetWindowProperty()\n");
	    h = NULL;
	}
	break;
    default:
	LOG("message=(invalid format %d)\n",ev->format);
	h = NULL;
    }
    return h;
}

//WxContextΥ󥹥ȥ饯
void context_list_cr(void* p)
{
    WxContext *wc = (WxContext*)p;
    ArNew(&wc->Ic,sizeof(IcData),NULL);
    wc->Encoding = NULL;
}

Window add_proxy(Display* disp,Window c)
{
    WxContext *cx;
    Window p;

    int find_unused(const void* v UNUSED,const void* elem){
	return (((WxContext*)elem)->Flags & IMF_INVALID)!=0;
    }

#if 1
    p = XCreateSimpleWindow(disp,c,0,0,1,1,0,0,0);
    XSelectInput(disp,p,StructureNotifyMask); //cĤ줿DestroyNotify
#else
    p = XCreateSimpleWindow(disp,XDefaultRootWindow(disp),0,0,1,1,0,0,0);
#endif
    cx = ArFindElemIf(&ContextList,0,find_unused,NULL);
    cx->Proxy = p;
    cx->Client = c;
    cx->Sync = cx->Flags = 0;
    cx->Ic.use = 0;
    cx->Encoding = NULL;
    LOG("client %p, proxy %p\n",c,p);
    return p;
}

/*
  imꥯȤ˥ޥå륳ƥȤ֤
  إåμΣwordܤim
*/
WxContext* have_im(Window w UNUSED,XimHeader* h,int* imid,int* icid)
{
    *imid = *(uint16_t*)(h+1);
    *icid = 0;
    WxContext *cx = ArElem(&ContextList,*imid-1);
    return *imid-1<ContextList.use && (cx->Flags & IMF_INVALID)==0 ? cx : NULL;
}

/*
  imicꥯȤ˥ޥå륳ƥȤ֤
  إåμΣwordܤim,wordܤic
*/
WxContext* have_imic(Window w,XimHeader* h,int* imid,int* icid)
{
    WxContext *cx = have_im(w,h,imid,icid);
    *icid = *((uint16_t*)(h+1)+1);
    return cx;
}

/*
  ѥɥw˥ޥå륳ƥȤ֤
*/
WxContext* none_imic(Window w,XimHeader* h UNUSED,int* imid,int* icid)
{
    int find_proxy(const void* ww,const void* elem){
	return ((WxContext*)elem)->Proxy==(Window)ww && (((WxContext*)elem)->Flags & IMF_INVALID)==0;
    }

    *imid = ArFindIf(&ContextList,0,find_proxy,(void*)w)+1;
    *icid = 0;
    return *imid>0 ? ArElem(&ContextList,*imid-1) : NULL;
}

Window gen_proxy(Display* disp)
{
    return XCreateSimpleWindow(disp,DefaultRootWindow(disp),0,0,1,1,0,0,0);
}

int Error(Display* disp UNUSED,WxContext* cx UNUSED,XimError* pkt)
{
    const char* flag_str(unsigned flag){
	const char *msg[]={
	    "invalid im-id,ic-id",
	    "invalid im_id",
	    "invalid ic_id"
	};
	return flag<3 ? msg[flag] : "unknown flag";
    }
    const char* code_str(unsigned code){
	const char *msg[]={ //1...16
	    "BadAlloc",		"BadStyle",		"BadClientWindow",
	    "BadFocusWindow",	"BadArea",		"BadSpotLocation",
	    "BadColormap",	"BadAtom",		"BadPixel",
	    "BadPixmap",	"BadName",		"BadCursor",
	    "BadProtocol",	"BadForeground",	"BadBackground",
	    "LocaleNotSupported"
	};
	const char *m;
	switch(code){
	case 1 ... 16:	m=msg[code-1]; break;
	case 999:	m="BadSomething"; break;
	default:	m="unknown code";
	}
	return m;
    }
	   
    MSG("ERROR:im-id=%hd ic-id=%hd\n",pkt->imid,pkt->icid);
    MSG("	flag=%hx (%s)\n",pkt->flag,flag_str(pkt->flag));
    MSG("	code=%hd (%s)\n",pkt->code,code_str(pkt->code));
    if(pkt->length > 0){
	char str[pkt->length+1];
	memcpy(str,pkt->detail,pkt->length);
	str[pkt->length] = 0;
	MSG("	detail type=%hd(0x%hx)\n",pkt->detail_type,pkt->detail_type);
	MSG("	error detail='%s'\n",str);
    }else
	MSG("	error detail=(none)\n");

    return 0;
}

void send_0(Display* disp,Window win,unsigned mj)
{
    XimHeader pkt;
    send_n(disp,win,mj,&pkt,sizeof(pkt));
}

void send_ww(Display* disp,Window win,unsigned mj,uint16_t p1,uint16_t p2)
{
    XimData_ww pkt;

    pkt.p1 = p1;
    pkt.p2 = p2;
    send_n(disp,win,mj,&pkt,sizeof(pkt));
}

/*
  size=إåޤ᤿Хȥ
*/
void send_n(Display* disp,Window client,unsigned major,void* h,int size)
{
    XEvent ev;

    ((XimHeader*)h)->major = (major & 0xff);
    ((XimHeader*)h)->minor = (major >> 8);
    ((XimHeader*)h)->len = (size-sizeof(XimHeader))/4;

    if((unsigned)size <= PACKET_MAX_SIZE){
	ev.xclient.format = 8;
	memset(ev.xclient.data.b,0,PACKET_MAX_SIZE);
	memcpy(ev.xclient.data.b,h,size);
    }else{
	XChangeProperty(disp,client,Atm[WIMEXIM_PROP],XA_STRING,8,PropModeAppend,h,size);
	ev.xclient.format = 32;
	ev.xclient.data.l[0] = size;
	ev.xclient.data.l[1] = Atm[WIMEXIM_PROP];
    }
    ev.type = ClientMessage;
    ev.xclient.display = disp;
    ev.xclient.window = client;
    ev.xclient.message_type = Atm[XIM_PROTOCOL];
    XSendEvent(disp,client,False,NoEventMask,&ev);
    XFlush(disp);
}

/*
  ѴɥΥǥեȥե
*/
void get_comp_font(Display* disp)
{
    const char *res,fmt[]="-%s-%s-*-*-*--%d-*-*-*-*-*-jisx0208-*";

    if((res = GetResource(disp,XResDefFont)) != NULL){
	int n=strlen(res),h;
	char fndy[n],fmly[n],xlfd[sizeof(fmt)+n];
	if(sscanf(res,"%d,%s %s",&h,fndy,fmly) == 3){
	    sprintf(xlfd,fmt,fndy,fmly,h);
	    DefaultCompFont = strdup(xlfd);
	}else
	    MSG("bad font:%s\n",res);
    }
}

/*
  wimeʤȤΥꥯȽؿwimeȤꥯȤƤδؿˤʤ롣
*/
int disable_wime_req(Display* disp,WxContext* cx,XimHeader* pkt)
{
    ProtoFunc_t rf;
    int r,ext;
    ReqFunc_t *f;

    r = tab_index(pkt->major,&ext);
    f = ReqFuncs[ext] + r;
    if(WimeIsConnected()){
	reset_req_func_tab(true);
	rf = f->rf;
    }else{
	if((rf = f->cnd[1]) == NULL)
	    rf = f->rf;
    }
    return (*rf)(disp,cx,pkt);
}

//ReqFunc_trfcnd[0]disable_wime_reqѤ
void reset_req_func_tab(bool enable_wime)
{
    unsigned mn,mj;
    ReqFunc_t *tab;

    for(mn=0; mn<ITEMS(ReqFuncs); ++mn){
	tab = ReqFuncs[mn];
	for(mj=0; mj<ReqFuncMax[mn]; ++mj,++tab){
	    if(tab->cnd[0] != NULL)
		tab->rf = enable_wime ? tab->cnd[0] : disable_wime_req;
	}
    }
}
