/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.TableLine;
import writer2latex.util.Misc;

public class TableReader {
    private OfficeReader ofr;
    private Element tableNode;
    private LinkedList cols = new LinkedList();
    private LinkedList rows = new LinkedList();
    private LinkedList cells = new LinkedList();
    private int nMaxCols = 1;
    private int nMaxRows = 1;
    private String[] sColWidth;
    private String[] sRelColWidth;
    private String sTableWidth;
    private String sRelTableWidth;

    public TableReader(OfficeReader ofr, Element tableNode) {
        this.ofr = ofr;
        this.tableNode = tableNode;
        if (!tableNode.hasChildNodes()) {
            return;
        }
        NodeList nl = tableNode.getChildNodes();
        int nLen = nl.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = nl.item(i);
            if (child.getNodeType() == 1) {
                String sName = child.getNodeName();
                if (sName.equals("table:table-column")) {
                    this.readTableColumn(child, false, false);
                } else if (sName.equals("table:table-columns")) {
                    this.readTableColumns(child, false, false);
                } else if (sName.equals("table:table-column-group")) {
                    this.readTableColumnGroup(child, false, false);
                } else if (sName.equals("table:table-header-columns")) {
                    this.readTableHeaderColumns(child, false, false);
                } else if (sName.equals("table:table-row")) {
                    this.readTableRow(child, false, false);
                } else if (sName.equals("table:table-rows")) {
                    this.readTableRows(child, false, false);
                } else if (sName.equals("table:table-row-group")) {
                    this.readTableRowGroup(child, false, false);
                } else if (sName.equals("table:table-header-rows")) {
                    this.readTableHeaderRows(child, false, false);
                }
            }
            ++i;
        }
        StyleWithProperties tableStyle = ofr.getTableStyle(this.getTableStyleName());
        if (tableStyle != null) {
            this.sTableWidth = tableStyle.getProperty("style:width");
            this.sRelTableWidth = tableStyle.getProperty("style:rel-width");
        }
        int nCols = this.cols.size();
        this.sColWidth = new String[nCols];
        this.sRelColWidth = new String[nCols];
        int[] nRelColWidth = new int[nCols];
        boolean bHasRelWidth = true;
        int nColSum = 0;
        int nCol = 0;
        while (nCol < nCols) {
            StyleWithProperties style = ofr.getColumnStyle(((TableLine)this.cols.get(nCol)).getStyleName());
            if (style != null) {
                this.sColWidth[nCol] = style.getProperty("style:column-width");
                String s = style.getProperty("style:rel-column-width");
                if (s != null && s.endsWith("*")) {
                    nRelColWidth[nCol] = Misc.getPosInteger(s.substring(0, s.length() - 1), 1);
                }
            }
            if (this.sColWidth[nCol] == null) {
                this.sColWidth[nCol] = "2cm";
            }
            if (nRelColWidth[nCol] == 0) {
                bHasRelWidth = false;
            }
            nColSum += nRelColWidth[nCol];
            ++nCol;
        }
        int nCol2 = 0;
        while (nCol2 < nCols) {
            this.sRelColWidth[nCol2] = bHasRelWidth ? 100.0f * (float)nRelColWidth[nCol2] / (float)nColSum + "%" : 100.0f / (float)nCols + "%";
            ++nCol2;
        }
        int nRows = this.cells.size();
        int nRow = 0;
        while (nRow < nRows) {
            LinkedList row = (LinkedList)this.cells.get(nRow);
            nCols = row.size();
            int nMaxCol = 0;
            int nMaxRow = 0;
            int nCol3 = 0;
            while (nCol3 < nCols) {
                Element cell = (Element)row.get(nCol3);
                if (cell.hasChildNodes()) {
                    nMaxRow = nRow + Misc.getPosInteger(cell.getAttribute("table:number-rows-spanned"), 1);
                    if (nMaxRow > this.nMaxRows) {
                        this.nMaxRows = nMaxRow;
                    }
                    if ((nMaxCol = nCol3 + Misc.getPosInteger(cell.getAttribute("table:number-columns-spanned"), 1)) > this.nMaxCols) {
                        this.nMaxCols = nMaxCol;
                    }
                }
                ++nCol3;
            }
            ++nRow;
        }
    }

    private void readTableColumn(Node node, boolean bHeader, boolean bDisplay) {
        int nRepeat = Misc.getPosInteger(Misc.getAttribute(node, "table:number-columns-repeated"), 1);
        while (nRepeat-- > 0) {
            this.cols.add(new TableLine(node, bHeader, bDisplay));
        }
    }

    private void readTableColumns(Node node, boolean bHeader, boolean bDisplay) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nl = node.getChildNodes();
        int nLen = nl.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = nl.item(i);
            if (child.getNodeType() == 1) {
                String sName = child.getNodeName();
                if (sName.equals("table:table-column")) {
                    this.readTableColumn(child, bHeader, bDisplay);
                } else if (sName.equals("table:table-column-group")) {
                    this.readTableColumnGroup(child, bHeader, bDisplay);
                }
            }
            ++i;
        }
    }

    private void readTableColumnGroup(Node node, boolean bHeader, boolean bDisplay) {
        boolean bl = bDisplay = !"false".equals(Misc.getAttribute(node, "table:display"));
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nl = node.getChildNodes();
        int nLen = nl.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = nl.item(i);
            if (child.getNodeType() == 1) {
                String sName = child.getNodeName();
                if (sName.equals("table:table-header-columns")) {
                    this.readTableHeaderColumns(child, bHeader, bDisplay);
                } else if (sName.equals("table:table-column")) {
                    this.readTableColumn(child, bHeader, bDisplay);
                } else if (sName.equals("table:table-column-group")) {
                    this.readTableColumnGroup(child, bHeader, bDisplay);
                }
            }
            ++i;
        }
    }

    private void readTableHeaderColumns(Node node, boolean bHeader, boolean bDisplay) {
        this.readTableColumns(node, true, bDisplay);
    }

    private void readTableRow(Node node, boolean bHeader, boolean bDisplay) {
        int nRepeat = Misc.getPosInteger(Misc.getAttribute(node, "table:number-rows-repeated"), 1);
        while (nRepeat-- > 0) {
            this.rows.add(new TableLine(node, bHeader, bDisplay));
            LinkedList<Element> row = new LinkedList<Element>();
            if (node.hasChildNodes()) {
                NodeList nl = node.getChildNodes();
                int nLen = nl.getLength();
                int i = 0;
                while (i < nLen) {
                    Node child = nl.item(i);
                    if (child.getNodeType() == 1) {
                        Element cell = (Element)child;
                        String sName = cell.getTagName();
                        if (sName.equals("table:table-cell")) {
                            nRepeat = Misc.getPosInteger(cell.getAttribute("table:number-columns-repeated"), 1);
                            while (nRepeat-- > 0) {
                                row.add(cell);
                            }
                        } else if (sName.equals("table:covered-table-cell")) {
                            nRepeat = Misc.getPosInteger(cell.getAttribute("table:number-columns-repeated"), 1);
                            while (nRepeat-- > 0) {
                                row.add(cell);
                            }
                        }
                    }
                    ++i;
                }
            }
            this.cells.add(row);
        }
    }

    private void readTableRows(Node node, boolean bHeader, boolean bDisplay) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nl = node.getChildNodes();
        int nLen = nl.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = nl.item(i);
            if (child.getNodeType() == 1) {
                String sName = child.getNodeName();
                if (sName.equals("table:table-row")) {
                    this.readTableRow(child, bHeader, bDisplay);
                } else if (sName.equals("table:table-row-group")) {
                    this.readTableRowGroup(child, bHeader, bDisplay);
                }
            }
            ++i;
        }
    }

    private void readTableRowGroup(Node node, boolean bHeader, boolean bDisplay) {
        boolean bl = bDisplay = !"false".equals(Misc.getAttribute(node, "table:display"));
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nl = node.getChildNodes();
        int nLen = nl.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = nl.item(i);
            if (child.getNodeType() == 1) {
                String sName = child.getNodeName();
                if (sName.equals("table:table-header-rows")) {
                    this.readTableHeaderRows(child, bHeader, bDisplay);
                } else if (sName.equals("table:table-row")) {
                    this.readTableRow(child, bHeader, bDisplay);
                } else if (sName.equals("table:table-row-group")) {
                    this.readTableRowGroup(child, bHeader, bDisplay);
                }
            }
            ++i;
        }
    }

    public boolean isSubTable() {
        return "table:sub-table".equals(this.tableNode.getTagName()) || "true".equals(Misc.getAttribute(this.tableNode, "table:is-sub-table"));
    }

    private void readTableHeaderRows(Node node, boolean bHeader, boolean bDisplay) {
        this.readTableRows(node, true, bDisplay);
    }

    public String getTableName() {
        return this.tableNode.getAttribute("table:name");
    }

    public String getTableStyleName() {
        return this.tableNode.getAttribute("table:style-name");
    }

    public String getTableWidth() {
        return this.sTableWidth;
    }

    public String getRelTableWidth() {
        return this.sRelTableWidth;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getMaxRowCount() {
        return this.nMaxRows;
    }

    public int getFirstBodyRow() {
        int nRows = this.rows.size();
        int nRow = 0;
        while (nRow < nRows) {
            if (!this.getRow(nRow).isHeader()) {
                return nRow;
            }
            ++nRow;
        }
        return nRows;
    }

    public int getColCount() {
        return this.cols.size();
    }

    public int getMaxColCount() {
        return this.nMaxCols;
    }

    public String getColumnWidth(int nCol) {
        return 0 <= nCol && nCol <= this.cols.size() ? this.sColWidth[nCol] : null;
    }

    public String getRelColumnWidth(int nCol) {
        return 0 <= nCol && nCol <= this.cols.size() ? this.sRelColWidth[nCol] : null;
    }

    public Node getCell(int nRow, int nCol) {
        if (nRow < 0 || nRow >= this.cells.size()) {
            return null;
        }
        LinkedList row = (LinkedList)this.cells.get(nRow);
        if (nCol < 0 || nCol >= row.size()) {
            return null;
        }
        return (Node)row.get(nCol);
    }

    public String getCellStyleName(int nRow, int nCol) {
        Element cell = (Element)this.getCell(nRow, nCol);
        if (cell == null) {
            return null;
        }
        String s = cell.getAttribute("table:style-name");
        if (s != null && s.length() > 0) {
            return s;
        }
        s = this.getRow(nRow).getDefaultCellStyleName();
        if (s != null && s.length() > 0) {
            return s;
        }
        s = this.getCol(nCol).getDefaultCellStyleName();
        return s;
    }

    public String getCellWidth(int nRow, int nCol) {
        Element cell = (Element)this.getCell(nRow, nCol);
        if (cell == null) {
            return null;
        }
        int nCols = Misc.getPosInteger(cell.getAttribute("table:number-columns-spanned"), 1);
        String sWidth = this.sColWidth[nCol];
        int i = nCol + 1;
        while (i < nCol + nCols) {
            sWidth = Misc.add(sWidth, this.sColWidth[i]);
            ++i;
        }
        return sWidth;
    }

    public TableLine getRow(int nRow) {
        if (nRow < 0 || nRow >= this.rows.size()) {
            return null;
        }
        return (TableLine)this.rows.get(nRow);
    }

    public TableLine getCol(int nCol) {
        if (nCol < 0 || nCol >= this.cols.size()) {
            return null;
        }
        return (TableLine)this.cols.get(nCol);
    }
}

