/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "toolbar.h"
#include "entry_edit_dialog.h"
#include "save_dialog.h"
#include "open_dialog.h"
#include "node.h"
#include "treeview.h"
#include "save.h"
#include "debug.h"


static void toolbar_open_event_handler (struct xfbib *xfbib)
{
	_DEBUG(("toolbar_open_event_handler"));
	show_open_dialog(xfbib);
}
static void toolbar_save_event_handler (struct xfbib *xfbib)
{
	_DEBUG(("toolbar_save_event_handler"));
	if (xfbib->filename == NULL) {
		/* Use save as*/
		_DEBUG(("No file open, opening save as dialog"));
		show_save_dialog(xfbib);
	} else {
		_DEBUG(("Saving data"));
		save(xfbib);
	}
}

static void toolbar_edit_event_handler (struct xfbib *xfbib)
{
	_DEBUG(("toolbar_edit_event_handler"));

	GtkTreeSelection *selection;
	GtkTreeModel *model;
	GtkTreeIter iter;
	struct node *node;
	
	/* This will only work in single or browse selection mode! */
	
	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(xfbib->window.main_treeview));
	if (gtk_tree_selection_get_selected(selection, &model, &iter))
	{
		gtk_tree_model_get(model, &iter, COLUMN_ENTRY, &node, -1);
		show_entry_edit_dialog(xfbib, node->node);
	} else {
		_DEBUG(("No row selected."));
	}
}

static void toolbar_add_event_handler (struct xfbib *xfbib)
{
	_DEBUG(("toolbar_add_event_handler"));
	show_entry_edit_dialog(xfbib, NULL);
	update_treeview(xfbib);
}

static void toolbar_remove_event_handler (struct xfbib *xfbib)
{
	_DEBUG(("toolbar_remove_event_handler"));
	struct node *node;
	GtkTreeSelection *selection;
	GtkTreeModel     *model;
	GtkTreeIter       iter;

	/* This will only work in single or browse selection mode! */

	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(xfbib->window.main_treeview));
	if (gtk_tree_selection_get_selected(selection, &model, &iter)) {
		gtk_tree_model_get (model, &iter, COLUMN_ENTRY, &node, -1);
		remove_node(&(xfbib->list), node);
	} else {
		_DEBUG(("No row selected"));
	}
	update_treeview(xfbib);
}

GtkWidget *create_toolbar(struct xfbib *xfbib)
{
	_DEBUG(("create_toolbar"));
	GtkWidget *toolbar;
	struct {
		GtkToolItem *open;
		GtkToolItem *save;
		GtkToolItem *edit;
		GtkToolItem *add;
		GtkToolItem *remove;
	} toolitems;

	/* Create and add toolbar */
	toolbar = gtk_toolbar_new();
	gtk_toolbar_set_orientation (GTK_TOOLBAR (toolbar), GTK_ORIENTATION_HORIZONTAL);

	toolitems.open = gtk_tool_button_new_from_stock(GTK_STOCK_OPEN);
	toolitems.save = gtk_tool_button_new_from_stock(GTK_STOCK_SAVE);
	
	toolitems.edit = gtk_tool_button_new_from_stock(GTK_STOCK_EDIT);
	
	toolitems.add = gtk_tool_button_new_from_stock(GTK_STOCK_ADD);
	toolitems.remove = gtk_tool_button_new_from_stock(GTK_STOCK_REMOVE);
	
	g_signal_connect_swapped(G_OBJECT(toolitems.open),
			"clicked", G_CALLBACK(toolbar_open_event_handler), xfbib);
	g_signal_connect_swapped(G_OBJECT(toolitems.save),
			"clicked", G_CALLBACK(toolbar_save_event_handler), xfbib);
	
	g_signal_connect_swapped(G_OBJECT(toolitems.edit),
			"clicked", G_CALLBACK(toolbar_edit_event_handler), xfbib);
	
	g_signal_connect_swapped(G_OBJECT(toolitems.add),
			"clicked", G_CALLBACK(toolbar_add_event_handler), xfbib);
	g_signal_connect_swapped(G_OBJECT(toolitems.remove),
			"clicked", G_CALLBACK(toolbar_remove_event_handler), xfbib);

	gtk_toolbar_insert (GTK_TOOLBAR (toolbar), toolitems.open, 0);
	gtk_toolbar_insert (GTK_TOOLBAR (toolbar), toolitems.save, 1);
	gtk_toolbar_insert (GTK_TOOLBAR (toolbar), gtk_separator_tool_item_new(), 2);
	gtk_toolbar_insert (GTK_TOOLBAR (toolbar), toolitems.add, 3);
	gtk_toolbar_insert (GTK_TOOLBAR (toolbar), toolitems.remove, 4);
	//gtk_toolbar_insert (GTK_TOOLBAR (toolbar), gtk_separator_tool_item_new(), 5);
	gtk_toolbar_insert (GTK_TOOLBAR (toolbar), toolitems.edit, 5);

	return toolbar;
}
