 /*
  *  Copyright (C) 2008 Marián Kyral
  *  Copyright (C) 2008 Ezequiel R. Aguerre
  *  Copyright (C) 2008 Pierpaolo Vittorini
  *  Copyright (C) 2008 Ruan Strydom
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 2 of the License, or
  * (at your option) any later version.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  */

#ifndef YAWP_H
#define YAWP_H


#include <Plasma/Applet>
#include <Plasma/Svg>
#include <QGraphicsSceneMouseEvent>
#include <Solid/Networking>

#define MAX_FORECAST_DAYS       10

class YaWPConfigDialog;
class QTimer;
class QTimeLine;
class QLabel;
class QGraphicsSceneResizeEvent;
class KConfigDialog;
class KAboutData;
namespace Plasma { class Dialog; }

#include "yawpwserv.h"

//-----------------------------------------------------------------------------
/** Main plasmoid class.
@author Ruan <ruans@kr8.co.za>
*/
class YaWP : public Plasma::Applet
{
  Q_OBJECT
  public:

    YaWP(QObject *parent, const QVariantList &args);

    virtual ~YaWP();

    void paintInterface(QPainter *painter, const QStyleOptionGraphicsItem *option, const QRect& contentsRect);
    void init();

    void loadConfig();
    void saveConfig();

    void constraintsEvent(Plasma::Constraints constraints);

    QList<QAction *> contextualActions () { return m_actions; }

  public slots:
    void updateFontColors();

  protected:

    void paintPanel(QPainter *painter, const QStyleOptionGraphicsItem *option, const QRect& contentsRect);

    void createConfigurationInterface( KConfigDialog* );
    void mousePressEvent( QGraphicsSceneMouseEvent* );
    void loadCustomTheme();
    void mouseDoubleClickEvent( QGraphicsSceneMouseEvent* );

  protected slots:
    void timeout();
    void settingsChanged();
    void updateMessage(QString mess);
    void updateInfo(QObject *, int);

    void animationTimeout(int);
    void animationFinished();

    void about() const;

    void solidStatusChanged(Solid::Networking::Status status);

  private:
    Plasma::Svg         m_svg;
    Plasma::Svg         m_customSvg;
    YaWPConfigDialog    *m_cdiag;
    QFont               m_font;
    QTimer              *m_timer;
    QString             m_message;
    int                 m_interval;
    bool                m_inPanel;
    bool                m_panelHorizontal;
    int                 m_panelItemCount;
    float               m_panelElementSize;
    float               m_panelElementBorderSize;
    QSizeF              m_expandedArea;
    QSizeF              m_origExpandedArea;
    int                 m_panelLayoutSwitched; // plasma resize event counter.

    QString             m_theme;
    QString             m_city;
    QString             m_country;
    QString             m_location;
    QString             m_service;
    int                 m_units;
    bool                m_useCustomTheme;
    QString             m_customTheme;
    bool                m_useCustomThemeBackground;
    Plasma::Dialog      *m_dialog;
    QLabel              *m_dialogLabel;
    bool                m_panelActualTemp;
    bool                m_panelActualIcon;
    bool                m_panelActualBoth;
    bool                m_panelForecastTemp;
    bool                m_panelForecastIcon;
    bool                m_panelForecastBoth;
    int                 m_panelForecastDays;
    bool                m_panelToolTipSatellite;
    bool                m_useCustomColor;
    QColor              m_fontColor;
    QColor              m_fontShadowColor;
    QColor              m_fontLowerColor;

    YaWPWeatherInfo     m_info;

    YaWPWeatherService * m_wservice;
    YaWPWeatherService * m_googlewservice;
    YaWPWeatherService * m_accuweatherwservice;

    KAboutData *m_aboutData;
    QList<QAction *> m_actions; /**< Contextual actions */

    float       m_scale;
    QTimeLine * m_animation;
    int         m_animationWhat;
    bool        m_animationActive;
    QRectF      m_wrect;

    enum { DAYS, EMBLEM, INFO, SATELLITE };

    int         m_whichEmblem;
    float       m_emblemSize;
    int         m_emblem[MAX_FORECAST_DAYS];
    float       m_animationTickEmblem[MAX_FORECAST_DAYS];
    enum { EMBLEM_DAY, EMBLEM_NIGHT };

    int         m_days;
    int         m_animationTickDays;
    enum { DAYS_NAMES, DAYS_NUMBERS };

    int         m_infoIcon;
    int         m_animationTickInfoIcon;
    int         m_infoIconDay;
    enum { INFO_CLOSED, INFO_OPEN };

    int         m_satellite;
    int         m_animationTickSatellite;
    enum { SATELLITE_CLOSED, SATELLITE_OPEN };

    bool        m_resized;

    QString veryShortDate();

    void paintEmblem( QPainter *, int, const YaWPDay *, float, float, float, bool = true);
    void paintDegrees( QPainter *, int, const YaWPDay *, QFont, float );
    void paintDayNames( QPainter *, QFont, QRectF, float );
    void paintInformation( QPainter *, QFont );
    void paintSatellite( QPainter * );

    void paintPanelTooltip(QPainter *painter, const QStyleOptionGraphicsItem *option, const QRect& contentsRect);

    int  clickOnEmblem( QPointF );
    int  clickOnPanelEmblem( QPointF );
    bool clickOnDays( QPointF );
    bool clickOnInfoIcon( QPointF );
    bool clickOnInfoIconLeft( QPointF );
    bool clickOnInfoIconRight( QPointF );
    bool clickOnSatelliteIcon( QPointF );

    void updatePanelSize(); // update panel size after config changed
    bool isDayTime(QTime currentTime, QTime sunriseTime, QTime sunsetTime); // return true if now is night
    void setDefaultFontColors();

};


#endif
