 /*
  *  Copyright (C) 2008 Marián Kyral
  *  Copyright (C) 2008 Ezequiel R. Aguerre
  *  Copyright (C) 2008 Pierpaolo Vittorini
  *  Copyright (C) 2008 Ruan Strydom
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 2 of the License, or
  * (at your option) any later version.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  */

#ifndef YAWP_CONFIG_H
#define YAWP_CONFIG_H

#include <QWidget>
#include <QDialog>
#include <kio/job.h>
#include <QMap>
#include <QColor>

#include "ui_yawpunitspage.h"
#include "ui_yawpthemepage.h"
#include "ui_yawplocationpage.h"
#include "ui_yawppanelpage.h"

class KProgressDialog;
class KConfigDialog;

//-----------------------------------------------------------------------------
/** Configuration window.
	@author Ruan <ruans@kr8.co.za>
 */
class YaWPConfigDialog : public QObject, public Ui::UnitsPage,
  public Ui::ThemePage, public Ui::LocationPage, public Ui::PanelPage {
    Q_OBJECT
public:
    YaWPConfigDialog(KConfigDialog*);
    virtual ~YaWPConfigDialog();

    void setInterval(int inter);
    int interval() const;

    void setTheme(const QString &theme);
    QString theme() const;

    void setCity(const QString &city);
    QString city() const;

    void setCountry(const QString &country);
    QString country() const;

    void setLocation(const QString &code);
    QString location();

    void setUnits(int units);
    int units() const;

    void setService(const QString &service);
    QString service() const;

    void setUseCustomTheme(bool enabled);
    bool useCustomTheme() const;

    void setCustomTheme(const QString &file);
    QString customTheme() const;

    void setUseCustomThemeBackground(bool enabled);
    bool useCustomThemeBackground() const;

    void setPanelActualTemp(bool enabled);
    bool panelActualTemp() const;

    void setPanelActualIcon(bool enabled);
    bool panelActualIcon() const;

    void setPanelActualBoth(bool enabled);
    bool panelActualBoth() const;

    void setPanelForecastTemp(bool enabled);
    bool panelForecastTemp() const;

    void setPanelForecastIcon(bool enabled);
    bool panelForecastIcon() const;

    void setPanelForecastBoth(bool enabled);
    bool panelForecastBoth() const;

    void setPanelForecastDays(int days);
    int panelForecastDays() const;

    void setUseCustomColor(bool enabled);
    bool useCustomColor() const;

    void setFontColor(QColor color);
    QColor fontColor() const;

    void setFontLowerColor(QColor color);
    QColor fontLowerColor() const;

    void setPanelToolTipSatellite(bool enabled);
    bool panelToolTipSatellite() const;

signals:
    void save();

protected slots:
    //void serviceChanged(const QString & text);
    void fileSelected(int state);
    void showFileDialog();
    void showAccuweatherPage();

    void itemClicked(QListWidgetItem *item);
    void find();
    void slotData( KIO::Job *, const QByteArray & );
    void slotResult(KJob *);

    void customColorSelected(int state);

private:

    void setCustomThemeEnabled(bool value);
    void setCustomColorsEnabled(bool value);

    QString        m_location;
    QString        m_city;
    QString        m_country;
    QMap <int, QString>   m_theme_map;
    KConfigDialog  *m_parent;

    bool parseInfo(const QByteArray &data);
    QByteArray          m_xmldata;
    KProgressDialog     *m_diag;

    enum {COUNTRY_DATA = Qt::UserRole + 2, CITY_DATA = Qt::UserRole + 1, LOCATION_DATA = Qt::UserRole};
};

#endif //YAWP_CONFIG_H
