 /*
  *  Copyright (C) 2008 Marián Kyral
  *  Copyright (C) 2008 Ezequiel R. Aguerre
  *  Copyright (C) 2008 Pierpaolo Vittorini
  *  Copyright (C) 2008 Ruan Strydom
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 2 of the License, or
  * (at your option) any later version.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  */

#ifndef YAWP_WDAY_H
#define YAWP_WDAY_H

#include <QString>
#include <QVector>
#include <QDate>


//-----------------------------------------------------------------------------
/** Stores the weather for a particular day.
@author Ruan <ruans@kr8.co.za>
*/
class YaWPDay
{
    public:
        static const int IMPERIAL = 1;
        static const int METRIC = 0;
        
        YaWPDay() {
            m_high      = 0;
            m_humid     = 0;
            m_windSpeed = 0;
            m_windSpeedCurr = 0;
            m_windDirec = "";
            m_windDirecCurr = "";
            m_high      = 0;
            m_low       = 0;
            m_rfhigh    = 0;
            m_rflow     = 0;
            m_current   = 0;
            m_time      = "";
            m_observation = "";
            m_sunrise   = "";
            m_sunset    = "";
            m_desc      = "unknown";
            m_emblem    = "unknown";
            m_emblemCurr = "unknown";
            m_units     = METRIC;

            m_hasNightValues = false;
            m_nightWindDirec = "";
            m_nightWindSpeed = 0;
            m_nightHigh      = 0;
            m_nightLow       = 0;
            m_nightRfHigh    = 0;
            m_nightRfLow     = 0;
            m_nightDesc      = "unknown";
            m_nightEmblem    = "unknown";
        };
        ~YaWPDay() {}

        //Current
        
        QString date() const { return m_date; }
        void setDate(QString date) { m_date = date; }
        
        QString dateLong() const { return m_datelong; }
        void setDateLong(QString date) { m_datelong = date; }
        
        QDate day() const { return m_day; }
        void setDay(QDate day) { m_day = day; }
        
        int current() const { return m_current; }
        void setCurrent(int current) { m_current = current; }

        int humidity() const { return m_humid; }
        void setHumidity(int humid) { m_humid = humid; }

        //Day values
        
        int low() const { return m_low; }
        void setLow(int low) { m_low = low; }
        
        int high() const { return m_high; }
        void setHigh(int high) { m_high = high; }
        
        int rfLow() const { return m_rflow; }
        void setRfLow(int low) { m_rflow = low; }
        
        int rfHigh() const { return m_rfhigh; }
        void setRfHigh(int high) { m_rfhigh = high; }
        
        QString description() const { return m_desc; }
        void setDescription(QString desc) { m_desc = desc; }
        
        QString emblem() const { return m_emblem; }
        void setEmblem(QString desc) { m_emblem = desc.toLower().replace(" ","-"); }

        QString emblemCurr() const { return m_emblemCurr; }
        void setEmblemCurr(QString desc) { m_emblemCurr = desc.toLower().replace(" ","-"); }
        
        int windSpeed() const { return m_windSpeed; }
        void setWindSpeed(int speed) { m_windSpeed = speed; }

        int windSpeedCurr() const { return m_windSpeedCurr; }
        void setWindSpeedCurr(int speed) { m_windSpeedCurr = speed; }
        
        QString windDirection() const { return m_windDirec; }
        void setWindDirection(QString direction) { m_windDirec = direction; }

        QString windDirectionCurr() const { return m_windDirecCurr; }
        void setWindDirectionCurr(QString direction) { m_windDirecCurr = direction; }

        //Night values

        bool hasNightValues() const { return m_hasNightValues; }
        void setHasNightValues(bool value) { m_hasNightValues = value; }
        
        int nightLow() const { return m_nightLow; }
        void setNightLow(int low) { m_nightLow = low; }

        int nightHigh() const { return m_nightHigh; }
        void setNightHigh(int high) { m_nightHigh = high; }

        int nightRfLow() const { return m_nightRfLow; }
        void setNightRfLow(int low) { m_nightRfLow = low; }

        int nightRfHigh() const { return m_nightRfHigh; }
        void setNightRfHigh(int high) { m_nightRfHigh = high; }

        QString nightDescription() const { return m_nightDesc; }
        void setNightDescription(QString desc) { m_nightDesc = desc; }

        QString nightEmblem() const { return m_nightEmblem; }
        void setNightEmblem(QString desc) { m_nightEmblem = desc.toLower().replace(" ","-"); }

        int nightWindSpeed() const { return m_nightWindSpeed; }
        void setNightWindSpeed(int speed) { m_nightWindSpeed = speed; }

        QString nightWindDirection() const { return m_nightWindDirec; }
        void setNightWindDirection(QString direction) { m_nightWindDirec = direction; }

        //Config
        void setUnits(int units) { m_units = units; }
        int units() const  { return m_units; }

        void setTime(QString time) { m_time = time; }
        QString time() const  { return m_time; }
        QTime timeCurrent() const  { return QTime::fromString(time(), "h:m ap"); }

        void setObservation(QString observation) { m_observation = observation; }
        QString observation() const  { return m_observation; }
        QTime observationTime() const  { return QTime::fromString(observation(), "h:m ap"); }

        void setSunrise(QString sunrise) { m_sunrise = sunrise; }
        QString sunrise() const  { return m_sunrise; }
        QTime sunriseTime() const  { return QTime::fromString(sunrise(), "h:m ap"); }
        
        void setSunset(QString sunset) { m_sunset = sunset; }
        QString sunset() const  { return m_sunset; }
        QTime sunsetTime() const  { return QTime::fromString(sunset(), "h:m ap"); }

        static int convertDegrees(int from, int to, int unit) {
            if(from == METRIC && to == IMPERIAL)
                return (((float) unit * 9.0f / 5.0f + 32.0f) + 0.5f);
            if(from == IMPERIAL && to == METRIC)
                return ((((float) unit - 32.0f) * 5.0f / 9.0f)  + 0.5f);
            return unit;
        }
        
        static int convertDistance(int from, int to, int unit) {
            if(from == IMPERIAL && to == METRIC)
                return ((float)unit * 1.609344f);
            if(from == METRIC && to == IMPERIAL)
                return ((float)unit / 1.609344f);
            return unit;
        }
        
    protected:
        //Current
        QString     m_date;
        QString     m_datelong;
        int         m_humid;
        int         m_current;
        QDate       m_day;
        
        //day values
        QString     m_windDirecCurr;
        int         m_windSpeedCurr;
        QString     m_windDirec;
        int         m_windSpeed;
        int         m_high;
        int         m_low;
        int         m_rfhigh;
        int         m_rflow;
        QString     m_desc;
        QString     m_emblem;
        QString     m_emblemCurr;

        //night values
        bool        m_hasNightValues;
        QString     m_nightWindDirec;
        int         m_nightWindSpeed;
        int         m_nightHigh;
        int         m_nightLow;
        int         m_nightRfHigh;
        int         m_nightRfLow;
        QString     m_nightDesc;
        QString     m_nightEmblem;
        
        //Config
        int         m_units;
        QString     m_time;
        QString     m_observation;
        QString     m_sunrise;
        QString     m_sunset;
};


class YaWPWeatherInfo {
    public:
        YaWPWeatherInfo(){}
        YaWPWeatherInfo(int size) {
            m_size = size;
            for(int i = 0; i < size; i++)
                m_days.append(YaWPDay());
        }
        ~YaWPWeatherInfo(){};
        const QString & message() const {return m_message;}
        void setMessage(const QString & message) {m_message = message;}
        const QVector<YaWPDay> & days() const {return m_days;}
        QVector<YaWPDay> & days(){return m_days;}
        void reset() {
          m_days.clear();
          for (int i = 0; i < m_size; i++)
            m_days.append(YaWPDay());
        }
    protected:
        QString m_message;
        QVector<YaWPDay>    m_days;
        int m_size;
};

#endif //YAWP_WDAY_H
