 /*
  *  Copyright (C) 2008 Marián Kyral
  *  Copyright (C) 2008 Ezequiel R. Aguerre
  *  Copyright (C) 2008 Pierpaolo Vittorini
  *  Copyright (C) 2008 Ruan Strydom
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 2 of the License, or
  * (at your option) any later version.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  */

#ifndef YAWP_WSERV_H
#define YAWP_WSERV_H

#include "yawpwday.h"

#include <QObject>
#include <kdebug.h>
#include <kio/job.h>

//-----------------------------------------------------------------------------
/** The abstract base class of a weather service.
	@see YaWPGoogleWeatherService
	@author Ruan <ruans@kr8.co.za>
 */
class YaWPWeatherService : public QObject {
     Q_OBJECT
  public:
    static const int SUCCESS = 0;
    static const int CONNECTION_FAILED = 1;
    static const int DATA_FAILED = 2;
    static const int ERROR = 3;
    static const int CACHE = 4;

    virtual ~YaWPWeatherService(){}

    virtual void update(const QMap<QString,QString> &data);

    const QString & serviceName() const { return m_name; }
    const YaWPWeatherInfo& info(){return m_info;}
    const QPixmap& image() { return m_image; }
    const QPixmap& logo() { return m_logo; }
    
    // Static so we can use it in YaWPConfigDialog :-)
    static QString toPercentEncoding(const QString &);
  signals:
    void completed(QObject *, int);

  protected:
    YaWPWeatherService(const QString &name, int dayCount);

    bool readIconMapping(const QString & resource);
    QString mapIcon(const QString &icon) const;

    virtual bool parseInfo(const QByteArray &data, YaWPWeatherInfo &info) = 0;

    QMap<QString,QString> m_icons;
    YaWPWeatherInfo m_info;
    QPixmap m_image;
    QPixmap m_logo;
    QString m_xmlurl;
    QString m_imageurl;
    QString m_dir;
    int m_code;
    
  protected slots:
    void slotXmlData(KIO::Job *, const QByteArray &);
    void slotXmlResult(KJob *);
    void slotImageData(KIO::Job *, const QByteArray &);
    void slotImageResult(KJob *);

  private:
    QString m_name;
    QByteArray m_xmldata;
    QByteArray m_imagedata;

    static const int UNDEFINED = -1;    
};

//-----------------------------------------------------------------------------
/** An google implementation of YaWPWeatherService.
	@author Ruan <ruans@kr8.co.za>
 */
class YaWPGoogleWeatherService : public YaWPWeatherService {
    Q_OBJECT
  public:
    YaWPGoogleWeatherService();

    virtual ~YaWPGoogleWeatherService();

    void update(const QMap<QString,QString> &data);

  private:
    bool parseInfo(const QByteArray &data, YaWPWeatherInfo &info);

    QString             m_city;
    QString             m_country;
};

//-----------------------------------------------------------------------------
/** An google implementation of YaWPWeatherService.
@author Ruan <ruans@kr8.co.za>
*/
class YaWPForecastfoxWeatherService : public YaWPWeatherService {
    Q_OBJECT
  public:
    YaWPForecastfoxWeatherService();

    virtual ~YaWPForecastfoxWeatherService();

    void update(const QMap<QString,QString> &data);

  private:
    bool parseInfo(const QByteArray &data, YaWPWeatherInfo &info);

    QString             m_location;
};


#endif //YAWP_WSERV_H
