/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301, USA.                                          *
 ***************************************************************************/

#ifndef ROOT_H
#define ROOT_H

//Qt
#include <qstring.h>
class QWidget;

namespace Core
{
	namespace Root
	{
		extern QString Password;

		/**
		* Pops up a dialog asking for the root password in order to be able
		* to operate with root previliges.
		*
		* @param parent Needed so that the password doesn't popup in the middle
		*               of...nowhere. It needs to be centred over the parent.
		*
		* @return whether the password was successfully acquired or not.
		*/
		bool requestPassword( QWidget *parent );

		/**
		* Makes the specified directory readable and executable by the user's group.
		* Only directories should be specified.
		*
		* @param dirPath The directory to make readable.
		*
		* @return Returns true on success. False upon any failure.
		*/
		bool makeDirReadableByUserGroup( const QString &dirPath, QWidget *parent );
		/**
		* Makes the specified directory writable by the user's group.
		* Only directories should be specified.
		*
		* @param dirPath The directory to make writable.
		*
		* @return Returns true on success. False upon any failure.
		*/
		bool makeDirWritableByUserGroup( const QString &dirPath, QWidget *parent );
	}
}

#endif
