/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301, USA.                                          *
 ***************************************************************************/

#ifndef MAP_EDITOR_H
#define MAP_EDITOR_H

//KDE
#include <kdialog.h>

//Ui
#include "ui_mapeditor.h"

//KGRUBEditor
#include "core/datatypes.h"

/**
 * @short Map Editor.
 *
 * Creates / edits GRUB maps.
 */
class MapEditor : public KDialog, private Ui::MapEditor
{
Q_OBJECT
public:
	/**
	* Sets up the GUI and shows the map.
	*
	* @param map The GRUB Map to create/edit.
	* @param parent QWidget parent. Self explanatory.
	*/
	MapEditor( GRUB::ComplexCommand::Map *map, QWidget *parent = 0 );
	/**
	* Desctructor.
	*/
	~MapEditor();
private:
	/**
	* Connects all signals to their slots.
	*/
	void setupConnections();
private slots:
	/**
	* Checks whether both maps are empty.
	* If not, the user is allowed to procede.
	*/
	void checkMaps();
	/**
	* Triggered when OK is clicked in order to save all
	* changes done to the original map.
	*/
	void okClicked();
private:
	GRUB::ComplexCommand::Map *m_map;
};

#endif
