/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "PixelVisitor_p.h"

// LLVM
#include <llvm/Constant.h>
#include <llvm/BasicBlock.h>
#include <llvm/Instructions.h>
#include <llvm/Function.h>

#include "GTLCore/LLVMBackend/ExpressionResult_p.h"
#include "GTLCore/LLVMBackend/ExpressionGenerationContext_p.h"
#include "GTLCore/LLVMBackend/CodeGenerator_p.h"
#include "GTLCore/LLVMBackend/GenerationContext_p.h"
#include "GTLCore/Macros_p.h"
#include "GTLCore/Type.h"

#include "Debug.h"
#include "CodeGenerator_p.h"
#include "wrappers/PixelWrap_p.h"

using namespace OpenShiva;

PixelVisitor* pixelVisitor = 0;

STATIC_INITIALISATION( PixelVisitor )
{
  pixelVisitor = new PixelVisitor;
}


PixelVisitor::PixelVisitor()
{
}

PixelVisitor::~PixelVisitor()
{
}

const LLVMBackend::Visitor* PixelVisitor::instance()
{
  return pixelVisitor;
}

const GTLCore::Type* PixelVisitor::pointerToIndexType( const GTLCore::Type* _type ) const
{
  return GTLCore::Type::Float32;
}

llvm::Value* PixelVisitor::pointerToIndex( LLVMBackend::GenerationContext& _generationContext, LLVMBackend::ExpressionGenerationContext& _expressionGenerationContext, llvm::Value* _pointer, const GTLCore::Type* _type, llvm::Value* _index) const
{
  llvm::Value* ptr = CodeGenerator::accessPixelDataAsF32Ptr( _generationContext, _expressionGenerationContext.currentBasicBlock(), _pointer );
  return llvm::GetElementPtrInst::Create( ptr, _index, "", _expressionGenerationContext.currentBasicBlock());
}

LLVMBackend::ExpressionResult PixelVisitor::get( LLVMBackend::GenerationContext& _generationContext, llvm::BasicBlock* _currentBlock, llvm::Value* _pointer, const GTLCore::Type* _pointerType) const
{
#if 0
  SHIVA_DEBUG( *_pointer << " " << *_pointerType );
  llvm::Value* result = new llvm::LoadInst(
      CodeGenerator::accessPixelDataPtr( _generationContext, _currentBlock, _pointer ),
      "",
      _currentBlock );
  SHIVA_DEBUG( *_pointer << " " << *result );
  return GTLCore::ExpressionResult( result, (*_pointerType->structDataMembers())[0].type());
#endif
  return LLVMBackend::ExpressionResult(_pointer, _pointerType);
}

llvm::BasicBlock* PixelVisitor::set( LLVMBackend::GenerationContext& _generationContext, llvm::BasicBlock* _currentBlock, llvm::Value* _pointer, const GTLCore::Type* _pointerType, llvm::Value* _value, const GTLCore::Type* _valueType, bool _allocatedInMemory) const
{
  SHIVA_DEBUG( "Pointer Type = " << *_pointerType << " Value Type = " << *_valueType );
  SHIVA_DEBUG( "Pointer = " << *_pointer << " Value = " << *_value );
  if( _valueType->dataType() == GTLCore::Type::STRUCTURE )
  {
    GTL_ASSERT( _valueType == _pointerType );
    _value = new llvm::LoadInst( CodeGenerator::accessPixelDataPtr( _generationContext, _currentBlock, _value ), "", _currentBlock);
  }
  GTL_DEBUG( "Value = " << *_value );
  new llvm::StoreInst( _value,
                       CodeGenerator::accessPixelDataPtr( _generationContext, _currentBlock, _pointer ),
                       "",
                       _currentBlock );
  return _currentBlock;
}

llvm::BasicBlock* PixelVisitor::initialise( LLVMBackend::GenerationContext& _generationContext, llvm::BasicBlock* _currentBlock, llvm::Value* _pointer, const GTLCore::Type* _pointerType, const std::list< llvm::Value*>& _sizes, bool _allocatedInMemorys) const
{
  // Don't do nothing
  return _currentBlock;
}

llvm::BasicBlock* PixelVisitor::cleanUp( LLVMBackend::GenerationContext& _generationContext, llvm::BasicBlock* _currentBlock, llvm::Value* _pointer, const GTLCore::Type* _pointerType, llvm::Value* _donttouch, bool _allocatedInMemory, bool _ignoreCount, bool _deletePointer ) const
{
  
  if( _deletePointer )
  {
    
    llvm::Value* test = LLVMBackend::CodeGenerator::createStrictInferiorExpression( _currentBlock, LLVMBackend::CodeGenerator::getCountFieldOf( _currentBlock, _pointer), GTLCore::Type::Integer32, LLVMBackend::CodeGenerator::integerToConstant( _generationContext.llvmContext(), INT32_C(1) ), GTLCore::Type::Integer32 );
    llvm::BasicBlock* firstIfBlock = llvm::BasicBlock::Create(_generationContext.llvmContext(), "firstIfBlockStructureVisitorCleanUp");
    _generationContext.llvmFunction()->getBasicBlockList().push_back( firstIfBlock);
    llvm::BasicBlock* afterIfBlock = llvm::BasicBlock::Create(_generationContext.llvmContext(), "afterIfBlockStructureVisitorCleanUp");
    _generationContext.llvmFunction()->getBasicBlockList().push_back( afterIfBlock);
    if( _allocatedInMemory )
    {
      LLVMBackend::CodeGenerator::freeMemory( _generationContext, _pointer, firstIfBlock );
    }
    LLVMBackend::CodeGenerator::createIfStatement( _currentBlock, test, GTLCore::Type::Boolean, firstIfBlock, firstIfBlock, afterIfBlock );
    return afterIfBlock;
  }
  
  return _currentBlock;
}

llvm::BasicBlock* PixelVisitor::mark( LLVMBackend::GenerationContext& _generationContext, llvm::BasicBlock* _currentBlock, llvm::Value* _pointer, const GTLCore::Type* _pointerType, llvm::Value* _increment ) const
{
  LLVMBackend::CodeGenerator::incrementCountFieldOf( _currentBlock, _pointer, _increment );
  return _currentBlock;
}

llvm::Constant* PixelVisitor::createStaticVariable( llvm::Module* /*_module*/, const GTLCore::Type* /*type*/, const std::list< int>& /*_sizes */) const
{
  GTL_ABORT("Unimplemented");
  return 0; 
}
