#ifndef pqVisItDatabaseBridgePanel_h
#define pqVisItDatabaseBridgePanel_h

#include "pqNamedObjectPanel.h"
#include "pqComponentsExport.h"// no comment
#include <vtkstd/vector>// no comment

#include "ui_pqVisItDatabaseBridgeForm.h"//  no comment
using Ui::pqVisItDatabaseBridgeForm;

// define this for cerr status.
// #define vtkVisitDatabaseBridgeDEBUG

class vtkGraph;
class pqProxy;
class vtkEventQtSlotConnect;
class QWidget;

class pqVisItDatabaseBridgePanel : public pqNamedObjectPanel
{
  Q_OBJECT
public:
  //pqVisItDatabaseBridgePanel();
  pqVisItDatabaseBridgePanel(pqProxy* proxy, QWidget* p = NULL);
  ~pqVisItDatabaseBridgePanel();


protected slots:
  // Description:
  // Update information events are generated by PV in many instances.
  // We need to watch for the ones coresponding to RequestInformation
  // on the server side where the new database view is stored in 
  // vtkInformation. This will take that information object
  // and load it in to the QTreeWidget.
  void UpdateInformationEvent();
  // Description:
  // This is where we have to communicate our state to the server.
  void accept();
  // Description:
  // 
  void UpdateCheckState(QTreeWidgetItem *item, int col);

private:
  int NumberOfChildrenChecked(QTreeWidgetItem *item);


private:
  pqVisItDatabaseBridgeForm *Form;
  vtkEventQtSlotConnect *VTKConnect;
  int ViewMTime;
  vtkstd::vector<QTreeWidgetItem *> Items; // Indexed by vertex
  vtkGraph *DatabaseView;
};

#endif
