/*
 */

/*
WNN7 CLIENT LIBRARY--SOFTWARE LICENSE TERMS AND CONDITIONS


Wnn7 Client Library :
(C) Copyright OMRON Corporation.       1995,1998,2000,2001 all rights reserved.
(C) Copyright OMRON Software Co., Ltd. 1995,1998,2000,2001 all rights reserved.

Wnn Software :
(C) Copyright Kyoto University Research Institute for Mathematical Sciences
     1987, 1988, 1989, 1990, 1991, 1992, 1993
(C) Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1993
(C) Copyright ASCTEC, Inc.  1987, 1988, 1989, 1990, 1991, 1992, 1993

Preamble

These Wnn7 Client Library--Software License Terms and Conditions
 (the "License Agreement") shall state the conditions under which you are
 permitted to copy, distribute or modify the software which can be used
 to create Wnn7 Client Library (the "Wnn7 Client Library").  The License
 Agreement can be freely copied and distributed verbatim, however, you
 shall NOT add, delete or change anything on the License Agreement.

OMRON Corporation and OMRON Software Co., Ltd. (collectively referred to
 as "OMRON") jointly developed the Wnn7 Software (development code name
 is FI-Wnn), based on the Wnn Software.  Starting from November, 1st, 1998,
 OMRON publishes the source code of the Wnn7 Client Library, and OMRON
 permits anyone to copy, distribute or change the Wnn7 Client Library under
 the License Agreement.

Wnn7 Client Library is based on the original version of Wnn developed by
 Kyoto University Research Institute for Mathematical Sciences (KURIMS),
 OMRON Corporation and ASTEC Inc.

Article 1.  Definition.

"Source Code" means the embodiment of the computer code, readable and
 understandable by a programmer of ordinary skills.  It includes related
 source code level system documentation, comments and procedural code.

"Object File" means a file, in substantially binary form, which is directly
 executable by a computer after linking applicable files.

"Library" means a file, composed of several Object Files, which is directly
 executable by a computer after linking applicable files.

"Software" means a set of Source Code including information on its use.

"Wnn7 Client Library" the computer program, originally supplied by OMRON,
 which can be used to create Wnn7 Client Library.

"Executable Module" means a file, created after linking Object Files or
 Library, which is directly executable by a computer.

"User" means anyone who uses the Wnn7 Client Library under the License
 Agreement.

Article 2.  Copyright

2.1  OMRON Corporation and OMRON Software Co., Ltd. jointly own the Wnn7
 Client Library, including, without limitation, its copyright.

2.2  Following words followed by the above copyright notices appear
 in all supporting documentation of software based on Wnn7 Client Library:

  This software is based on the original version of Wnn7 Client Library
  developed by OMRON Corporation and OMRON Software Co., Ltd. and also based on
  the original version of Wnn developed by Kyoto University Research Institute
  for Mathematical Sciences (KURIMS), OMRON Corporation and ASTEC Inc.

Article 3.  Grant

3.1  A User is permitted to make and distribute verbatim copies of
 the Wnn7 Client Library, including verbatim of copies of the License
 Agreement, under the License Agreement.

3.2  A User is permitted to modify the Wnn7 Client Library to create
 Software ("Modified Software") under the License Agreement.  A User
 is also permitted to make or distribute copies of Modified Software,
 including verbatim copies of the License Agreement with the following
 information.  Upon modifying the Wnn7 Client Library, a User MUST insert
 comments--stating the name of the User, the reason for the modifications,
 the date of the modifications, additional terms and conditions on the
 part of the modifications if there is any, and potential risks of using
 the Modified Software if they are known--right after the end of the
 License Agreement (or the last comment, if comments are inserted already).

3.3  A User is permitted to create Library or Executable Modules by
 modifying the Wnn7 Client Library in whole or in part under the License
 Agreement.  A User is also permitted to make or distribute copies of
 Library or Executable Modules with verbatim copies of the License
 Agreement under the License Agreement.  Upon modifying the Wnn7 Client
 Library for creating Library or Executable Modules, except for porting
 a computer, a User MUST add a text file to a package of the Wnn7 Client
 Library, providing information on the name of the User, the reason for
 the modifications, the date of the modifications, additional terms and
 conditions on the part of the modifications if there is any, and potential
 risks associated with using the modified Wnn7 Client Library, Library or
 Executable Modules if they are known.

3.4  A User is permitted to incorporate the Wnn7 Client Library in whole
 or in part into another Software, although its license terms and
 conditions may be different from the License Agreement, if such
 incorporation or use associated with the incorporation does NOT violate
 the License Agreement.

Article 4. Warranty

THE WNN7 CLIENT LIBRARY IS PROVIDED BY OMRON ON AN "AS IS" BAISIS.
  OMRON EXPRESSLY DISLCIAMS ANY AND ALL WRRANTIES, EXPRESS OR IMPLIED,
 INCLUDING, WITHOUT LIMITATION, WARRANTIES OF MERCHANTABILITY AND FITNESS
 FOR A PARTICULAR PURPOSE, IN CONNECTION WITH THE WNN7 CLIENT LIBRARY
 OR THE USE OR OTHER DEALING IN THE WNN7 CLIENT LIBRARY.  IN NO EVENT
 SHALL OMRON BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, PUNITIVE
 OR CONSEQUENTIAL DAMAGES OF ANY KIND WHATSOEVER IN CONNECTION WITH THE
 WNN7 CLIENT LIBRARY OR THE USE OR OTHER DEALING IN THE WNN7 CLIENT
LIBRARY.

***************************************************************************
Wnn7 Client Library :
(C) Copyright OMRON Corporation.       1995,1998,2000,2001 all rights reserved.
(C) Copyright OMRON Software Co., Ltd. 1995,1998,2000,2001 all rights reserved.

Wnn Software :
(C) Copyright Kyoto University Research Institute for Mathematical Sciences
     1987, 1988, 1989, 1990, 1991, 1992, 1993
(C) Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1993
(C) Copyright ASCTEC, Inc.  1987, 1988, 1989, 1990, 1991, 1992, 1993
***************************************************************************

Comments on Modifications:
*/

/*	Version 4.0
 */
/*
  Binary (Updatable, Stable) dictionary common routine.
*/

#if defined(JS)
#ifdef WRITE_CHECK
#define BDIC_WRITE_CHECK
#endif /* WRITE_CHECK */
#endif /* JS */

#ifdef UX386
#include <X11/Xos.h>
#else
#include <sys/types.h>
#endif
#ifndef JS
#include <sys/stat.h>
#include <stdio.h>
#include "commonhd.h"
#include "jslib.h"
#include "jh.h"
#endif
#include "jdata.h"
#include "wnn_os.h"
#include "wnn_string.h"

#ifdef JS
#ifndef BDIC_WRITE_CHECK
#define vputc(X, pt) putc((X), (pt))
#endif /* !BDIC_WRITE_CHECK */
#define vgetc(pt) getc(pt)
#else /* JS */
#define vputc(X, pt) putc((X), (pt))
#define vgetc(pt) getc(pt)
#endif /* JS */

#ifndef min
#define min(a, b) ((a > b)? b:a)
#define max(a, b) ((a < b)? b:a)
#endif

/*:::DOC_START
 *
 *    Function Name: dic_fopen
 *    Description  : open normal dictionary
 *    Parameter    :
 *         file_name:     	(In) file_name
 *         mode_str:     	(In) open mode
 *
 *    Return value : file pointer for fopen-ed or popen-ed dictionary file
 *
 *    Revision history:
 *         22-Sep-94: initial
 *
 *:::DOC_END
 */
#ifdef JS
static
#endif
FILE *
dic_fopen(file_name, mode_str)
char *file_name;
char *mode_str;
{
	return(fopen(file_name , mode_str));
} /* End of dic_fopen */

/*:::DOC_START
 *
 *    Function Name: dic_fclose
 *    Description  : close dictionary file
 *    Parameter    :
 *         fp:     	(In) file pointer for dictionary file
 *
 *    Return value : None.
 *
 *    Revision history:
 *         22-Sep-94: initial
 *
 *:::DOC_END
 */
#ifdef JS
static
#endif
void
dic_fclose(fp)
FILE *fp;
{
	if (fp != (FILE*)-1 && fp != NULL)
		fclose(fp);
} /* End of dic_fclose */

/*:::DOC_START
 *
 *    Function Name: cd_convert_yomi
 *    Description  : convert or dis-convert one w_char in yomi
 *    Parameter    :
 *         w_c:     	  (In) a w_char to be converted or dis-converted.
 *         deconvert:     (In) 0 specify convert, !0 specify dis-convert.
 *
 *    Return value : converted or dis-converted one w_char in yomi. or Null.
 *
 *    Revision history:
 *         22-Sep-94: initial
 *
 *:::DOC_END
 */
#ifdef JS
static
#endif
w_char
cd_convert_yomi(w_c, deconvert)
w_char w_c;
int deconvert;
{
	int j;
	/* data for conversion */
	/* convert to ascii */
	int cvt_tbl_size = 128-33-1; 
	int cvt_tbl_offset = 33;
	static w_char cvt_tbl[] = {
		         0xa1aa, 0xa1af, 0xa1f4, 0xa1f0, 0xa1f3, 0xa1f5, 0xa1ad, /* 041 ! - ' */
		 0xa1ca, 0xa1cb, 0xa1f6, 0xa1dc, 0xa1a4, 0xa1dd, 0xa1a5, 0xa1bf, /* 050 ( - / */
		 0xa3b0, 0xa3b1, 0xa3b2, 0xa3b3, 0xa3b4, 0xa3b5, 0xa3b6, 0xa3b7, /* 060 0 - 7 */
		 0xa3b8, 0xa3b9, 0xa1a7, 0xa1a8, 0xa1e3, 0xa1e1, 0xa1e4, 0xa1a9, /* 070 8 - ? */
		 0xa1f7, 0xa3c1, 0xa3c2, 0xa3c3, 0xa3c4, 0xa3c5, 0xa3c6, 0xa3c7, /* 100 @ - G */
		 0xa3c8, 0xa3c9, 0xa3ca, 0xa3cb, 0xa3cc, 0xa3cd, 0xa3ce, 0xa3cf, /* 110 H - O */
		 0xa3d0, 0xa3d1, 0xa3d2, 0xa3d3, 0xa3d4, 0xa3d5, 0xa3d6, 0xa3d7, /* 120 P - W */
		 0xa3d8, 0xa3d9, 0xa3da, 0xa1ce, 0xa1ef, 0xa1cf, 0xa1b0, 0xa1b2, /* 130 X - _ */
		 0xa1ae, 0xa3e1, 0xa3e2, 0xa3e3, 0xa3e4, 0xa3e5, 0xa3e6, 0xa3e7, /* 140 ` - g */
		 0xa3e8, 0xa3e9, 0xa3ea, 0xa3eb, 0xa3ec, 0xa3ed, 0xa3ee, 0xa3ef, /* 150 h - o */
		 0xa3f0, 0xa3f1, 0xa3f2, 0xa3f3, 0xa3f4, 0xa3f5, 0xa3f6, 0xa3f7, /* 160 p - w */
		 0xa3f8, 0xa3f9, 0xa3fa, 0xa1d0, 0xa1c3, 0xa1d1, 0xa1b1,         /* 170 x - ~ */
	};
	int cvt_tbl2_size = 3; 
	int cvt_tbl2_offset = 0;
	static w_char cvt_tbl2[][2] = {
		  { 0xa1bc, 0xf8, }, { 0xa5f4, 0xf9, }, { 0xa1ab, 0xfa, }, 
		  /* 1/28 "" 5/84 "" unused f8, 1/x "" dakuten  */
	};
	if( deconvert == 0 ) {
		if( w_c > 0x20 && w_c < 0x7f ) {
			/* already ascii, do nothing */
			return w_c;
		} else
			if( w_c > 0xa4a0 && w_c < 0xa4f4 ) {
				/* "hiragana", re-move first byte */
				return w_c&0xff;
			} 
		else
				if( w_c > 0xa5a0 && w_c < 0xa5f4 ) {
					/* "katakana", print warning and re-move first byte */
					return w_c&0xff;
				} 
				else {
					for(j=0; j<cvt_tbl_size ; j++ ) {
						if( w_c == cvt_tbl[j] ) {
							return j+cvt_tbl_offset;
						}
					}
					for(j=0; j<cvt_tbl2_size ; j++ ) {
						if( w_c == cvt_tbl2[j][0] ) {
							return cvt_tbl2[j][1]+cvt_tbl2_offset;
						}
					}
					return 0;
				}
	} else {
		if( w_c > 0x20 && w_c < 0x7f ) {
			/* convert to ascii */
			return cvt_tbl[w_c-cvt_tbl_offset];
		} else
			if( w_c > 0xa0 && w_c < 0xf4 ) {
				/* "hiragana" or "katakana", insert first byte */
				return w_c|0xa400;
			} 
			else {
				for(j=0; j<cvt_tbl2_size ; j++ ) {
					if( (w_c-cvt_tbl2_offset) == cvt_tbl2[j][1] ) {
						return cvt_tbl2[j][0];
					}
				}
				return 0;
			}
	}
}

/*:::DOC_START
 *
 *    Function Name: dic_unlink
 *    Description  : unlink dictionary file
 *    Parameter    :
 *         file_name:     	(In) file_name
 *
 *    Return value : same as unlink()
 *
 *    Revision history:
 *         22-Sep-94: initial
 *
 *:::DOC_END
 */
#ifdef JS
static
#endif
int
dic_unlink(file_name)
char *file_name;
{
	return unlink(file_name);
} /* End of dic_unlink */


#ifdef JS
static
#else
extern
#endif
int output_file_header(), input_file_uniq(), output_header_jt(),
#ifdef BDIC_WRITE_CHECK
put_short(), output_file_uniq(),
#endif /* BDIC_WRITE_CHECK */
create_file_header(), input_file_header(), output_header_hjt();

#ifdef JS
static
#else
extern
#endif
#ifdef BDIC_WRITE_CHECK
void new_pwd();
#else /* BDIC_WRITE_CHECK */
void put_short(), output_file_uniq(), new_pwd();
#endif /* BDIC_WRITE_CHECK */

#ifdef BDIC_WRITE_CHECK
static int
vputc(c, fp)
char c;
FILE *fp;
{
	if (fwrite(&c, sizeof(char), 1, fp) <= 0) return(-1);
	return(0);
}
#endif /* BDIC_WRITE_CHECK */

#ifdef JS
static
#endif
#ifdef BDIC_WRITE_CHECK
int
#else /* BDIC_WRITE_CHECK */
void
#endif /* BDIC_WRITE_CHECK */
putnull(ofpter, n)
register FILE *ofpter;
register int n;
{
	while (n-- > 0) {
#ifdef BDIC_WRITE_CHECK
		if (vputc('\0', ofpter) == -1) return(-1);
#else /* BDIC_WRITE_CHECK */
		vputc('\0', ofpter);
#endif /* BDIC_WRITE_CHECK */
	}
#ifdef BDIC_WRITE_CHECK
	return(0);
#endif /* BDIC_WRITE_CHECK */
}

#ifdef JS
static
#endif
#ifdef BDIC_WRITE_CHECK
int
#else /* BDIC_WRITE_CHECK */
void
#endif /* BDIC_WRITE_CHECK */
put_n_str(ofpter, c, n)
register FILE *ofpter;
register int n;
register char *c;
{
	while (n-- > 0) {
#ifdef BDIC_WRITE_CHECK
		if (vputc(*c++, ofpter) == -1) return(-1);
#else /* BDIC_WRITE_CHECK */
		vputc(*c++, ofpter);
#endif /* BDIC_WRITE_CHECK */
	}
#ifdef BDIC_WRITE_CHECK
	return(0);
#endif /* BDIC_WRITE_CHECK */
}

#ifdef JS
static
#endif
#ifdef BDIC_WRITE_CHECK
int
#else /* BDIC_WRITE_CHECK */
void
#endif /* BDIC_WRITE_CHECK */
put_n_EU_str(ofpter, c, n)
register FILE *ofpter;
register w_char *c;
register int n;
{
	while (n-- > 0) {
#ifdef BDIC_WRITE_CHECK
		if (put_short(ofpter, (int)(*c++)) == -1) return(-1);
#else /* BDIC_WRITE_CHECK */
		put_short(ofpter, (int)(*c++));
#endif /* BDIC_WRITE_CHECK */
	}
#ifdef BDIC_WRITE_CHECK
	return(0);
#endif /* BDIC_WRITE_CHECK */
}

#ifdef JS
static
#endif
#ifdef BDIC_WRITE_CHECK
int
#else /* BDIC_WRITE_CHECK */
void
#endif /* BDIC_WRITE_CHECK */
put_short(ofpter, i)
register FILE *ofpter;
register int i;
{
#ifdef BDIC_WRITE_CHECK
	if ((vputc(i >> 8, ofpter) == -1) ||
	    (vputc(i     , ofpter) == -1)) return(-1);
	return(0);
#else /* BDIC_WRITE_CHECK */
	vputc(i >> 8, ofpter);
	vputc(i     , ofpter);
#endif /* BDIC_WRITE_CHECK */
}

#ifdef JS
static
#endif
#ifdef BDIC_WRITE_CHECK
int
#else /* BDIC_WRITE_CHECK */
void
#endif /* BDIC_WRITE_CHECK */
putint(ofpter, i)
register FILE *ofpter;
register int i;
{
#ifdef BDIC_WRITE_CHECK
	if ((vputc(i >> 24, ofpter) == -1) ||
	    (vputc(i >> 16, ofpter) == -1) ||
	    (vputc(i >> 8 , ofpter) == -1) ||
	    (vputc(i      , ofpter) == -1)) return(-1);
	return(0);
#else /* BDIC_WRITE_CHECK */
	vputc(i >> 24, ofpter);
	vputc(i >> 16, ofpter);
	vputc(i >> 8 , ofpter);
	vputc(i      , ofpter);
#endif /* BDIC_WRITE_CHECK */
}

#ifdef JS
static
#endif
#ifdef BDIC_WRITE_CHECK
int
#else /* BDIC_WRITE_CHECK */
void
#endif /* BDIC_WRITE_CHECK */
put_n_int(ofpter, n)
register FILE *ofpter;
register int n;
{
#ifdef BDIC_WRITE_CHECK
	return(putnull(ofpter, n));
#else /* BDIC_WRITE_CHECK */
	putnull(ofpter, n);
#endif /* BDIC_WRITE_CHECK */
}

#ifdef JS
static
#endif
int
getnull(ifpter, n)
register FILE *ifpter;
register int n;
{
	register int k;

	while (n-- > 0) {
		k = vgetc(ifpter);
		if(k == -1)return(-1);
	}
	return(0);
}

#ifdef JS
static
#endif
int
getnstr(ifpter, n, st)
register FILE *ifpter;
register int n;
register char *st;
{
	int k;

	while (n-- > 0) {
		k = vgetc(ifpter);
		*st++ = k;
		if(k == -1)return(-1);
	}
	return(0);
}

#if	!defined(JS) && !defined(JSERVER)
int
get_n_EU_str(ifpter, n, st)
register FILE *ifpter;
register int n;
register w_char *st;
{
	register    int k;
	extern int get_short(short *sp, FILE *ifpter);

	while (n-- > 0) {
		k = get_short((short *)st++, ifpter);
		if(k == -1)return(-1);
	}
	return(0);
}

int
get_short(sp,ifpter)
register short *sp;
FILE *ifpter;
{
	register int i = 0;
	register int k;

	i |= (k = vgetc(ifpter)) << 8;
	if(k == -1)return(-1);
	i |= (k = vgetc(ifpter));
	if(k == -1)return(-1);
	*sp = i;
	return(0);
}
#endif

#ifdef JS
static
#endif
int
getint(ip,ifpter)
register FILE *ifpter;
int *ip;
{
	register int i = 0;
	register int k;

	i |= (k = vgetc(ifpter)) << 24;
	if(k == -1)return(-1);
	i |= (k = vgetc(ifpter)) << 16;
	if(k == -1)return(-1);
	i |= (k = vgetc(ifpter)) << 8;
	if(k == -1)return(-1);
	i |= (k = vgetc(ifpter));
	if(k == -1)return(-1);
	*ip = i;
	return(0);
}

#ifndef JS
void
udytoS(yomi,tnum,hostart,tary)
register w_char *yomi;
register int tnum;
char *hostart;
register struct uind1 *tary;
{
	struct uind2 *hop;
	int len;

	hop = (struct uind2 *)((char *)hostart + tary[tnum].pter);
	yomi[0] = tary[tnum].yomi1 >> 16;
	yomi[1] = tary[tnum].yomi1 & 0xffff;
	if(yomi[1]){
		yomi[2] = tary[tnum].yomi2 >> 16;
		if(yomi[2]){
			yomi[3] = tary[tnum].yomi2 & 0xffff;
		}
	}
	len = hop->yomi[0];
	/*Strncpy(yomi + 4, (hop->yomi) + 1, len - 4);
	      In order not to use ../etc/strings.c*/
	memcpy((char *)(yomi + 4), (char *)((hop->yomi) + 1), max(0, ((len - 4)) * 2));
	yomi[len] = 0;
}
#endif

#ifdef BDIC_WRITE_CHECK
static char *
make_tmp_name(n)
char *n;
{
	static char buf[MAXPATHLEN];

	if (n == NULL || *n == '\0') return NULL;
	snprintf(buf, sizeof(buf), "%s~", n);
	return(buf);
}

static char *
make_backup_name(n)
char *n;
{
	static char buf[MAXPATHLEN];

	if (n == NULL || *n == '\0') return NULL;
	snprintf(buf, sizeof(buf), "%s#", n);
	return(buf);
}

#ifdef JS
static
#endif
void
check_backup(n)
char *n;
{
	char *p;

	if ((p = make_tmp_name(n)) && (access(p, F_OK) != -1)) unlink(p);
	if ((p = make_backup_name(n)) && (access(p, F_OK) != -1)) {
		unlink(n);
		link(p, n);
		unlink(p);
	}
}

#ifdef JS
static
#endif
copy_file_to_file(from, to)
FILE *from, *to;
{
	char buf[1024];
	int r_len, w_len, i;

	for (;;) {
		r_len = fread(buf, 1, sizeof(buf), from);
		if (r_len <= 0) break;
		for ( i = 0; i < r_len; i += w_len) {
			w_len = fwrite(&buf[i], 1, r_len - i, to);
			if (w_len <= 0) {
				fseek(from, 0, 0);
				fseek(to, 0, 0);
				return(-1);
			}
			if (w_len >= r_len) break;
		}
	}
	fseek(from, 0, 0);
	fseek(to, 0, 0);
	return(0);
}

#ifdef JS
static
#endif
void
delete_tmp_file(n)
char *n;
{
	if (n && *n) unlink(n);
}

#ifdef JS
static
#endif
char *
make_backup_file(n)
char *n;
{
	FILE *fp, *fp2;
	char *p, *p2;

	if ((p = make_backup_name(n)) == NULL) return(NULL);
	if ((p2 = make_tmp_name(n)) == NULL) return(NULL);

	fp = fp2 = NULL;
	if (((fp = fopen(p2, "w+")) == NULL) || ((fp2 = fopen(n, "r")) == NULL)) {
		if(fp) fclose(fp);
		if(fp2) fclose(fp2);
		return NULL;
	}
	if (copy_file_to_file(fp2, fp) == -1) {
		fclose(fp);
		fclose(fp2);
		return(NULL);
	}
	fclose(fp);
	fclose(fp2);
	if (access(p, F_OK) != -1) unlink(p);
	link(p2, p);
	unlink(p2);
	return(p);
}

#ifdef JS
static
#endif
char *
make_tmp_file(n, copy, ret_fp)
char *n;
int copy;
FILE **ret_fp;
{
	FILE *fp, *fp2;
	struct wnn_file_head fh;
	char *p;

	p = make_tmp_name(n);
	if ((fp = fopen(p, "w+")) == NULL) {
		*ret_fp = NULL;
		return NULL;
	}
	if (copy && (fp2 = fopen(n, "r")) != NULL) {
		input_file_header(fp2, &fh);
		fseek(fp2, 0, 0);
		if ((copy_file_to_file(fp2, fp) == -1) ||
		    (create_file_header(fp, fh.file_type, fh.file_passwd) == -1)) {
			fclose(fp);
			fclose(fp2);
			*ret_fp = NULL;
			return NULL;
		}
		fseek(fp, 0, 0);
		fclose(fp2);
	}
	*ret_fp = fp;
	return p;
}

#ifdef JS
static
#endif
void
move_tmp_to_org(tmp_name, org_name, copy)
char *tmp_name, *org_name;
int copy;
{
	FILE *org, *tmp;

	org = tmp = NULL;

	if (copy) {
		if (((tmp = fopen(tmp_name, "r")) == NULL) ||
		    ((org = fopen(org_name, "w+")) == NULL)) {
			if(tmp) fclose(tmp);
			if(org) fclose(org);
			return;
		}
		copy_file_to_file(tmp, org);
		fclose(tmp);
		fclose(org);
	} else {
		unlink(org_name);
		link(tmp_name, org_name);
	}
	unlink(tmp_name);
}

#ifdef JS
static
#endif
void
write_file_move_tmp_to_org(tmp_name, org_name, file_type, file_passwd, file_uniq)
char *tmp_name, *org_name;
int file_type;
char *file_passwd;
struct wnn_file_uniq *file_uniq;
{
	FILE *org, *tmp;

	org = tmp = NULL;

	if (((tmp = fopen(tmp_name, "r")) == NULL) ||
		((org = fopen(org_name, "w+")) == NULL)) {
		if(tmp) fclose(tmp);
		if(org) fclose(org);
		return;
	}
	copy_file_to_file(tmp, org);
#ifndef WNN_CHECK_INODE
	rewind(org);
	change_file_uniq1(org, file_type, file_passwd, file_uniq);
#endif 
	fclose(tmp);
	fclose(org);
	unlink(tmp_name);
}

#endif /* BDIC_WRITE_CHECK */

#ifdef JS
static
#endif
int
set_file_header(fh, ofpter, file_type, file_passwd)
FILE *ofpter;
int file_type;
char *file_passwd;
struct wnn_file_head *fh;
{
	/* WNN_HOSTLEN" is "fh->file_uniq.createhost" size */
	char hostname[WNN_HOSTLEN];
	struct stat buf;

	if(fstat(fileno(ofpter), &buf) == -1){
		return(-1);
	}
	gethostname(hostname, sizeof(hostname) - 1);
	hostname[sizeof(hostname) - 1] = '\0';

	fh->file_uniq.time = (int)buf.st_ctime;
	fh->file_uniq.dev = (int)buf.st_dev;
	fh->file_uniq.inode = (int)buf.st_ino;
	memset(fh->file_uniq.createhost, 0, WNN_HOSTLEN);
	strncpy(fh->file_uniq.createhost, hostname, WNN_HOSTLEN - 1);

	/* file_uniq_org */
	fh->file_uniq_org.time = (int)buf.st_ctime;
	fh->file_uniq_org.dev = (int)buf.st_dev;
	fh->file_uniq_org.inode = (int)buf.st_ino;
	memset(fh->file_uniq_org.createhost, 0, WNN_HOSTLEN);
	strncpy(fh->file_uniq_org.createhost, hostname, WNN_HOSTLEN - 1);

	fh->file_type = file_type;
	if(file_passwd){
		strncpy(fh->file_passwd, file_passwd, WNN_PASSWD_LEN);
	} else{
		memset(fh->file_passwd, 0, WNN_PASSWD_LEN);
	}
	return(0);
}

#ifdef JS
static
#endif
int
create_file_header(ofpter, file_type, file_passwd)
FILE *ofpter;
int file_type;
char *file_passwd;
{
	struct wnn_file_head fh;
	if(set_file_header(&fh, ofpter, file_type, file_passwd) == -1) return(-1);
	if(output_file_header(ofpter, &fh) == -1) return(-1);
	return(0);
}

/* 128 Bytes File Header */

#ifdef JS
static
#endif
int
output_file_header(ofpter, hp)
FILE *ofpter;
struct wnn_file_head *hp;
{
#ifdef BDIC_WRITE_CHECK
#ifdef WNN7_MAKE_DICT
	if ((put_n_str(ofpter, WNN7_FILE_STRING, WNN_FILE_STRING_LEN) == -1) ||
#else 
	if ((put_n_str(ofpter, WNN_FILE_STRING, WNN_FILE_STRING_LEN) == -1) ||
#endif 
	    (putint(ofpter, hp->file_type) == -1) ||
	    (output_file_uniq(&hp->file_uniq, ofpter) == -1) ||
	    (output_file_uniq(&hp->file_uniq_org, ofpter) == -1) ||
	    (put_n_str(ofpter, hp->file_passwd, WNN_PASSWD_LEN) == -1) ||
	    (putnull(ofpter, 36) == -1)) return(-1);		/* Future Use */
#else /* BDIC_WRITE_CHECK */
#ifdef WNN7_MAKE_DICT
	put_n_str(ofpter, WNN7_FILE_STRING, WNN_FILE_STRING_LEN);
#else 
	put_n_str(ofpter, WNN_FILE_STRING, WNN_FILE_STRING_LEN);
#endif 
	putint(ofpter, hp->file_type);
	output_file_uniq(&hp->file_uniq, ofpter);
	output_file_uniq(&hp->file_uniq_org, ofpter);
	put_n_str(ofpter, hp->file_passwd, WNN_PASSWD_LEN);
	putnull(ofpter, 36);		/* Future Use */
#endif /* BDIC_WRITE_CHECK */
	return(0);
}

#ifdef JS
static
#endif
int
input_file_header(ifpter, hp)
FILE *ifpter;
struct wnn_file_head *hp;
{
	char wnn_file_string[WNN_FILE_STRING_LEN + 1];
	int err = 0;

	getnstr(ifpter, WNN_FILE_STRING_LEN, wnn_file_string);
	if(strncmp(wnn_file_string, WNN_FILE_STRING, WNN_FILE_STRING_LEN)) {
		if(strncmp(wnn_file_string, WNN7_FILE_STRING, WNN_FILE_STRING_LEN))
			err = -1;
	}
	if(getint((&hp->file_type), ifpter) == -1) err = -1;
	if(input_file_uniq(&(hp->file_uniq), ifpter) == -1) err = -1;
	if(input_file_uniq(&(hp->file_uniq_org), ifpter) == -1) err = -1;
	getnstr(ifpter, WNN_PASSWD_LEN, hp->file_passwd);
	getnull(ifpter, 36);
	return(err);
}

#ifdef JS
static
#endif
#ifdef BDIC_WRITE_CHECK
int
#else /* BDIC_WRITE_CHECK */
void
#endif /* BDIC_WRITE_CHECK */
output_file_uniq(funiq, ofpter)
struct wnn_file_uniq *funiq;
FILE *ofpter;
{
#ifdef BDIC_WRITE_CHECK
	if ((putint(ofpter, funiq->time) == -1) ||
	    (putint(ofpter, funiq->dev) == -1) ||
	    (putint(ofpter, funiq->inode) == -1) ||
	    (put_n_str(ofpter, funiq->createhost,
	    strlen(funiq->createhost)) == -1) ||
	    (putnull(ofpter, WNN_HOSTLEN - strlen(funiq->createhost)) == -1))
		return(-1);
	return(0);
#else /* BDIC_WRITE_CHECK */
	putint(ofpter, funiq->time);
	putint(ofpter, funiq->dev);
	putint(ofpter, funiq->inode);
	put_n_str(ofpter, funiq->createhost, strlen(funiq->createhost));
	putnull(ofpter, WNN_HOSTLEN - strlen(funiq->createhost));
#endif /* BDIC_WRITE_CHECK */
}

#ifdef JS
static
#endif
int
input_file_uniq(funiq, ifpter)
struct wnn_file_uniq *funiq;
FILE *ifpter;
{
	if(
       getint(&(funiq->time), ifpter) == -1 ||
	    getint(&(funiq->dev), ifpter) == -1 ||
	    getint(&(funiq->inode), ifpter) == -1 ||
	    getnstr(ifpter, WNN_HOSTLEN, funiq->createhost) == -1)
		return(-1);
	return(0);
}

#ifdef WNN_CHECK_INODE
static
#else 
#ifdef JS
static
#endif
#endif 
int
change_file_uniq1(ofpter, file_type, file_passwd, file_uniq)
FILE *ofpter;
int file_type;
char *file_passwd;
struct wnn_file_uniq *file_uniq;
{
	struct stat buf;
	char hostname[WNN_HOSTLEN];
	struct wnn_file_head fh;

	if(fstat(fileno(ofpter), &buf) == -1){
		return(-1);
	}
	gethostname(hostname, sizeof(hostname) - 1);
	hostname[sizeof(hostname) - 1] = '\0';

	fh.file_uniq.time = (int)buf.st_ctime;
	fh.file_uniq.dev = (int)buf.st_dev;
	fh.file_uniq.inode = (int)buf.st_ino;
	memset(fh.file_uniq.createhost, 0, WNN_HOSTLEN);
	strncpy(fh.file_uniq.createhost, hostname, WNN_HOSTLEN - 1);

	/* file_uniq_org */
	fh.file_uniq_org.time = file_uniq->time;
	fh.file_uniq_org.dev = file_uniq->dev;
	fh.file_uniq_org.inode = file_uniq->inode;
	memset(fh.file_uniq_org.createhost, 0, WNN_HOSTLEN);
	strncpy(fh.file_uniq_org.createhost, file_uniq->createhost, WNN_HOSTLEN - 1);

	fh.file_type = file_type;
	if(file_passwd){
		strncpy(fh.file_passwd, file_passwd, WNN_PASSWD_LEN);
	} else{
		memset(fh.file_passwd, 0, WNN_PASSWD_LEN);
	}
	if(output_file_header(ofpter, &fh) == -1) return(-1);
	return(0);
}

#ifdef WNN_CHECK_INODE

static
int
check_inode(f, fh)
FILE *f;
struct wnn_file_head *fh;
{
	struct stat buf;
	if(fstat(fileno(f), &buf) == -1){
		return(-1);
	}
	if((int)buf.st_ino != fh->file_uniq.inode){
		return(-1);
	}
	return(0);
}

/*:::DOC_START
 *
 *    Function Name: dic_check_inode
 *    Description  : check i-node of file
 *    Parameter    :
 *         f:           (In) file pointer for dictionary file
 *         fh:          (In) file header
 *
 *    Return value : check result, 0: same, -1: different
 *
 *    Revision history:
 *         22-Sep-94: initial
 *
 *:::DOC_END
 */
#ifdef JS
static
#endif
int
dic_check_inode(f, fh)
FILE *f;
struct wnn_file_head *fh;
{
	return(check_inode(f, fh));
} /* End of dic_check_inode */

#ifdef JS
static
#endif
int
change_file_uniq(fh, n)
struct wnn_file_head *fh;
char *n;
{
	int x;
	FILE *fp;
#ifdef BDIC_WRITE_CHECK
	char *tmp, *backup = NULL;
	backup = make_backup_file(n);
	if ((tmp = make_tmp_file(n, 1, &fp)) == NULL) {
		delete_tmp_file(backup);
#else /* BDIC_WRITE_CHECK */
	if((fp = fopen(n,"r+")) == NULL){
#endif /* BDIC_WRITE_CHECK */
		return(-1);
	}
	/* file_uniq_org ѹʤ */
#ifdef BDIC_WRITE_CHECK
	if (change_file_uniq1(fp, fh->file_type, fh->file_passwd, &(fh->file_uniq_org)) == -1) {
		fclose(fp);
		delete_tmp_file(tmp);
		delete_tmp_file(backup);
		return(-1);
	}
#else /* BDIC_WRITE_CHECK */
	change_file_uniq1(fp, fh->file_type, fh->file_passwd, &(fh->file_uniq_org));
#endif /* BDIC_WRITE_CHECK */
	fseek(fp, 0, 0);
	x = input_file_header(fp, fh);/* It must not occur. */
	fclose(fp);
#ifdef BDIC_WRITE_CHECK
	if(x == -1) {
		delete_tmp_file(tmp);
		delete_tmp_file(backup);
		return(-1);
	}
	move_tmp_to_org(tmp, n, 0);
	delete_tmp_file(backup);
#else /* BDIC_WRITE_CHECK */
	if(x == -1) return(-1);
#endif /* BDIC_WRITE_CHECK */
	return(0);
}

#endif /* WNN_CHECK_INODE */



#if	!defined(JS) && !defined(JSERVER)
void
vputs(c, fp)
register char *c;
register FILE *fp;
{
	while(*c){
		vputc(*c++, fp);
	}
}

int
vputws(w, fp)
register w_char *w;
register FILE *fp;
{
	register int n;
	UCHAR tmp[LENGTHYOMI*3];

	n = wnn_sStrncpy(tmp, sizeof(tmp) - 1, w, -1);
	vputs(tmp, fp);
	return(n);
}
#endif


extern char *wnn_get_hinsi_name(int k);

#if	!defined(JS) && !defined(JSERVER)
int
put_yomi_str(yomi, ofpter)
w_char *yomi;
FILE *ofpter;
{
	register int c;
	register int i = 0;
	UCHAR tmp[LENGTHYOMI*3], *p;

	wnn_sStrncpy(tmp, sizeof(tmp) - 1, yomi, -1);
	for(p = tmp;*p;p++){
		c = (int)*p;
		if(c == '\\'){
			vputc('\\', ofpter);
			vputc('\\', ofpter);
			i += 2;
		} else if(c > 0x20){
			vputc(c, ofpter);
			i += 1;
		} else{
			char tmp[8];
			snprintf(tmp, sizeof(tmp), "\\0%o" , c);
			vputs(tmp, ofpter);
			i += strlen(tmp);
		}
	}
	return(i);
}
#endif

#ifndef JS
/*:::DOC_START
 *
 *    Function Name: Get_knj2
 *    Description  : get KOUHO string , YOMI string and comment string from 
 *                   "kptr" with "kanji2" offset
 *    Parameter    :
 *         kptr:     (In) wchar pointer of those strings
 *         kanji2:   (In) offset of terget entry. 嵭ݥ󥿡
 *                        ֤θ䡦ɤߡȤΥȥ󥰤ꤹ롣
 *                         0: jentptrΤΡ
 *                         1: 
 *                         .
 *                         n: n
 *         kouho:    (Out) return of the HOUHO() string
 *         yomi:     (Out) return of the YOMI(ɤ) string
 *         com:      (Out) return of the comment string
 *
 *    Return value :  None.
 *
 *    Revision history:
 *         31-AUG-94: just wrote this comment. no changes souces
 *
 *:::DOC_END
 */
void
Get_knj2(kptr,kanji2, kouho, yomi, comment)
UCHAR *kptr;
int kanji2;
w_char *kouho, *comment, *yomi;
{
	extern void get_kanji_str();

	int tcnt;
	for (tcnt = 0; tcnt < kanji2; tcnt++){
		kptr += *kptr;
	}
	get_kanji_str(kptr, kouho, yomi, comment);
	return;
}

static void
copy_kanji_str_from_cd(kptr, kanji)
UCHAR *kptr;
w_char *kanji;
{
	int n , k;
	n = *kptr++ - 1;
	for(k = 0 ; k < n ;) {
		if(kanji) *kanji++ = ((int) *kptr << 8 | *(kptr + 1));
		kptr += 2;
		k+= 2;
	}
	if(kanji)*kanji = 0;
}

void
get_kanji_str(kptr, kanji, yomi, comment)
UCHAR *kptr;
w_char *kanji, *comment, *yomi;
{
	w_char *tmpy;
	w_char *tmpk;
	w_char *tmpc;
	extern void Get_kanji_str_r();

	/* ɤߡȾ */
	if(kanji) kanji[0] = (w_char)0;
	if(yomi) yomi[0] = (w_char)0;
	if(comment) comment[0] = (w_char)0;

	/* CAUTION: jisho syurui is not checked, but ... */
	/* not compact dictionary case */
	if( (((int) (*kptr)) % 2 ) == 0){
		Get_kanji_str_r(kptr, &tmpk, &tmpy, &tmpc);

		if(kanji && tmpk)wnn_Sreverse(kanji, tmpk);
		if(yomi && tmpy)wnn_Sreverse(yomi, tmpy);
		if(comment && tmpc)wnn_Strcpy(comment, tmpc);
	} else{
		w_char *c;
		w_char tmpk_dt[LENGTHKANJI];
		c = tmpk = &tmpk_dt[0];
		copy_kanji_str_from_cd(kptr, c);
		if(kanji && tmpk)wnn_Sreverse(kanji, tmpk);
	}
}

/* ?? need doc. CAUTION: *tmpk is IO */
void
Get_kanji_str_r_cd (kptr, tmpk, tmpy, tmpc)
UCHAR *kptr;
w_char **tmpk, **tmpy, **tmpc;
{
	/* CAUTION: jisho syurui is not checked, but ... */
	/* not compact dictionary case */
	if( (((int) (*kptr)) % 2 ) == 0){
		printf("Get_kanji_str_r_cd: do not call me for non-compact dictionary.\n" );
	} else{
		/* compact dictionary case */
	}
	copy_kanji_str_from_cd(kptr, *tmpk);
}

void
Get_kanji_str_r(kptr, tmpk, tmpy, tmpc)
UCHAR *kptr;
w_char **tmpk, **tmpy, **tmpc;
{
	int state = *(kptr + 1);
	static w_char dmy = 0; /* Must not be allocated on Stack!! */
	int adres;

	/* CAUTION: jisho syurui is not checked, but ... */
	/* not compact dictionary case */
	if( (((int) (*kptr)) % 2 ) == 0){
	} else{
		/* compact dictionary case */
		printf("Get_kanji_str_r: do not call me for compact dictionary.\n" );
	}
	if(state & FORWARDED){
		/* Forward occures when comment-set is used */
		adres = (*(w_char *)(kptr + 2)) << 16 | (*(w_char *)(kptr + 4));
		Get_kanji_str_r(kptr + adres, tmpk, tmpy, tmpc);
		return;
	}
	/*    get_kanji_str_r(kptr, tmpk, tmpy, comment); */
	if(state & HAS_YOMI){
		*tmpy = ((w_char *)(kptr + 2));
		*tmpk = *tmpy + wnn_Strlen(*tmpy) + 1;
	} else{
		*tmpy = &dmy;
		*tmpk = ((w_char *)(kptr + 2));
	}
	if(state & HAS_COMMENT){
		*tmpc = *tmpk + wnn_Strlen(*tmpk) + 1;
	} else{
		*tmpc = &dmy;
	}
}


UCHAR
kanjiaddr(d0, kanji, yomi, comment)
UCHAR *d0;
w_char *kanji, *yomi, *comment;
{
	w_char *dest = (w_char *)(d0 + 2);
	int state = 0;
	w_char *pt;

	if(yomi && *yomi){
		pt = yomi + wnn_Strlen(yomi) - 1;
		for(;pt >= yomi;){
			*dest++ = *pt--;
		}
		state |= HAS_YOMI;
		*dest++ = 0;
	}

	pt = kanji + wnn_Strlen(kanji) - 1;
	for(;pt >= kanji;){
		*dest++ = *pt--;
	}
	*dest++ = 0;

	if(comment && *comment){
		pt = comment;
		for(;*pt;){
			*dest++ = *pt++;
		}
		state |= HAS_COMMENT;
		*dest++ = 0;
	}
	*d0 = (UCHAR)((UCHAR *)dest - d0);
	*(d0 + 1) = state;
	return(*d0);
}

#endif


/*:::DOC_START
 *
 *    Function Name: create_null_dic
 *    Description  : ե
 *    Parameter    :
 *         fn :      (In) ե̾
 *         comm :    (In) ե륳
 *         passwd    (In) եѥ
 *         hpasswd : (In) ٥ѥ
 *         which :   (In) ե륿
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
#ifdef JS
static
#endif
int
create_null_dic(fn, comm, passwd, hpasswd, which)
char  *fn;
w_char *comm;
char *passwd, *hpasswd;  /* not encoded passwd */
int which;
{
	FILE *fp;
	struct JT jt;
	char epasswd[WNN_PASSWD_LEN];
	extern void new_pwd();

	/* ޡˤϥƥ༭ޥΩƤ */
	if(which == WNN_MERGE_DICT) which |= WNN_SYSTEM_DICT;

	jt.total = 0;
	jt.gosuu = 0;
	if(hpasswd){
		new_pwd(hpasswd, jt.hpasswd);
	} else{
		memset(jt.hpasswd, 0, WNN_PASSWD_LEN);
	}
	jt.syurui = which;
	jt.maxserial = 0;
	jt.maxtable = 0;
	jt.maxhontai = (which == WNN_UD_DICT)? 4: 0;
	jt.maxkanji = 0;
	if(comm){
		jt.maxcomment = wnn_Strlen(comm);
	} else{
		jt.maxcomment = 0;
	}
	jt.maxhinsi_list = 0;
	jt.maxri1[D_YOMI] = 0;
	jt.maxri1[D_KANJI] = 0;
	jt.maxri2 = 0;

	if((fp = fopen(fn, "w+")) == NULL){
		return(-1);
	}
	if(passwd){
		new_pwd(passwd, epasswd);
	} else{
		memset(epasswd, 0, WNN_PASSWD_LEN);
	}
	if(create_file_header(fp, WNN_FT_DICT_FILE,epasswd) == -1 ||
		output_header_jt(fp, &jt) == -1){
		fclose(fp);
		return(-1);
	}
#ifdef BDIC_WRITE_CHECK
	if (put_n_EU_str(fp, comm, jt.maxcomment) == -1) {
		fclose(fp);
		return(-1);
	}
#else /* BDIC_WRITE_CHECK */
	put_n_EU_str(fp, comm, jt.maxcomment);
#endif /* BDIC_WRITE_CHECK */
	if(which == WNN_UD_DICT){
#ifdef BDIC_WRITE_CHECK
		if (putint(fp, 0) == -1) {	/* hontai[0] */
			fclose(fp);
			return(-1);
		}
#else /* BDIC_WRITE_CHECK */
		putint(fp, 0);			/* hontai[0] */
#endif /* BDIC_WRITE_CHECK */
	}

#ifdef	BSD42
	fchmod(fileno(fp), 0644);
	fclose(fp);
#else	/* SYSV */
	fclose(fp);
	chmod(fn, 0644);
#endif	/* BSD42 */
	return(0);
} /* End of create_null_dic */


#ifdef JS
static
#endif
int
create_hindo_file(funiq, fn, comm, passwd, serial)
struct wnn_file_uniq *funiq;
char *fn;
w_char *comm;
char *passwd;			/* Not encoded */
int serial;
{
	FILE *fp;
	struct HJT hjt;
	char epasswd[WNN_PASSWD_LEN];
	w_char tmp[1];
	int i;

	tmp[0] = 0;
	if(comm == NULL) comm = tmp;
	memcpy(&(hjt.dic_file_uniq), funiq, WNN_F_UNIQ_LEN);
	hjt.maxcomment = wnn_Strlen(comm);

	hjt.maxserial = serial;
	hjt.hindo_area = (int)((serial + MAX_HINDO_DATA_AREA - 1) / MAX_HINDO_DATA_AREA);
	if(hjt.hindo_area != 0) {
		if((hjt.curserial = (unsigned char *)
			malloc(hjt.hindo_area * sizeof(unsigned char))) == NULL)
			return(-1);
		for(i = 0; i < hjt.hindo_area; i++) (hjt.curserial)[i] = 0;
	} else
		hjt.curserial = NULL;

	if((fp = fopen(fn, "w+")) == NULL){
		return(-1);
	}
	if(passwd){
		new_pwd(passwd, epasswd);
	} else{
		memset(epasswd, 0, WNN_PASSWD_LEN);
	}
	if(create_file_header(fp, WNN_FT_HINDO_FILE, epasswd) == -1){
		fclose(fp);
		return(-1);
	}
#ifdef BDIC_WRITE_CHECK
	if ((output_header_hjt(fp, &hjt) == -1) ||
		(put_n_EU_str(fp, comm, hjt.maxcomment) == -1) ||
		(put_n_int(fp, 0) == -1)) {
		fclose(fp);
		return(-1);
	}
#else /* BDIC_WRITE_CHECK */
	output_header_hjt(fp, &hjt);
	put_n_EU_str(fp, comm, hjt.maxcomment);
	put_n_int(fp, 0);
#endif /* BDIC_WRITE_CHECK */

#ifdef	BSD42
	fchmod(fileno(fp), 0644);
	fclose(fp);
#else	/* SYSV */
	fclose(fp);
	chmod(fn, 0644);
#endif	/* BSD42 */
	return(0);
}

/* Header Total 128 Bytes */

#ifndef	JS
int
input_header_jt(ifpter, jt1)
FILE *ifpter;
struct JT *jt1;
{
	if(
   getint(&jt1->syurui , ifpter) == -1 ||
		getint(&jt1->maxcomment, ifpter) == -1 ||
		getint(&jt1->maxhinsi_list, ifpter) == -1 ||
		getint(&jt1->maxserial , ifpter) == -1 ||
		getint(&jt1->maxkanji , ifpter) == -1 ||
		getint(&jt1->maxtable , ifpter) == -1 ||
		getint(&jt1->maxhontai , ifpter) == -1 ||
		getint(&jt1->gosuu , ifpter) == -1 ||
		getnstr(ifpter, WNN_PASSWD_LEN, jt1->hpasswd) == -1 ||
		getint(&jt1->total , ifpter) == -1 ||
		getint(&jt1->maxri1[D_YOMI] , ifpter) == -1 ||
		getint(&jt1->maxri1[D_KANJI] , ifpter) == -1 ||
		getint(&jt1->maxri2, ifpter) == -1 ||
		getnull(ifpter, 56) == -1)
		return(-1);
	return(0);
}
#endif

#ifdef JS
static
#endif
int
output_header_jt(ofpter, jt1)
FILE *ofpter;
struct JT *jt1;
{
#ifdef BDIC_WRITE_CHECK
	if ((putint(ofpter, jt1->syurui) == -1) ||
		(putint(ofpter, jt1->maxcomment) == -1) ||
		(putint(ofpter,  jt1->maxhinsi_list) == -1) ||
		(putint(ofpter, jt1->maxserial) == -1) ||
		(putint(ofpter, jt1->maxkanji) == -1) ||
		(putint(ofpter, jt1->maxtable) == -1) ||
		(putint(ofpter, jt1->maxhontai) == -1) ||
		(putint(ofpter, jt1->gosuu) == -1) ||
		(put_n_str(ofpter, jt1->hpasswd, WNN_PASSWD_LEN) == -1) ||
		(putint(ofpter, jt1->total) == -1) ||
		(putint(ofpter, jt1->maxri1[D_YOMI]) == -1) ||
		(putint(ofpter, jt1->maxri1[D_KANJI]) == -1) ||
		(putint(ofpter, jt1->maxri2) == -1) ||
		(putnull(ofpter, 56) == -1)) return(-1);
#else /* BDIC_WRITE_CHECK */
	putint(ofpter, jt1->syurui);
	putint(ofpter, jt1->maxcomment);
	putint(ofpter,  jt1->maxhinsi_list);
	putint(ofpter, jt1->maxserial);
	putint(ofpter, jt1->maxkanji);
	putint(ofpter, jt1->maxtable);
	putint(ofpter, jt1->maxhontai);
	putint(ofpter, jt1->gosuu);
	put_n_str(ofpter, jt1->hpasswd, WNN_PASSWD_LEN);
	putint(ofpter, jt1->total);
	putint(ofpter, jt1->maxri1[D_YOMI]);
	putint(ofpter, jt1->maxri1[D_KANJI]);
	putint(ofpter, jt1->maxri2);
	putnull(ofpter, 56);
#endif /* BDIC_WRITE_CHECK */
	return(0);
}

/* Header 64 Byte */
#ifndef	JS
int
input_header_hjt(ifpter, hjt1)
FILE *ifpter;
struct HJT *hjt1;
{
	int i;
	if(
   input_file_uniq(&hjt1->dic_file_uniq, ifpter) == -1 ||  /* 7 * 4 */
	getint(&hjt1->maxcomment, ifpter) == -1 ||
		getint(&hjt1->maxserial, ifpter) == -1) return(-1);

	if(getint(&hjt1->hindo_area, ifpter) == -1)
		return(-1);
	if(hjt1->hindo_area != 0) {
		if((hjt1->curserial = (unsigned char *)
			malloc(hjt1->hindo_area * sizeof(unsigned char))) == NULL)
			return(-1);
		for(i = 0; i < hjt1->hindo_area; i++)
			(hjt1->curserial)[i] = vgetc(ifpter);
	} else
		hjt1->curserial = NULL;

	return(0);
}
#endif

#ifdef JS
static
#endif
int
output_header_hjt(ofpter, hjt1)
FILE *ofpter;
struct HJT *hjt1;
{
	int i;
#ifdef BDIC_WRITE_CHECK
	if ((output_file_uniq(&hjt1->dic_file_uniq, ofpter) == -1) ||
		(putint(ofpter, hjt1->maxcomment) == -1) ||
		(putint(ofpter, hjt1->maxserial) == -1) ||
		(putint(ofpter, hjt1->hindo_area) == -1)) return(-1);
	for(i = 0; i < hjt1->hindo_area; i++) {
		if(vputc((hjt1->curserial)[i], ofpter) == -1) return(-1);
	}
#else /* BDIC_WRITE_CHECK */
	output_file_uniq(&hjt1->dic_file_uniq, ofpter);
	putint(ofpter, hjt1->maxcomment);
	putint(ofpter, hjt1->maxserial);
	putint(ofpter, hjt1->hindo_area);
	for(i = 0; i < hjt1->hindo_area; i++)
		vputc((hjt1->curserial)[i], ofpter);
#endif /* BDIC_WRITE_CHECK */
	return(0);
}


#if	!defined(JS) && !defined(JSERVER)
/* Only use JUTIL */
void
Print_entry(yomi, kstr, cstr, hindo, ima, hinsi, serial, ofpter, esc_exp)
	w_char *yomi, *kstr,*cstr;
int serial, hindo, ima, hinsi;
FILE *ofpter;
int esc_exp;
{
	register int len;
	char *k;
	char buf[32];
	static w_char revy[LENGTHKANJI];
	extern void kanji_esc_str();

	if ((yomi == 0) || (kstr == 0))
		return;

	if(serial != -1){
		snprintf(buf, sizeof(buf), "%d\t", serial);
		vputs(buf, ofpter);
	}

	len = put_yomi_str(yomi, ofpter);
	if(len < 8)vputc('\t' , ofpter);
	if(len < 16)vputc('\t' , ofpter);
	vputc('\t' , ofpter);

	if(esc_exp){
		wnn_Sreverse(revy, yomi);
		kanji_esc_str(kstr, revy, wnn_Strlen(yomi));
		len = put_yomi_str(kstr, ofpter);
	} else{
		len = vputws(kstr, ofpter);
	}
	if(len < 8)vputc('\t' , ofpter);
	if(len < 16)vputc('\t' , ofpter);
	vputc('\t' , ofpter);

	k = wnn_get_hinsi_name(hinsi);
	if(k){
		vputs(k, ofpter);
		if((int)strlen(k) < 8)vputc('\t' , ofpter);
		vputc('\t' , ofpter);
	} else{
		snprintf(buf, sizeof(buf), "%d\t\t", hinsi);
		vputs(buf, ofpter);
	}

	if(ima) vputc('*', ofpter);
	if(hindo == -1){    /*  Real hindo == -1 means Not to use it */
		vputs("-", ofpter);
	} else{
		snprintf(buf, sizeof(buf), "%d", hindo);
		vputs(buf, ofpter);
	}
	if(cstr && cstr[0]){
		vputc('\t', ofpter);
		len = vputws(cstr, ofpter);
	}
	vputc('\n', ofpter);
}
#endif


#ifdef BDIC_WRITE_CHECK
#undef BDIC_WRITE_CHECK
#endif
