/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-wizard.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-wizard
 * @title: IAnjutaWizard
 * @short_description: Interface for wizards that can create new stuffs
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-wizard.h
 * 
 */

#include "ianjuta-wizard.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_wizard_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-wizard-quark");
	}
	
	return quark;
}

/**
* ianjuta_wizard_activate:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Called when the wizard should start after some user action
*/
void
ianjuta_wizard_activate (IAnjutaWizard *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_WIZARD(obj));
	IANJUTA_WIZARD_GET_IFACE (obj)->activate (obj, err);
}

/* Default implementation */
static void
ianjuta_wizard_activate_default (IAnjutaWizard *obj, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_wizard_base_init (IAnjutaWizardIface* klass)
{
	static gboolean initialized = FALSE;

	klass->activate = ianjuta_wizard_activate_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_wizard_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaWizardIface),
			(GBaseInitFunc) ianjuta_wizard_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaWizard", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
