/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009-2010 Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

#ifndef STATUSTABLEVIEW_H
#define STATUSTABLEVIEW_H

#include <QObject>

#include "cardinal.h"
#include "identitymanager.h"
#include "tweet.h"
#include "infownd.h"
#include "ProfilePictureManager.h"
#include "SqlArchive.h"

/* StatusTableView provides a table view widget for statuses made from Twitter/Identi.ca */

class StatusTableView : public QTableWidget
{
    Q_OBJECT
public:
    StatusTableView( QWidget *parent, QString Username, QString Password, bool search = false);
    ~StatusTableView();
    QMenu *viewMenu() { return menu_View; }
    bool online() { return m_isOnline; }
    QString statusBarText() { return m_statusBarText; }
    QString selectedUser() { return m_selectedUser; }
    QString accountName() { return m_user; }
    unsigned long long int replyId() { return m_replyId; }
    void reload();
    void search(QString search);
public slots:
    void showIgnoredUpdates(bool);
    void loadUserInfo();
    void signalReply();
    void submitTweet(QString, unsigned long long int);
    void submitDM(QString, unsigned long long int);
    void updateRemoved(unsigned long long int);
    void markFavorite(unsigned long long int, bool);
signals:
    void updateStatusBar(QString);
    void working(bool);
    void hideEditor();
    void addNotification(tweet_t);
    void reply(tweet_t);
    void directMsg(unsigned long long int);
    void setOnline();
    void selectedChanged();
protected:
    void resizeEvent(QResizeEvent *event);
protected slots:
    void addNewTweet(tweet_t, int);
    void tableItemActivated();
    void showInfoDialog(user_t user);
    void getUserInfo(unsigned long long int);
    void block(unsigned long long int, QString);
    void follow(unsigned long long int, QString);
    void unfollow(unsigned long long int, QString);
    void deleteUpdate(unsigned long long int);
    void retweetedByMe(unsigned long long int);
    void idsForRetweet(unsigned long long int, QList<user_t>);
    void resizeRow(QSize, int);
    void isOnline();
    void updateAPIData(apilimit_t);
    void changeView(QAction*);
    void retweetUpdate(unsigned long long int);
    void pictureRecieved(unsigned long long int, QByteArray);
    void pictureRecievedAlt(QString, QByteArray);
private:
    tweet_t categorizeTweet(tweet_t twInfo);
    void showSortView(QString);
    void setAllUnchecked();
    void createViewMenu();
    QStringList addCategoryByUser(QString);
    bool twContains(unsigned long long int);
    QString resetString(unsigned int);
    int findSlot(time_t);
    int findSlotByReply(unsigned long long int);
    int findSlotByOrignal(unsigned long long int);
    int indentCount(tweet_t twInfo);
    tweet_t updateForId(unsigned long long int id);

    int lastActiveItem;
    tweet_t twInfo;
    QList<tweet_t> m_tweets;
    QList<unsigned long long int> m_id;
    QList<time_t> m_sentTweets;
    IdentityManager *ident;
    ProfilePictureManager *m_profilePics;

    QString m_user;
    QString m_pass;

    QAction *action_GetInfoH;
    QAction *action_Reply;

    QString m_statusBarText;
    QString m_selectedUser;
    unsigned long long int m_replyId;

    QMenu *menu_View;
    QAction *showIgnored;
    int row;
    bool m_isOnline;
    bool m_search;
};

#endif // STATUSTABLEVIEW_H
