/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009-2010 Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

#ifndef GUIMAIN_H
#define GUIMAIN_H

#include "cardinal.h"
#include "NotificationAgent.h"
#include "twedit.h"
#include "StatusTableView.h"
#include "TabWidget.h"

class Cardinal : public QMainWindow
{
    Q_OBJECT
public:
    Cardinal(QWidget *parent = 0, Qt::WFlags flags = 0);
    ~Cardinal();
protected slots:
    void tabChanged(int);
    void selectedChanged();
    void replyRequested();
    void showNewTweet();    
    void trayActivated(QSystemTrayIcon::ActivationReason);
    void settingsChanged();
    void showPrefs();
    void quitApp();
    void about();
    void help();
    void bugs();
    void website();    
    void setOnline();
    void updateStatusBar(QString);
    void setOffline();
    void working(bool);
    void showNotification();
    void reply(QString account, tweet_t twInfo);
    void directMsg(QString account, unsigned long long int tid);
    void changeEvent(QEvent *);
    void hideEditor();
    void search();
    void addAccount(QString);
    void removeAccount(QString);
private:
    void switchViewMenu();
    void setupActions();
    int checkForIdentity();
    bool tweetMe;
    int row;
    QAction *action_Quit;
    QAction *action_About;
    QAction *action_Preferences;
    QWidget *centralWidget;
    QAction *action_NewTweet;
    QAction *action_Reload;
    QAction *action_Reply;
    QAction *action_GetInfo;
    QAction *actionHelp;
    QAction *actionBugs;
    QAction *actionWebsite;
    QAction *actionRT;
    QAction *showWindow;
    QMenuBar *menuBar;
    QMenu *menu_File;
    QMenu *menu_Help;
    QMenu *sysTray;
    QToolBar *mainToolBar;
    QStatusBar *statusBar;
    QLabel *sbInfoLabel;
    QLabel *sbWorkingLabel;
    QLabel *iconLabel;
    QMovie *movie;
    QSystemTrayIcon *ticon;
    QLineEdit *m_search;
    TabWidget *accounts;
    Editor *editor;
    bool hideInTray;
    NotificationAgent *m_notify;
    #ifdef _WIN32
    SuperTweet *st;
    #endif
};

#endif
