/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009-2010 Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/


#ifndef TWEET_H
#define TWEET_H

#include "cardinal.h"
#include "UserView.h"

class tweet : public QWidget
{
    Q_OBJECT
public:
    tweet(QWidget *, tweet_t, QString);
    ~tweet();
    void setAltColor();
    void prefixDirect();
    void prefixMention();
    void prefixThread();
    void prefixFavorite(bool);
    void itemActivated();
    void itemDeactivated();
    tweet_t returnTweet();
    tweet_t tw;
    void ignore();
    void unignore();
    void setRetweetedByMe(bool);
    void setRetweeters(QList<user_t>);
    void setProfileImage(QByteArray);
    void indent();
    void setUserName(QString username) { m_userName = username; }
    void setFavorite(bool favorite) { m_favorite = favorite; }
    bool favorite() { return m_favorite; }
signals:
    void requestReply(tweet_t);
    void requestUserInfo(unsigned long long int);
    void activated(tweet_t);
    void closing(tweet *);
    void resizeRow(QSize, int);
    void retweetUpdate(unsigned long long int);
    void deleteUpdate(unsigned long long int);
    void markFavorite(unsigned long long int, bool);
    void requestDM(unsigned long long int);
protected slots:
    void replyTriggered();
    void getInfoTriggered();
    void timeout();
    void linkActivated(QString);
    void retweet();
    void showRetweeters();
    void uViewClosed();
    void deleteUpdateSlot();
    void markAsFavorite();
    void sendDM();
protected:
    void contextMenuEvent(QContextMenuEvent *);
    void changeEvent(QEvent *);
    void mouseDoubleClickEvent(QMouseEvent *);
private:
    QString active;
    QString inactive;
    QColor activeColor;
    QColor inactiveColor;
    int itype;
    QMenu *menu;
    QAction *reply;
    QAction *getInfo;
    QAction *block;

    QAction *retweeters;
    QGridLayout *gridLayout;
    QLabel *userPic;
    QLabel *tweetTxt;
    QFrame *line;
    QLabel *byUser;
    QSpacerItem *indentSpacer;
    QSpacerItem *verticalSpacer;
    UserView *uView;
    QAction *action_Delete;
    QAction *action_Retweet;
    QAction *action_MarkAsFavorite;
    QAction *action_SendDM;

    QMenu *rightClick;
    QPixmap img;
    QTimer *hideTimer;
    bool m_ignored;
    bool m_retweeted;
    QList<user_t> m_retweeters;
    int m_retweetCount;
    int m_indentCount;
    QString m_userName;
    bool m_favorite;
};

#endif
