#ifndef Core_H
#define Core_H

#ifdef WIN32
	#define EXPORT __declspec(dllexport)
#else
	#define EXPORT
#endif

#include <QtCore/QObject>
#include <QtCore/QBuffer>
#include <QtCore/QEventLoop>
#include <QtCore/QMap>
#include <qnetworkaccessmanager.h>
#include <qnetworkrequest.h>
#include <qnetworkreply.h>
#include "oauth.h"

#include "Server.h"
#include "Returnables.h"

class Core : public QObject
{
	Q_OBJECT;
          
	public:
		Core();
		virtual ~Core();
        
    public:
        void setToken(token_t token);
        void GetPublicTimeline();
        void GetSingleStatus(QString id);
        void GetFeaturedUsers();
        void Login(QString user, QString passw);
        void Logout();
        void SetLoginInfo(QString user, QString passw);
        void SetProxy(SERVER::PROXY_TYPE type = SERVER::NO_PROXY, const QString hostName = QString(), \
                    quint16 port = 0, const QString user = QString(), const QString password = QString());
        void IsTwitterUp();
        void GetUsersTimeline(unsigned long long int id);
        void GetFavorites(QString user="", unsigned int page=1);
        void GetFriendsTimeline(SERVER::Option1 *opt=NULL);
        void PostNewStatus(QString status, QString in_reply_to_status_id = "", QString source = "");
        void GetRecentMentions(SERVER::Option3 *opt=NULL);
        void RemoveStatus(QString id);
        void GetFriends(unsigned long long int id);
        void GetFollowers(unsigned long long int id);
        void GetUserDetails(unsigned long long int id);
        void GetSentDirectMessages(SERVER::Option5 *opt=NULL);
        void GetReceivedDirectMessages(SERVER::Option5 *opt=NULL);
        void SendDirectMessage(unsigned long long int id, QString text);
        void RemoveDirectMessage(QString id);
        void AddFriendship(QString user, bool follow=true);
        void RemoveFriendship(QString user);
        void FriendshipExist(QString user_a, QString user_b);
        void VerifyCredentials();
        void UpdateDeliveryDevice(SERVER::DEVICES device);
        void RemainingApiRequests();
        void AddFavorite(QString id);
        void RemoveFavorite(QString id);
        void UpdateProfileColors(QString background_color = "", QString text_color = "", QString link_color = "", QString sidebar_fill_color = "", QString sidebar_border_color = "");
        void UpdateProfileImage(QString image);
        void UpdateProfileBackgroundImage(QString image, QString isTile);
        void UpdateProfile(QString name = "", QString email = "", QString url = "", \
                            QString location = "", QString description = "");
        void EnableNotifications(QString id);
        void DisableNotifications(QString id);
        void BlockUser(QString id);
        void UnBlockUser(QString id);
        void GetFriendsIDs(QString id = "", QString user_id = "", QString screen_name = "");
        void GetFollowersIDs(QString id = "", QString user_id = "", QString screen_name = "");
        void SearchByString(QString);
        void Retweet(QString id);
        void RetrieveRetweets(QString id);
	public slots:
        void ReqFinished(QNetworkReply *reply);
        void DataReadProgress(int done, int total);
        void Done(bool error);
        void Abort();
        
    signals:
        EXPORT void QueryDone();
        EXPORT void OnErrorString(QString error);
        //EXPORT void OnError(QHttp::Error error);
        EXPORT void OnMessageReceived(QString message);
        EXPORT void OnStatusReceived(SERVER::RESP resp);
        EXPORT void OnResponseReceived(Returnables::Response *resp);
        EXPORT void badLogin();

	private:
		struct Info
		{
			QNetworkRequest request;
			Returnables::RequestId requestid;
		};

    private:
        void MakeConnections();
		//void responseHeaderReceived(const QHttpResponseHeader &resp);
        int MakeGetRequest(QString req, ParameterMap params = ParameterMap(), bool useOAuth = true);
        int MakePostRequest(QString path, QByteArray req, bool isMultipart = false, bool useOAuth = true);
               
	private:
        QMap<int,Info> m_buffer;
        QEventLoop *m_eventLoop;
		QNetworkAccessManager *m_http;
		CommieLib *m_oauth;
        token_t m_token;
	private:
        static QString USER_AGENT;
        static QString TWITTER_HOST;
        static QString VERIFY_CREDENTIALS_URL;
        static QString PUBLIC_TIMELINE_URL;
        static QString GET_SINGLE_STATUS_URL;
        static QString FEATURED_USERS_URL;
        static QString LOGOUT_URL;
        static QString IS_TWITTER_UP_URL;
        static QString USERS_TIMELINE_URL;
        static QString GET_FAVORITES_URL;
        static QString FRIENDS_TIMELINE_URL;
        static QString POST_NEW_STATUS_URL;
        static QString GET_MENTIONS_URL;
        static QString REMOVE_STATUS_URL;
        static QString GET_FRIENDS_URL;
        static QString GET_FOLLOWERS_URL;
        static QString GET_USER_DETAILS_URL;
        static QString GET_SENT_DIRECT_MESSAGES_URL;
        static QString GET_RECEIVED_DIRECT_MESSAGES_URL;
        static QString SEND_NEW_DIRECT_MESSAGE_URL;
        static QString REMOVE_DIRECT_MESSAGE_URL;
        static QString CREATE_FRIENDSHIP_URL;
        static QString REMOVE_FRIENDSHIP_URL;
        static QString FRIENDSHIP_EXIST_URL;
        static QString UPDATE_DELIVERY_DEVICE_URL;
        static QString REMAINING_API_REQUESTS_URL;
        static QString ADD_FAVORITE_URL;
        static QString REMOVE_FAVORITE_URL;
        static QString PROFILE_COLORS_URL;
        static QString PROFILE_IMAGE_URL;
        static QString PROFILE_BACKGROUND_IMAGE_URL;
        static QString PROFILE_URL;
        static QString ENABLE_NOTIFICATIONS_URL;
        static QString DISABLE_NOTIFICATIONS_URL;
        static QString BLOCK_USER_URL;
        static QString UNBLOCK_USER_URL;
        static QString FRIENDS_IDS_URL;
        static QString FOLLOWERS_IDS_URL;
        static QString SEARCH_URL;
        static QString RETWEET_URL;
        static QString RETRIEVE_RETWEETS_URL;
        static QByteArray key;
        static QByteArray sec;
};

#endif // Core_H



