/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009  Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

#include "NotificationAgent.h"

#ifdef USE_SNARL
NotificationAgent::NotificationAgent(QSystemTrayIcon *ico, HWND handle)
{
	snarl = new SnarlInterface();
	QString icon = qApp->applicationDirPath() + tr("\\cardinal.png");
	icon.replace("/", "\\");
	QByteArray dat = icon.toLatin1();
	char *icon_path = dat.data(); 
	snarl->RegisterConfig2(handle, LPCSTR("Cardinal"), 0, icon_path);
	this->hwnd = handle;
	this->icon = ico;
}

NotificationAgent::~NotificationAgent()
{
	snarl->RevokeConfig(hwnd);
}

#else
NotificationAgent::NotificationAgent(QSystemTrayIcon *ico)
{
	icon = ico;
}

NotificationAgent::~NotificationAgent()
{

}
#endif

void NotificationAgent::addNotification(tweet_t tw)
{
	m_notifyList.append(tw);
}

void NotificationAgent::show()
{
	if(m_notifyList.isEmpty() == true)
		return;

	QDesktopWidget wid;
	QRect *rect = new QRect(wid.screenGeometry());

	delete rect;

	if(m_notifyList.count() > 3) {
#ifdef USE_SNARL
		QString d = QString::number(m_notifyList.count()) + QString(" new tweets. Click to view.");
		string title = "Cardinal";
		string data = d.toLatin1().data();
		LPCSTR titleM = title.c_str();
		LPCSTR dataM = data.c_str();
		QString icon = qApp->applicationDirPath() + tr("\\cardinal.png");
		icon.replace("/", "\\");
		QByteArray dat = icon.toLatin1();
		char *icon_path = dat.data();
		snarl->ShowMessage(titleM, dataM, 0, icon_path);
#else
		icon->showMessage("Cardinal", QString::number(m_notifyList.count()) + QString(" new tweets. Click to view."));
#endif
	} else {
		int count = m_notifyList.count();
		for(int i = 1; i <= count; i++) {
			if(m_notifyList.count() != 0) {
#ifdef USE_SNARL
				string title = m_notifyList.at(i-1).screenName.toLatin1().data();
				string data = m_notifyList.at(i-1).tweet.toLatin1().data();
				LPCSTR titleM = title.c_str();
				LPCSTR dataM = data.c_str();
				QString icon = qApp->applicationDirPath() + tr("\\cardinal.png");
				icon.replace("/", "\\");
				QByteArray dat = icon.toLatin1();
				char *icon_path = dat.data();
				snarl->ShowMessage(titleM, dataM, 0, icon_path);
#else
				icon->showMessage( m_notifyList.at(i-1).screenName,  m_notifyList.at(i-1).tweet);
#endif
			}
		}
	}
	m_notifyList.clear();
}

void NotificationAgent::closing(tweet *t)
{
	delete t;
}

