/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009-2010  Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

/* fuck oauth */

#include "TwitterRegistration.h"

QByteArray key = "BfDYI8oSawBIM17C1DtU6Q";
QByteArray sec = "RAYr0BZ2zjGX1KIiV7qONBwxMyywYFRYJYHb3ZFYA";
QString twitter_request_token = "https://api.twitter.com/oauth/request_token";
QString twitter_access_token = "https://api.twitter.com/oauth/access_token";
QString twitter_authorize = "https://api.twitter.com/oauth/authorize";

TwitterRegistrationWizard::TwitterRegistrationWizard(QWidget *parent = 0)
    :QWizard(parent)
{
    if (objectName().isEmpty())
        setObjectName(QString::fromUtf8("Wizard"));
    resize(595, 377);
    welcome = new QWizardPage();
    welcome->setObjectName(QString::fromUtf8("WelcomePage"));
    gridLayout = new QGridLayout(welcome);
    gridLayout->setObjectName(QString::fromUtf8("gridLayout"));
    label = new QLabel(welcome);
    label->setObjectName(QString::fromUtf8("label"));
    label->setWordWrap(true);
    gridLayout->addWidget(label, 0, 0, 1, 1);
    verticalSpacer = new QSpacerItem(20, 60, QSizePolicy::Minimum, QSizePolicy::Expanding);
    gridLayout->addItem(verticalSpacer, 1, 0, 1, 1);
    setPage(0, welcome);
    auth = new OAuthAuthenticationPage(this);
    auth->setObjectName(QString::fromUtf8("AuthPage"));
    setPage(1, auth);
    finished = new FinishPage(this);
    finished->setObjectName(QString::fromUtf8("FinishedPage"));
    setPage(2, finished);

    setWindowTitle(tr("Register Twitter Account"));
    welcome->setTitle(tr("Register a Twitter Account"));
    welcome->setSubTitle(tr("This wizard will help you register a Twitter account with Cardinal.  Cardinal uses OAuth for Authentication. By using OAuth, your default web browser will open up and ask you to authorize Cardinal for read and write access to your account.\n\n"
        "You will recieve a PIN code after authorization.  You will need to enter this along with your Twitter username to complete this process.\n\n"
        "Click Next to begin."));
    connect(this, SIGNAL(currentIdChanged(int)), this, SLOT(currentChanged(int)));
    QMetaObject::connectSlotsByName(this);
}

TwitterRegistrationWizard::~TwitterRegistrationWizard()
{

}

void TwitterRegistrationWizard::setError()
{
    finished->setError();
}

QString TwitterRegistrationWizard::account()
{
    QString userName = field("UserName").toString();
    if(userName.isNull())
    {
        userName = QString("");
    }

    return userName;
}

/* Our OAuth Wizard Page */

OAuthAuthenticationPage::OAuthAuthenticationPage(QWidget *parent)
    :QWizardPage(parent)
{
    oAuth = new CommieLib(key, sec, this);
    connect(oAuth, SIGNAL(hasRequestToken(token_t)), this, SLOT(recievedRequestToken(token_t)));
    connect(oAuth, SIGNAL(hasAccessToken(token_t)), this, SLOT(recievedAccessToken(token_t)));
    connect(oAuth, SIGNAL(error(int)), this, SLOT(error(int)));

    gridLayout_2 = new QGridLayout(this);
    gridLayout_2->setObjectName(QString::fromUtf8("gridLayout_2"));
    label_5 = new QLabel(this);
    label_5->setObjectName(QString::fromUtf8("label_5"));
    gridLayout_2->addWidget(label_5, 0, 0, 1, 1);
    m_userName = new QLineEdit(this);
    m_userName->setObjectName(QString::fromUtf8("m_userName"));
    gridLayout_2->addWidget(m_userName, 0, 1, 1, 1);

    label_6 = new QLabel(this);
    label_6->setObjectName(QString::fromUtf8("label_6"));
    gridLayout_2->addWidget(label_6, 1, 0, 1, 1);

    m_pin = new QLineEdit(this);
    m_pin->setObjectName(QString::fromUtf8("m_pin"));
    gridLayout_2->addWidget(m_pin, 1, 1, 1, 1);

    verticalSpacer_2 = new QSpacerItem(20, 96, QSizePolicy::Minimum, QSizePolicy::Expanding);
    gridLayout_2->addItem(verticalSpacer_2, 2, 1, 1, 1);

    registerField("UserName", m_userName);
    registerField("PinCode", m_pin);

    setTitle(tr("Twitter OAuth Authentication"));
    setSubTitle(tr("Enter in your Twitter username, and click Obtain PIN to obtain your OAuth Authorization PIN code."));
    label_5->setText(tr("Username:"));
    label_6->setText(tr("PIN:"));
}

void OAuthAuthenticationPage::initializePage()
{
    /* obtain our request token and PIN code */
    ParameterMap args;
    args.insert("oauth_callback", "oob");

    oAuth->obtainRequestToken(twitter_request_token, 0x0004, args);
}

bool OAuthAuthenticationPage::validatePage()
{
    /* make sure we don't have a duplicate account */
    QSettings settings("Cardinal", "Cardinal");
    settings.beginGroup("Accounts");
    QStringList accts = settings.childGroups();
    for (int i = 0; i < accts.count(); ++i)
    {
        if(field("UserName") == accts[i])
        {
            setSubTitle(tr("The account is already registered!!!"));
            return false;
        }
    }

    /* exchange for an access token */
    ParameterMap args;
    args.insert("oauth_verifier", field("PinCode").toByteArray());
    oAuth->obtainAccessToken(twitter_access_token, 0x0004, m_token, args);
    return true;
}

void OAuthAuthenticationPage::recievedRequestToken(token_t token)
{
    m_token = token;
    QUrl url(twitter_authorize);
    url.addQueryItem("oauth_token", token.token);

    QDesktopServices::openUrl(url);
}

void OAuthAuthenticationPage::recievedAccessToken(token_t token)
{
    if(token.token.isNull() || token.secret.isNull())
    {
        TwitterRegistrationWizard *wiz = qobject_cast<TwitterRegistrationWizard*>(wizard());
        wiz->setError();
    }
    else
    {
        QSettings settings("Cardinal", "Cardinal");
        settings.beginGroup("Accounts");
        settings.beginGroup(field("UserName").toString());
        settings.setValue("username", field("UserName").toString());
        settings.setValue("oauth_token", token.token);
        settings.setValue("oauth_token_secret", token.secret);
        settings.setValue("ptReload", 5);
        settings.endGroup();
        settings.endGroup();
    }
}

void OAuthAuthenticationPage::recievedError(int error)
{
    Q_UNUSED(error);
    QMessageBox msg(QMessageBox::Critical, tr("Duplicate Account"), tr("The account %1 is already registered.").arg(field("Account").toString()), QMessageBox::Ok, this);
    msg.exec();
}

/* our Finished Page */

FinishPage::FinishPage(QWidget *parent)
    :QWizardPage(parent)
{
    gridLayout_3 = new QGridLayout(this);
    gridLayout_3->setObjectName(QString::fromUtf8("gridLayout_3"));
    label_2 = new QLabel(this);
    label_2->setObjectName(QString::fromUtf8("label_2"));
    label_2->setScaledContents(true);
    label_2->setWordWrap(true);
    gridLayout_3->addWidget(label_2, 0, 0, 1, 1);
    verticalSpacer_3 = new QSpacerItem(20, 138, QSizePolicy::Minimum, QSizePolicy::Expanding);
    gridLayout_3->addItem(verticalSpacer_3, 1, 0, 1, 1);
    setTitle(tr("Finished"));
    setSubTitle(tr("Your Twitter account is ready for use with Cardinal."));
    label_2->setText(tr("You have authorized Cardinal for read and write access to your Twitter account.  No further action is required, and you may start using this account with Cardinal."));
}

void FinishPage::setError()
{
    setTitle(tr("An Error Occured"));
    setSubTitle(tr("We're sorry, an error occured."));
    label_2->setText(tr("An unrecoverable error has occured with the OAuth process, Cardinal was unable to obtain authorization for your account. Please try again later."));
}
