/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009  Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

#include "cardinal.h"
#include "guimain.h"
#include <QDateTime>

void msgHandler(QtMsgType type, const char * message)
{
    QString time = QDateTime::currentDateTime().toString(Qt::ISODate);
    switch(type)
    {
    case QtDebugMsg:
        printf("[%s] cardinal WARN - %s\n", qPrintable(time), message);
    case QtWarningMsg:
        printf("[%s] cardinal WARN - %s\n", qPrintable(time), message);
    default:
        printf("[%s] cardinal INFO - %s\n", qPrintable(time), message);
    }
}

int main(int argc, char *argv[])
{
    printf("Cardinal (C) 2009-2010 Chris Fuenty <zimmy@zimmy.co.uk>\n");
    printf("Starting up........\n");
    qInstallMsgHandler(msgHandler);
    QApplication a(argc, argv);
    a.setApplicationName("Cardinal");
    a.setApplicationVersion(QString(VERSION));
    Cardinal w;
    w.show();

    return a.exec();
}
