/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009  Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

#include "twedit.h"

Editor::Editor(QWidget *parent = 0)
    :QDialog(parent)
{
    if (objectName().isEmpty())
        setObjectName(QString::fromUtf8("newTweet"));
    setWindowModality(Qt::WindowModal);
    resize(453, 170);
    gridLayout = new QGridLayout(this);
    gridLayout->setObjectName(QString::fromUtf8("gridLayout"));
    m_action = new QLabel(this);
    m_action->setObjectName(QString::fromUtf8("m_action"));
    QFont font;
    font.setBold(true);
    font.setWeight(75);
    m_action->setFont(font);

    isDirectMsg = false;
    gridLayout->addWidget(m_action, 0, 0, 1, 2);

    horizontalSpacer = new QSpacerItem(158, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);

    gridLayout->addItem(horizontalSpacer, 0, 2, 1, 1);

    m_send = new QPushButton(this);
    m_send->setObjectName(QString::fromUtf8("m_send"));
    QSizePolicy sizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
    sizePolicy.setHorizontalStretch(0);
    sizePolicy.setVerticalStretch(0);
    sizePolicy.setHeightForWidth(m_send->sizePolicy().hasHeightForWidth());
    m_send->setSizePolicy(sizePolicy);
    m_send->setDefault(true);

    gridLayout->addWidget(m_send, 0, 3, 1, 1);

    tweetEditor = new QPlainTextEdit(this);
    tweetEditor->setObjectName(QString::fromUtf8("tweetEditor"));

    gridLayout->addWidget(tweetEditor, 1, 0, 1, 4);

    label = new QLabel(this);
    label->setObjectName(QString::fromUtf8("label"));

    gridLayout->addWidget(label, 2, 0, 1, 1);

    comboBox = new QComboBox(this);
    comboBox->setObjectName(QString::fromUtf8("comboBox"));
    QSizePolicy sizePolicy1(QSizePolicy::MinimumExpanding, QSizePolicy::Fixed);
    sizePolicy1.setHorizontalStretch(0);
    sizePolicy1.setVerticalStretch(0);
    sizePolicy1.setHeightForWidth(comboBox->sizePolicy().hasHeightForWidth());
    comboBox->setSizePolicy(sizePolicy1);

    QSettings settings("Cardinal", "Cardinal");
    gridLayout->addWidget(comboBox, 2, 1, 1, 2);

    QWidget::setTabOrder(tweetEditor, m_send);
    QWidget::setTabOrder(m_send, comboBox);

    setWindowTitle(tr("Post Status"));
    m_action->setText(tr("Post Status - %1 Characters Left").arg(QString("140")));
    m_send->setText(tr("Post"));
    m_send->setShortcut(tr("Ctrl+Return"));
    label->setText(tr("Post From Account:"));
    connect(tweetEditor, SIGNAL(textChanged()), this, SLOT(editorKeyPressed()));
    connect(m_send, SIGNAL(clicked()), this, SLOT(wantToSubmit()));

    buildAccountList();
}
void Editor::setDirectMsgInformation(QString account, unsigned long long int target)
{
    setWindowTitle(tr("Send Direct Message"));
    m_send->setText(tr("Send"));
    m_action->setText(tr("Send Direct Message - %1 Characters Left").arg(QString("140")));
    isDirectMsg = true;
    did = target;
    comboBox->setCurrentIndex(comboBox->findText(account));
    comboBox->setDisabled(true);
}

void Editor::setReplyInformation(QString account, QString text, unsigned long long int rid)
{
    setWindowTitle(tr("Post Status"));
    m_send->setText(tr("Post"));
    isDirectMsg = false;
    tweetEditor->setPlainText(text);
    id = rid;
    comboBox->setCurrentIndex(comboBox->findText(account));
    comboBox->setDisabled(true);
}

void Editor::editorKeyPressed()
{
    int length = tweetEditor->document()->toPlainText().length();
    length = 140 - length;
    if(isDirectMsg == false)
        m_action->setText(tr("Post Status - %1 Characters Left").arg(QString::number(length)));
    else
        m_action->setText(tr("Send Direct Message - %1 Characters Left").arg(QString::number(length)));

    if(length < 0 && m_send->isEnabled() == true)
    {
        m_send->setEnabled(false);
    }

    if(length >= 0 && m_send->isEnabled() == false)
    {
        m_send->setEnabled(true);
    }
}

void Editor::wantToSubmit()
{
    QString account = QString("ALL");
    if(comboBox->currentText() != tr("All Accounts"))
        account = comboBox->currentText();

    if(isDirectMsg == true && did != 0)
    {
        emit submitDirectMsg(account, tweetEditor->document()->toPlainText(), did);
        did = 0;
        return;
    }
    if(id != 0)
    {
        emit submitTweet(account, tweetEditor->document()->toPlainText(), id);
        id = 0;
    }
    else
    {
        emit submitTweet(account, tweetEditor->document()->toPlainText());
        id = 0;
    }
}

void Editor::clear()
{
    setWindowTitle(tr("Post Status"));
    m_send->setText(tr("Post"));
    isDirectMsg = false;
    tweetEditor->setPlainText(tr(""));
    id = 0;
    comboBox->setEnabled(true);
    comboBox->setCurrentIndex(0);
}

void Editor::buildAccountList()
{
    comboBox->addItem("All Accounts");
    QSettings settings("Cardinal", "Cardinal");
    settings.beginGroup("Accounts");
    QStringList accts = settings.childGroups();
    /* handle no accounts here */
    for (int i = 0; i < accts.count(); ++i)
    {
        settings.beginGroup(accts[i]);
        QString user = settings.value("username").toString();
        comboBox->addItem(QIcon(QString::fromUtf8(":/Icons/Networks/twitter")), user);
        settings.endGroup();
    }
    settings.endGroup();
}
