/**
 *
 * Compiz tile plugin
 *
 * tile.c
 *
 * Copyright (c) 2006 Atie H. <atie.at.matrix@gmail.com>
 * Copyright (c) 2006 Michal Fojtik <pichalsi(at)gmail.com>
 * Copyright (c) 2007 Danny Baumann <maniac@beryl-project.org>
 *
 * Rewritten by:
 * Copyright (c) 2008 Sam Spilsbury <smspillaz@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * TODO
 *	- change vertical and horizontal tiling to similar behavior as Left
 *	- fix bugs
 *	- make vertical and horizontal maximization be saved when tiling
 *
 **/

#include <core/core.h>
#include <core/pluginclasshandler.h>

#include <composite/composite.h>
#include <opengl/opengl.h>

#include "tile_options.h"

#include <cmath>

class Tiler;

class TileScreen :
    public PluginClassHandler <TileScreen, CompScreen>,
    public TileOptions,
    public ScreenInterface,
    public CompositeScreenInterface,
    public GLScreenInterface
{
    public:

	typedef enum
	{
	    Normal = 0,
	    In,
	    Tiled,
	    Out
	} State;

	typedef enum
	{
	    Restore = 0,
	    Square,
	    Even,
	    Horizontal,
	    Vertical,
	    Expand,
	    Organic,
	    Cascade
	} TileType;

    public:

	TileScreen (CompScreen *screen);

	CompositeScreen *cScreen;
	GLScreen *gScreen;

	State state;
	int time;

	/* Tiling queue */

	std::list <Tiler *> tilers;
	CompRect nextPosition;
	TileType type;

	void
	preparePaint (int);

	/* finsih */

	bool
	glPaintOutput (const GLScreenPaintAttrib &attrib,
		       const GLMatrix	         &transform,
		       CompRegion                &region,
		       CompOutput                *output,
		       unsigned int              mask);
#if 0
	bool
	glPaintScreen (CompOutput   *outputs,
		       int          numOutputs,
		       unsigned int mask); //for ensuring fullscreen output;
#endif
	void
	donePaint ();

	/* Tiling modes */

	void
	restoreTile ();

	void
	squareTile (CompWindowExtents &border,
		    const CompRect    &workArea,
		    int        count);

	void
	horizontalTile (CompWindowExtents &border,
			const CompRect    &workArea,
			int               count);

	void
	verticalTile (CompWindowExtents &border,
		      const CompRect    &workArea,
		      int               count);

	void
	evenTile (CompWindowExtents &border,
		  const CompRect    &workArea,
		  int               count);

	void
	expandTile (CompWindowExtents &border,
		    const CompRect    &workArea,
		    int               count);

	void
	organicTile (CompWindowExtents &border,
		    const CompRect    &workArea,
		     int              count);

	void
	cascadeTile (CompWindowExtents &border,
		    const CompRect    &workArea,
		     int              count);

	/* Actions */

	bool
	chooseTileModeAndTile ();

	bool
	applyTiling (CompAction           *action,
		     CompAction::State    state,
		     CompOption::Vector   options,
		     TileType 		  type);
};

#define TILE_SCREEN(s)							       \
    TileScreen *ts = TileScreen::get (s);

class Tiler
{
    public:

	Tiler ();

    public:

	typedef enum
	{
	    NotTiled = 0,
	    WaitingForTile,
	    WaitingForRestore,
	    Tiled
	} State;

    public:

	State state;

	bool maximized;
	bool maxClean;
	int  savedMaxState;

	CompRect saved;
	CompRect previous;
	CompRect current;

	bool
	configure (CompWindow *,
		   TileScreen::TileType);

	void
	save (CompWindow *);
};

class TileWindow :
    public PluginClassHandler <TileWindow, CompWindow>,
    public WindowInterface,
    public GLWindowInterface
{
    public:

	TileWindow (CompWindow *window);
	~TileWindow ();

	CompWindow *window;
	GLWindow *gWindow;

	bool animate;

	int outlineColor[3];
	int time;

	bool alreadyResized;
	bool needConfigure;
	bool skipReTile;

	Tiler *tiler;

	void
	resizeNotify (int, int, int, int);

	bool
	glPaint (const GLWindowPaintAttrib &attrib,
		 const GLMatrix            &transform,
		 CompRegion                &region,
		 unsigned int              mask);

	void
	constrainMinMax (int        width,
		 	 int        height,
		 	 int        &newWidth,
		 	 int        &newHeight);

	bool
	placeWin (int          x,
		  int          y,
		  unsigned int width,
		  unsigned int height);

	bool is ();
};

#define TILE_WINDOW(w)							       \
    TileWindow *tw = TileWindow::get (w);

class TilePluginVTable :
    public CompPlugin::VTableForScreenAndWindow <TileScreen, TileWindow>
{
    public:

	bool init ();
};
