/* packagekit.vapi generated by lt-vapigen, do not modify. */

[CCode (cprefix = "Pk", lower_case_cprefix = "pk_")]
namespace Pk {
	[CCode (cprefix = "PK_CATALOG_PROGRESS_", has_type_id = "0", cheader_filename = "packagekit.h")]
	public enum CatalogProgress {
		PACKAGES,
		FILES,
		PROVIDES,
		LAST
	}
	[CCode (cprefix = "PK_CLIENT_ERROR_", cheader_filename = "packagekit.h")]
	public enum ClientError {
		FAILED,
		FAILED_AUTH,
		NO_TID,
		ALREADY_TID,
		ROLE_UNKNOWN,
		CANNOT_START_DAEMON,
		INVALID_PACKAGEID
	}
	[CCode (cprefix = "PK_CONTROL_ERROR_", has_type_id = "0", cheader_filename = "packagekit.h")]
	public enum ControlError {
		FAILED,
		CANNOT_START_DAEMON
	}
	[CCode (cprefix = "PK_DISTRO_UPGRADE_ENUM_", has_type_id = "0", cheader_filename = "packagekit.h")]
	public enum DistroUpgradeEnum {
		STABLE,
		UNSTABLE,
		UNKNOWN
	}
	[CCode (cprefix = "PK_ERROR_ENUM_", has_type_id = "0", cheader_filename = "packagekit.h")]
	public enum ErrorCodeEnum {
		OOM,
		NO_NETWORK,
		NOT_SUPPORTED,
		INTERNAL_ERROR,
		GPG_FAILURE,
		PACKAGE_ID_INVALID,
		PACKAGE_NOT_INSTALLED,
		PACKAGE_NOT_FOUND,
		PACKAGE_ALREADY_INSTALLED,
		PACKAGE_DOWNLOAD_FAILED,
		GROUP_NOT_FOUND,
		GROUP_LIST_INVALID,
		DEP_RESOLUTION_FAILED,
		FILTER_INVALID,
		CREATE_THREAD_FAILED,
		TRANSACTION_ERROR,
		TRANSACTION_CANCELLED,
		NO_CACHE,
		REPO_NOT_FOUND,
		CANNOT_REMOVE_SYSTEM_PACKAGE,
		PROCESS_KILL,
		FAILED_INITIALIZATION,
		FAILED_FINALISE,
		FAILED_CONFIG_PARSING,
		CANNOT_CANCEL,
		CANNOT_GET_LOCK,
		NO_PACKAGES_TO_UPDATE,
		CANNOT_WRITE_REPO_CONFIG,
		LOCAL_INSTALL_FAILED,
		BAD_GPG_SIGNATURE,
		MISSING_GPG_SIGNATURE,
		CANNOT_INSTALL_SOURCE_PACKAGE,
		REPO_CONFIGURATION_ERROR,
		NO_LICENSE_AGREEMENT,
		FILE_CONFLICTS,
		PACKAGE_CONFLICTS,
		REPO_NOT_AVAILABLE,
		INVALID_PACKAGE_FILE,
		PACKAGE_INSTALL_BLOCKED,
		PACKAGE_CORRUPT,
		ALL_PACKAGES_ALREADY_INSTALLED,
		FILE_NOT_FOUND,
		NO_MORE_MIRRORS_TO_TRY,
		UNKNOWN
	}
	[CCode (cprefix = "PK_EXIT_ENUM_", has_type_id = "0", cheader_filename = "packagekit.h")]
	public enum ExitEnum {
		SUCCESS,
		FAILED,
		CANCELLED,
		KEY_REQUIRED,
		EULA_REQUIRED,
		KILLED,
		UNKNOWN
	}
	[CCode (cprefix = "PK_EXTRA_ACCESS_", has_type_id = "0", cheader_filename = "packagekit.h")]
	public enum ExtraAccess {
		READ_ONLY,
		WRITE_ONLY,
		READ_WRITE
	}
	[CCode (cprefix = "PK_FILTER_ENUM_", has_type_id = "0", cheader_filename = "packagekit.h")]
	public enum FilterEnum {
		NONE,
		INSTALLED,
		NOT_INSTALLED,
		DEVELOPMENT,
		NOT_DEVELOPMENT,
		GUI,
		NOT_GUI,
		FREE,
		NOT_FREE,
		VISIBLE,
		NOT_VISIBLE,
		SUPPORTED,
		NOT_SUPPORTED,
		BASENAME,
		NOT_BASENAME,
		NEWEST,
		NOT_NEWEST,
		ARCH,
		NOT_ARCH,
		SOURCE,
		NOT_SOURCE,
		COLLECTIONS,
		NOT_COLLECTIONS,
		UNKNOWN
	}
	[CCode (cprefix = "PK_GROUP_ENUM_", has_type_id = "0", cheader_filename = "packagekit.h")]
	public enum GroupEnum {
		ACCESSIBILITY,
		ACCESSORIES,
		ADMIN_TOOLS,
		COMMUNICATION,
		DESKTOP_GNOME,
		DESKTOP_KDE,
		DESKTOP_OTHER,
		DESKTOP_XFCE,
		EDUCATION,
		FONTS,
		GAMES,
		GRAPHICS,
		INTERNET,
		LEGACY,
		LOCALIZATION,
		MAPS,
		MULTIMEDIA,
		NETWORK,
		OFFICE,
		OTHER,
		POWER_MANAGEMENT,
		PROGRAMMING,
		PUBLISHING,
		REPOS,
		SECURITY,
		SERVERS,
		SYSTEM,
		VIRTUALIZATION,
		SCIENCE,
		DOCUMENTATION,
		ELECTRONICS,
		COLLECTIONS,
		VENDOR,
		UNKNOWN
	}
	[CCode (cprefix = "PK_INFO_ENUM_", has_type_id = "0", cheader_filename = "packagekit.h")]
	public enum InfoEnum {
		INSTALLED,
		AVAILABLE,
		LOW,
		ENHANCEMENT,
		NORMAL,
		BUGFIX,
		IMPORTANT,
		SECURITY,
		BLOCKED,
		DOWNLOADING,
		UPDATING,
		INSTALLING,
		REMOVING,
		CLEANUP,
		OBSOLETING,
		COLLECTION_INSTALLED,
		COLLECTION_AVAILABLE,
		UNKNOWN
	}
	[CCode (cprefix = "PK_LICENSE_ENUM_", has_type_id = "0", cheader_filename = "packagekit.h")]
	public enum LicenseEnum {
		GLIDE,
		AFL,
		AMPAS_BSD,
		AMAZON_DSL,
		ADOBE,
		AGPLV1,
		AGPLV3,
		ASL_1_DOT_0,
		ASL_1_DOT_1,
		ASL_2_DOT_0,
		APSL_2_DOT_0,
		ARTISTIC_CLARIFIED,
		ARTISTIC_2_DOT_0,
		ARL,
		BITTORRENT,
		BOOST,
		BSD_WITH_ADVERTISING,
		BSD,
		CECILL,
		CDDL,
		CPL,
		CONDOR,
		COPYRIGHT_ONLY,
		CRYPTIX,
		CRYSTAL_STACKER,
		DOC,
		WTFPL,
		EPL,
		ECOS,
		EFL_2_DOT_0,
		EU_DATAGRID,
		LGPLV2_WITH_EXCEPTIONS,
		FTL,
		GIFTWARE,
		GPLV2,
		GPLV2_WITH_EXCEPTIONS,
		GPLV2_PLUS_WITH_EXCEPTIONS,
		GPLV3,
		GPLV3_WITH_EXCEPTIONS,
		GPLV3_PLUS_WITH_EXCEPTIONS,
		LGPLV2,
		LGPLV3,
		GNUPLOT,
		IBM,
		IMATIX,
		IMAGEMAGICK,
		IMLIB2,
		IJG,
		INTEL_ACPI,
		INTERBASE,
		ISC,
		JABBER,
		JASPER,
		LPPL,
		LIBTIFF,
		LPL,
		MECAB_IPADIC,
		MIT,
		MIT_WITH_ADVERTISING,
		MPLV1_DOT_0,
		MPLV1_DOT_1,
		NCSA,
		NGPL,
		NOSL,
		NETCDF,
		NETSCAPE,
		NOKIA,
		OPENLDAP,
		OPENPBS,
		OSL_1_DOT_0,
		OSL_1_DOT_1,
		OSL_2_DOT_0,
		OSL_3_DOT_0,
		OPENSSL,
		OREILLY,
		PHORUM,
		PHP,
		PUBLIC_DOMAIN,
		PYTHON,
		QPL,
		RPSL,
		RUBY,
		SENDMAIL,
		SLEEPYCAT,
		SLIB,
		SISSL,
		SPL,
		TCL,
		UCD,
		VIM,
		VNLSL,
		VSL,
		W3C,
		WXWIDGETS,
		XINETD,
		ZEND,
		ZPLV1_DOT_0,
		ZPLV2_DOT_0,
		ZPLV2_DOT_1,
		ZLIB,
		ZLIB_WITH_ACK,
		CDL,
		FBSDDL,
		GFDL,
		IEEE,
		OFSFDL,
		OPEN_PUBLICATION,
		CC_BY,
		CC_BY_SA,
		CC_BY_ND,
		DSL,
		FREE_ART,
		OFL,
		UTOPIA,
		ARPHIC,
		BAEKMUK,
		BITSTREAM_VERA,
		LUCIDA,
		MPLUS,
		STIX,
		XANO,
		VOSTROM,
		XEROX,
		RICEBSD,
		QHULL,
		UNKNOWN
	}
	[CCode (cprefix = "PK_MESSAGE_ENUM_", has_type_id = "0", cheader_filename = "packagekit.h")]
	public enum MessageEnum {
		BROKEN_MIRROR,
		CONNECTION_REFUSED,
		PARAMETER_INVALID,
		PRIORITY_INVALID,
		BACKEND_ERROR,
		DAEMON_ERROR,
		CACHE_BEING_REBUILT,
		UNTRUSTED_PACKAGE,
		NEWER_PACKAGE_EXISTS,
		COULD_NOT_FIND_PACKAGE,
		CONFIG_FILES_CHANGED,
		PACKAGE_ALREADY_INSTALLED,
		UNKNOWN
	}
	[CCode (cprefix = "PK_NETWORK_ENUM_", has_type_id = "0", cheader_filename = "packagekit.h")]
	public enum NetworkEnum {
		OFFLINE,
		ONLINE,
		SLOW,
		FAST,
		UNKNOWN
	}
	[CCode (cprefix = "PK_PROVIDES_ENUM_", has_type_id = "0", cheader_filename = "packagekit.h")]
	public enum ProvidesEnum {
		ANY,
		MODALIAS,
		CODEC,
		MIMETYPE,
		FONT,
		HARDWARE_DRIVER,
		UNKNOWN
	}
	[CCode (cprefix = "PK_RESTART_ENUM_", has_type_id = "0", cheader_filename = "packagekit.h")]
	public enum RestartEnum {
		NONE,
		APPLICATION,
		SESSION,
		SYSTEM,
		UNKNOWN
	}
	[CCode (cprefix = "PK_ROLE_ENUM_", has_type_id = "0", cheader_filename = "packagekit.h")]
	public enum RoleEnum {
		CANCEL,
		GET_DEPENDS,
		GET_DETAILS,
		GET_FILES,
		GET_PACKAGES,
		GET_REPO_LIST,
		GET_REQUIRES,
		GET_UPDATE_DETAIL,
		GET_UPDATES,
		INSTALL_FILES,
		INSTALL_PACKAGES,
		INSTALL_SIGNATURE,
		REFRESH_CACHE,
		REMOVE_PACKAGES,
		REPO_ENABLE,
		REPO_SET_DATA,
		RESOLVE,
		ROLLBACK,
		SEARCH_DETAILS,
		SEARCH_FILE,
		SEARCH_GROUP,
		SEARCH_NAME,
		SERVICE_PACK,
		UPDATE_PACKAGES,
		UPDATE_SYSTEM,
		WHAT_PROVIDES,
		ACCEPT_EULA,
		DOWNLOAD_PACKAGES,
		GET_DISTRO_UPGRADES,
		UNKNOWN
	}
	[CCode (cprefix = "PK_SIGTYPE_ENUM_", has_type_id = "0", cheader_filename = "packagekit.h")]
	public enum SigTypeEnum {
		GPG,
		UNKNOWN
	}
	[CCode (cprefix = "PK_STATUS_ENUM_", has_type_id = "0", cheader_filename = "packagekit.h")]
	public enum StatusEnum {
		WAIT,
		SETUP,
		RUNNING,
		QUERY,
		INFO,
		REMOVE,
		REFRESH_CACHE,
		DOWNLOAD,
		INSTALL,
		UPDATE,
		CLEANUP,
		OBSOLETE,
		DEP_RESOLVE,
		SIG_CHECK,
		ROLLBACK,
		TEST_COMMIT,
		COMMIT,
		REQUEST,
		FINISHED,
		CANCEL,
		DOWNLOAD_REPOSITORY,
		DOWNLOAD_PACKAGELIST,
		DOWNLOAD_FILELIST,
		DOWNLOAD_CHANGELOG,
		DOWNLOAD_GROUP,
		DOWNLOAD_UPDATEINFO,
		REPACKAGING,
		LOADING_CACHE,
		SCAN_APPLICATIONS,
		GENERATE_PACKAGE_LIST,
		UNKNOWN
	}
	[CCode (cprefix = "PK_UPDATE_STATE_ENUM_", has_type_id = "0", cheader_filename = "packagekit.h")]
	public enum UpdateStateEnum {
		STABLE,
		UNSTABLE,
		TESTING,
		UNKNOWN
	}
	[Compact]
	[CCode (cheader_filename = "packagekit.h")]
	public class Bitfield {
		public int contain_priority (int value);
		public static weak Pk.Bitfield from_enums (int value);
	}
	[Compact]
	[CCode (copy_function = "pk_details_obj_copy", cheader_filename = "packagekit.h")]
	public class DetailsObj {
		public weak Pk.PackageId id;
		public weak string license;
		public Pk.GroupEnum group;
		public weak string description;
		public weak string url;
		public uint64 size;
		public weak Pk.DetailsObj copy ();
		[CCode (has_construct_function = false)]
		public DetailsObj ();
		[CCode (has_construct_function = false)]
		public DetailsObj.from_data (Pk.PackageId id, string license, Pk.GroupEnum group, string description, string url, uint64 size);
	}
	[Compact]
	[CCode (copy_function = "pk_distro_upgrade_obj_copy", cheader_filename = "packagekit.h")]
	public class DistroUpgradeObj {
		public Pk.UpdateStateEnum state;
		public weak string name;
		public weak string summary;
		public weak Pk.DistroUpgradeObj copy ();
		[CCode (has_construct_function = false)]
		public DistroUpgradeObj ();
		[CCode (has_construct_function = false)]
		public DistroUpgradeObj.from_data (Pk.UpdateStateEnum state, string name, string summary);
	}
	[Compact]
	[CCode (cheader_filename = "packagekit.h")]
	public class EnumMatch {
		public uint value;
		[CCode (cname = "string")]
		public weak string str;
	}
	[Compact]
	[CCode (copy_function = "pk_package_id_copy", cheader_filename = "packagekit.h")]
	public class PackageId {
		public weak string name;
		public weak string version;
		public weak string arch;
		public weak string data;
		public static weak string build (string name, string version, string arch, string data);
		public static bool check (string package_id);
		public weak Pk.PackageId copy ();
		public bool equal (Pk.PackageId id2);
		public static bool equal_strings (string pid1, string pid2);
		[CCode (has_construct_function = false)]
		public PackageId ();
		[CCode (has_construct_function = false)]
		public PackageId.from_list (string name, string version, string arch, string data);
		[CCode (has_construct_function = false)]
		public PackageId.from_string (string package_id);
		public weak string to_string ();
	}
	[Compact]
	[CCode (copy_function = "pk_package_obj_copy", cheader_filename = "packagekit.h")]
	public class PackageObj {
		public Pk.InfoEnum info;
		public weak Pk.PackageId id;
		public weak string summary;
		public weak Pk.PackageObj copy ();
		public bool equal (Pk.PackageObj obj2);
		public static weak Pk.PackageObj from_string (string text);
		[CCode (has_construct_function = false)]
		public PackageObj (Pk.InfoEnum info, Pk.PackageId id, string summary);
		public weak string to_string ();
	}
	[Compact]
	[CCode (cheader_filename = "packagekit.h")]
	public class TaskListItem {
		public weak string tid;
		public Pk.StatusEnum status;
		public Pk.RoleEnum role;
		public weak string text;
		public weak Pk.Client monitor;
		public bool valid;
	}
	[Compact]
	[CCode (copy_function = "pk_update_detail_obj_copy", cheader_filename = "packagekit.h")]
	public class UpdateDetailObj {
		public weak Pk.PackageId id;
		public weak string updates;
		public weak string obsoletes;
		public weak string vendor_url;
		public weak string bugzilla_url;
		public weak string cve_url;
		public Pk.RestartEnum restart;
		public weak string update_text;
		public weak string changelog;
		public Pk.UpdateStateEnum state;
		public GLib.Date issued;
		public GLib.Date updated;
		public weak Pk.UpdateDetailObj copy ();
		[CCode (has_construct_function = false)]
		public UpdateDetailObj ();
		[CCode (has_construct_function = false)]
		public UpdateDetailObj.from_data (Pk.PackageId id, string updates, string obsoletes, string vendor_url, string bugzilla_url, string cve_url, Pk.RestartEnum restart, string update_text, string changelog, Pk.UpdateStateEnum state, GLib.Date issued, GLib.Date updated);
	}
	[CCode (cheader_filename = "packagekit.h")]
	public class Catalog : GLib.Object {
		public bool cancel ();
		[CCode (has_construct_function = false)]
		public Catalog ();
		public weak Pk.PackageList process_files (string filenames);
		public virtual signal void progress (uint p0, string p1);
	}
	[CCode (cheader_filename = "packagekit.h")]
	public class Client : GLib.Object {
		public bool accept_eula (string eula_id) throws GLib.Error;
		public bool cancel () throws GLib.Error;
		public bool download_packages (string package_ids, string directory) throws GLib.Error;
		public static bool error_print () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public bool get_allow_cancel (bool allow_cancel) throws GLib.Error;
		public bool get_depends (Pk.Bitfield filters, string package_ids, bool recursive) throws GLib.Error;
		public bool get_details (string package_ids) throws GLib.Error;
		public bool get_distro_upgrades () throws GLib.Error;
		public bool get_files (string package_ids) throws GLib.Error;
		public bool get_old_transactions (uint number) throws GLib.Error;
		public bool get_package (string package) throws GLib.Error;
		public weak Pk.PackageList get_package_list ();
		public bool get_packages (Pk.Bitfield filters) throws GLib.Error;
		public bool get_progress (uint percentage, uint subpercentage, uint elapsed, uint remaining) throws GLib.Error;
		public bool get_repo_list (Pk.Bitfield filters) throws GLib.Error;
		public Pk.RestartEnum get_require_restart ();
		public bool get_requires (Pk.Bitfield filters, string package_ids, bool recursive) throws GLib.Error;
		public bool get_role (Pk.RoleEnum role, string text) throws GLib.Error;
		public bool get_status (Pk.StatusEnum status) throws GLib.Error;
		public weak string get_tid ();
		public bool get_update_detail (string package_ids) throws GLib.Error;
		public bool get_updates (Pk.Bitfield filters) throws GLib.Error;
		public bool get_use_buffer ();
		public bool install_file (bool trusted, string file_rel) throws GLib.Error;
		public bool install_files (bool trusted, string files_rel) throws GLib.Error;
		public bool install_packages (string package_ids) throws GLib.Error;
		public bool install_signature (Pk.SigTypeEnum type, string key_id, string package_id) throws GLib.Error;
		public bool is_caller_active (bool is_active) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Client ();
		public bool refresh_cache (bool force) throws GLib.Error;
		public bool remove_packages (string package_ids, bool allow_deps, bool autoremove) throws GLib.Error;
		public bool repo_enable (string repo_id, bool enabled) throws GLib.Error;
		public bool repo_set_data (string repo_id, string parameter, string value) throws GLib.Error;
		public bool requeue () throws GLib.Error;
		public bool reset () throws GLib.Error;
		public bool resolve (Pk.Bitfield filters, string packages) throws GLib.Error;
		public bool rollback (string transaction_id) throws GLib.Error;
		public bool search_details (Pk.Bitfield filters, string search) throws GLib.Error;
		public bool search_file (Pk.Bitfield filters, string search) throws GLib.Error;
		public bool search_group (Pk.Bitfield filters, string search) throws GLib.Error;
		public bool search_name (Pk.Bitfield filters, string search) throws GLib.Error;
		public bool set_locale (string code) throws GLib.Error;
		public bool set_synchronous (bool synchronous) throws GLib.Error;
		public bool set_tid (string tid) throws GLib.Error;
		public bool set_use_buffer (bool use_buffer) throws GLib.Error;
		public bool update_packages (string package_ids) throws GLib.Error;
		public bool update_system () throws GLib.Error;
		public bool what_provides (Pk.Bitfield filters, Pk.ProvidesEnum provides, string search) throws GLib.Error;
		public virtual signal void allow_cancel (bool allow_cancel);
		public virtual signal void caller_active_changed (bool is_active);
		public virtual signal void destroy ();
		public virtual signal void details (void* package_detail);
		public virtual signal void distro_upgrade (void* type);
		public virtual signal void error_code (uint code, string details);
		public virtual signal void eula_required (string eula_id, string package_id, string vendor_name, string license_agreement);
		public virtual signal void files (string package_id, string filelist);
		public virtual signal void finished (uint exit, uint runtime);
		public virtual signal void message (uint message, string details);
		public virtual signal void package (void* obj);
		public virtual signal void progress_changed (uint percentage, uint subpercentage, uint elapsed, uint remaining);
		public virtual signal void repo_detail (string repo_id, string description, bool enabled);
		public virtual signal void repo_signature_required (string package_id, string repository_name, string key_url, string key_userid, string key_id, string key_fingerprint, string key_timestamp, uint type);
		public virtual signal void require_restart (uint restart, string details);
		public virtual signal void status_changed (uint status);
		public virtual signal void transaction (string tid, string timespec, bool succeeded, uint role, uint duration, string data);
		public virtual signal void update_detail (void* update_detail);
	}
	[CCode (cheader_filename = "packagekit.h")]
	public class Connection : GLib.Object {
		[CCode (has_construct_function = false)]
		public Connection ();
		public bool valid ();
		public virtual signal void connection_changed (bool connected);
	}
	[CCode (cheader_filename = "packagekit.h")]
	public class Control : GLib.Object {
		public bool allocate_transaction_id (string tid) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public weak Pk.Bitfield get_actions () throws GLib.Error;
		public bool get_backend_detail (string name, string author) throws GLib.Error;
		public weak Pk.Bitfield get_filters () throws GLib.Error;
		public weak Pk.Bitfield get_groups () throws GLib.Error;
		public weak string get_mime_types () throws GLib.Error;
		public Pk.NetworkEnum get_network_state () throws GLib.Error;
		public bool get_time_since_action (Pk.RoleEnum role, uint seconds) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Control ();
		public bool set_proxy (string proxy_http, string proxy_ftp) throws GLib.Error;
		public weak string transaction_list_get ();
		public bool transaction_list_print ();
		public virtual signal void locked (bool is_locked);
		public virtual signal void network_state_changed (uint p0);
		public virtual signal void repo_list_changed ();
		public virtual signal void restart_schedule ();
		public virtual signal void transaction_list_changed ();
		public virtual signal void updates_changed ();
	}
	[CCode (cheader_filename = "packagekit.h")]
	public class Extra : GLib.Object {
		public weak string get_exec (string package);
		public weak string get_icon_name (string package);
		public weak string get_locale ();
		public weak string get_summary (string package);
		[CCode (has_construct_function = false)]
		public Extra ();
		public bool set_access (Pk.ExtraAccess access);
		public bool set_data_locale (string package, string summary);
		public bool set_data_package (string package, string icon_name, string exec);
		public bool set_database (string filename);
		public bool set_locale (string locale);
	}
	[CCode (cheader_filename = "packagekit.h")]
	public class PackageList : GLib.Object {
		public bool add (Pk.InfoEnum info, Pk.PackageId ident, string summary);
		public bool add_file (string filename);
		public bool add_list (Pk.PackageList list);
		public bool add_obj (Pk.PackageObj obj);
		public bool clear ();
		public bool contains (string package_id);
		public bool contains_obj (Pk.PackageObj obj);
		public weak Pk.PackageObj get_obj (uint item);
		public uint get_size ();
		[CCode (has_construct_function = false)]
		public PackageList ();
		public bool remove (string package_id);
		public bool remove_obj (Pk.PackageObj obj);
		public bool sort ();
		public bool sort_info ();
		public bool sort_summary ();
		public bool to_file (string filename);
		public weak string to_string ();
		public weak string to_strv ();
	}
	[CCode (cheader_filename = "packagekit.h")]
	public class TaskList : GLib.Object {
		public bool contains_role (Pk.RoleEnum role);
		public bool free ();
		public weak Pk.TaskListItem get_item (uint item);
		public uint get_size ();
		[CCode (has_construct_function = false)]
		public TaskList ();
		public bool print ();
		public bool refresh ();
		public virtual signal void changed ();
		public virtual signal void error_code (void* client, uint code, string details);
		public virtual signal void finished (void* client, uint exit, uint runtime);
		public virtual signal void message (void* client, uint message, string details);
		public virtual signal void status_changed ();
	}
	[CCode (cheader_filename = "packagekit.h")]
	public const int CLIENT_PERCENTAGE_INVALID;
	[CCode (cheader_filename = "packagekit.h")]
	public const string DBUS_INTERFACE;
	[CCode (cheader_filename = "packagekit.h")]
	public const string DBUS_INTERFACE_TRANSACTION;
	[CCode (cheader_filename = "packagekit.h")]
	public const string DBUS_PATH;
	[CCode (cheader_filename = "packagekit.h")]
	public const string DBUS_SERVICE;
	[CCode (cheader_filename = "packagekit.h")]
	public const string EXTRA_DEFAULT_DATABASE;
	[CCode (cheader_filename = "packagekit.h")]
	public const string PACKAGE_IDS_DELIM;
	[CCode (cheader_filename = "packagekit.h")]
	public const string SERVICE_PACK_GROUP_NAME;
	[CCode (cheader_filename = "packagekit.h")]
	public static Pk.DistroUpgradeEnum distro_upgrade_enum_from_text (string upgrade);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string distro_upgrade_enum_to_text (Pk.DistroUpgradeEnum upgrade);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string enum_find_string (Pk.EnumMatch table, uint value);
	[CCode (cheader_filename = "packagekit.h")]
	public static uint enum_find_value (Pk.EnumMatch table, string str);
	[CCode (cheader_filename = "packagekit.h")]
	public static Pk.ErrorCodeEnum error_enum_from_text (string code);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string error_enum_to_text (Pk.ErrorCodeEnum code);
	[CCode (cheader_filename = "packagekit.h")]
	public static Pk.ExitEnum exit_enum_from_text (string exit);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string exit_enum_to_text (Pk.ExitEnum exit);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak Pk.Bitfield filter_bitfield_from_text (string filters);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string filter_bitfield_to_text (Pk.Bitfield filters);
	[CCode (cheader_filename = "packagekit.h")]
	public static Pk.FilterEnum filter_enum_from_text (string filter);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string filter_enum_to_text (Pk.FilterEnum filter);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string get_distro_id ();
	[CCode (cheader_filename = "packagekit.h")]
	public static weak Pk.Bitfield group_bitfield_from_text (string groups);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string group_bitfield_to_text (Pk.Bitfield groups);
	[CCode (cheader_filename = "packagekit.h")]
	public static Pk.GroupEnum group_enum_from_text (string group);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string group_enum_to_text (Pk.GroupEnum group);
	[CCode (cheader_filename = "packagekit.h")]
	public static Pk.InfoEnum info_enum_from_text (string info);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string info_enum_to_text (Pk.InfoEnum info);
	[CCode (cheader_filename = "packagekit.h")]
	public static uint iso8601_difference (string isodate);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string iso8601_from_date (GLib.Date date);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string iso8601_present ();
	[CCode (cheader_filename = "packagekit.h")]
	public static GLib.Date iso8601_to_date (string iso_date);
	[CCode (cheader_filename = "packagekit.h")]
	public static Pk.LicenseEnum license_enum_from_text (string license);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string license_enum_to_text (Pk.LicenseEnum license);
	[CCode (cheader_filename = "packagekit.h")]
	public static Pk.MessageEnum message_enum_from_text (string message);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string message_enum_to_text (Pk.MessageEnum message);
	[CCode (cheader_filename = "packagekit.h")]
	public static Pk.NetworkEnum network_enum_from_text (string network);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string network_enum_to_text (Pk.NetworkEnum network);
	[CCode (cheader_filename = "packagekit.h")]
	public static bool package_ids_check (string package_ids);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string package_ids_from_array (GLib.PtrArray array);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string package_ids_from_id (string package_id);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string package_ids_from_text (string package_id);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string package_ids_from_va_list (string package_id_first, void* args);
	[CCode (cheader_filename = "packagekit.h")]
	public static bool package_ids_print (string package_ids);
	[CCode (cheader_filename = "packagekit.h")]
	public static uint package_ids_size (string package_ids);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string package_ids_to_text (string package_ids);
	[CCode (cheader_filename = "packagekit.h")]
	public static Pk.ProvidesEnum provides_enum_from_text (string provides);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string provides_enum_to_text (Pk.ProvidesEnum provides);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string ptr_array_to_strv (GLib.PtrArray array);
	[CCode (cheader_filename = "packagekit.h")]
	public static Pk.RestartEnum restart_enum_from_text (string restart);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string restart_enum_to_text (Pk.RestartEnum restart);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak Pk.Bitfield role_bitfield_from_text (string roles);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string role_bitfield_to_text (Pk.Bitfield roles);
	[CCode (cheader_filename = "packagekit.h")]
	public static Pk.RoleEnum role_enum_from_text (string role);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string role_enum_to_text (Pk.RoleEnum role);
	[CCode (cheader_filename = "packagekit.h")]
	public static Pk.SigTypeEnum sig_type_enum_from_text (string sig_type);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string sig_type_enum_to_text (Pk.SigTypeEnum sig_type);
	[CCode (cheader_filename = "packagekit.h")]
	public static Pk.StatusEnum status_enum_from_text (string status);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string status_enum_to_text (Pk.StatusEnum status);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string strsafe (string text);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak GLib.PtrArray strv_to_ptr_array (string array);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string strv_to_text (string package_ids, string delimiter);
	[CCode (cheader_filename = "packagekit.h")]
	public static bool strvalidate (string text);
	[CCode (cheader_filename = "packagekit.h")]
	public static Pk.UpdateStateEnum update_state_enum_from_text (string update_state);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string update_state_enum_to_text (Pk.UpdateStateEnum update_state);
	[CCode (cheader_filename = "packagekit.h")]
	public static weak string va_list_to_argv (string string_first, void* args);
}
