/* Copyright (c) 2002-2010 Dovecot Sieve authors, see the included COPYING file
 */

#ifndef __SIEVE_H
#define __SIEVE_H

#include "lib.h"

#include <stdio.h>

struct sieve_binary;
struct sieve_script;
struct sieve_instance;

struct sieve_callbacks {
    const char *(*get_homedir)(void *context);
    const char *(*get_setting)(void *context, const char *identifier);
};


#include "sieve-error.h"

struct sieve_instance *sieve_init
	(const struct sieve_callbacks *callbacks, void *context);
void sieve_deinit(struct sieve_instance **svinst);

struct sieve_binary *sieve_compile_script
    (struct sieve_script *script, struct sieve_error_handler *ehandler);
void sieve_close(struct sieve_binary **sbin);

void sieve_set_extensions(struct sieve_instance *, const char *extensions);
const char *sieve_get_capabilities(struct sieve_instance *, const char *name);

static inline unsigned int sieve_max_redirects
(struct sieve_instance *svinst ATTR_UNUSED)
{
	return 0;
}

static inline unsigned int sieve_max_actions
(struct sieve_instance *svinst ATTR_UNUSED)
{
	return 0;
}

static inline size_t sieve_max_script_size
(struct sieve_instance *svinst ATTR_UNUSED)
{
	return 0;
}

#endif
