// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#include "gui.h"
#include "buildwin.h"
#include "callback.h"
#include "global.h"
#include <cctype>

HISTORY hist;
int tblIndexToMenu[256+10];
int tblMenuToIndex[256+10];
static DICCHAR jumpPointer[cMaxButton];
static int nButtons=0;

extern GtkWidget* upButton;
extern GtkWidget* downButton;
extern GtkWidget* pageUpButton;
extern GtkWidget* pageDownButton;

static GtkWidget* resultList=NULL;

extern int scroll_callback(GtkWidget* w,gpointer x){
  int dir=gint(x)==1?1:-1;
  GtkAdjustment* adj=
    gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(resultText));
  gfloat val=adj->value+adj->page_increment*dir;
  if (val+adj->page_size>adj->upper) val=adj->upper-adj->page_size;
  if (val<0) val=0;
  gtk_adjustment_set_value(adj,val);
  gtk_scrolled_window_set_vadjustment(GTK_SCROLLED_WINDOW(resultText),adj);
  return TRUE;
}

void winDestroy(void)
{
  gtk_exit (0);
}


int PrevLines(void){
  int h=resultScroll->allocation.height;
  int hp=(h/50)-1;
  if (hp<0) hp=0;
  return hp;
}
int ForwLines(void){
  int h=resultScroll->allocation.height;
  int hh=h/16-PrevLines();
  if (hh<1) hh=1;
  return hh;
}

void MakeIndexList(SELECTION_MENU* sel,bool dispHonmon){
  if (resultList!=NULL){
    gtk_widget_destroy(resultList);
  } 
  resultList=gtk_vbox_new(FALSE,1);
  gtk_widget_show (resultList);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(resultScroll),
					resultList);    
  ButtonInit();

  nButtons=0;
  int start=sel->nReverse-PrevLines();
  if (start<0) start=0;
  int end=sel->items.size();
  if (end>start+sel->nForward) end=start+sel->nForward+1;
  bool more=false;
  if (end-start>1000) {
    end=start+1000;
    more=true;
  }
  for(int i=start;i<end;i++){
    TAG wordString=sel->items[i].keywordTag;
    //    TAG wordString=sel->items[i].adrs;
    TAG adrs=sel->items[i].adrs;
    DICLINE* dl=new DICLINE();
    dl->GetLine(currentDict,wordString);
    GtkWidget* pixmap=MakePixmapFromDicText(dl->txt(),i==sel->nReverse);
    GtkWidget* button=gtk_button_new();
    gtk_container_add(GTK_CONTAINER(button),pixmap);
    delete dl;
    gtk_box_pack_start(GTK_BOX(resultList),button,FALSE,FALSE,0);
    jumpPointer[nButtons].Tag(adrs);
    gtk_signal_connect (GTK_OBJECT (button), "clicked",
			GTK_SIGNAL_FUNC (TagJump), jumpPointer+nButtons);
    nButtons++;
    gtk_widget_show(pixmap);
    gtk_widget_show(button);
  }
  if (more) {
    gtk_box_pack_start(GTK_BOX(resultList),gtk_label_new(_("<< More >>")),
		       FALSE,FALSE,0);
  }
  if (!dispHonmon || sel->items.size()==0) return;
  DisplayHonmon(sel->items[sel->nReverse].adrs);
  hist.Append(sel->items[sel->nReverse].adrs);
}

void MakeIndexList(INDEXITEMLIST_T& itemList,bool dispHonmon){
  if (resultList!=NULL){
    gtk_widget_destroy(resultList);
  } 
  resultList=gtk_vbox_new(FALSE,1);
  gtk_widget_show (resultList);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(resultScroll),
					resultList);    
  ButtonInit();
  nButtons=0;
  unsigned int end=itemList.size();
  if (end>cMaxHit) end=cMaxHit;
  Debug::DebugOut(Debug::DICTIONARY,_("Hit=%d\n"),end);
  INDEXITEMLIST_T::iterator ii=itemList.begin();
  for(unsigned int i=0;i<end;i++,++ii){
    TAG adrs=(*ii).adrs;
    DICLINE* dl=new DICLINE();
    dl->GetLine(currentDict,adrs);
    GtkWidget* pixmap=MakePixmapFromDicText(dl->txt(),false);
    //    GtkWidget* pixmap=MakePixmapFromDicText(MakeText((*ii).dkeyword.c_str()),false);
    GtkWidget* button=gtk_button_new();
    gtk_container_add(GTK_CONTAINER(button),pixmap);
    delete dl;
    gtk_box_pack_start(GTK_BOX(resultList),button,FALSE,FALSE,0);
    jumpPointer[nButtons].Tag(adrs);
    gtk_signal_connect (GTK_OBJECT (button), "clicked",
			GTK_SIGNAL_FUNC (TagJump), jumpPointer+nButtons);
    nButtons++;
    gtk_widget_show(pixmap);
    gtk_widget_show(button);
  }
  if (itemList.size()>cMaxHit || itemList.size()==0){
    GtkWidget* label;
    if (itemList.size()==0) {
      label=gtk_label_new(_("No Hit"));
    } else {
      label=gtk_label_new(_("Too Many Hit!"));
    }
    GtkWidget* align=gtk_alignment_new(0,0,0.0,0.5);
    gtk_container_add(GTK_CONTAINER(align),label);
    gtk_widget_show(label);
    gtk_widget_show(align);
    gtk_box_pack_start(GTK_BOX(resultList),align,FALSE,FALSE,0);
  }
  if (!dispHonmon || itemList.size()==0) return;
  DisplayHonmon(itemList.front().adrs);
  hist.Append(itemList.front().adrs);
}

void SetSelectedDicMenu(int n){
  if (catalogs.nDic()>n){
    if (currentDict!=NULL) {
      delete currentDict;
      currentDict=NULL;
      hist.Initialize();
    }
    currentDict=new DICTIONARY(catalogs.Dic(n));
    preference.currentDictNum=n;
    gtk_label_set_text(GTK_LABEL(dicTitle),catalogs.Dic(n)->DicName().c_str());

    if (resultList!=NULL){
      gtk_widget_destroy(resultList);
    } 
    resultList=NULL;

    if (currentDict!=NULL && currentDict->nIndex()>0){
      currentGaiji=currentDict->Gaiji();
      SetIndexMenu();
    }

    DisplayHonmon(TAG(0,0));

    // Display Copyright

    if (currentDict->IndexStart(0x02)!=TAG(0,0)){
      hist.Append(currentDict->IndexStart(0x02));
      DisplayHonmon(currentDict->IndexStart(0x02));
    } else if (currentDict->IndexStart(0x21)!=TAG(0,0)){
      hist.Append(currentDict->IndexStart(0x21));
      DisplayHonmon(currentDict->IndexStart(0x21));
    } else if (currentDict->IndexStart(0x23)!=TAG(0,0)){
      hist.Append(currentDict->IndexStart(0x23));
      DisplayHonmon(currentDict->IndexStart(0x23));
    }
  }
}

void SetSelectedIndexMenu(int n){
  if (currentDict->nIndex()>0){
    //    gtk_option_menu_set_history(GTK_OPTION_MENU(indexSelMenu),0);
  }
  int menuID=tblMenuToIndex[n];
  if (menuID>0){
    if ((menuID & 0xf0)==0x10){
      TAG t=currentDict->IndexStart(menuID);
      if (currentDict->isEB) t=TAG(t.Block(),t.Offset()+0x10);
      hist.Append(t);
      DisplayHonmon(t);
    } else if (menuID<0x30 || (menuID & 0xf0) == 0xe0){
      hist.Append(currentDict->IndexStart(menuID));
      DisplayHonmon(currentDict->IndexStart(menuID));
    } else if ((menuID & 0xff)!=0xff) {
      CreateIndexSearchMenu(mainWindow,menuID);
    } else {
      CreateCombinedSearchMenu(mainWindow,menuID);
    }
  }
}


void selection_paste(void){
  gtk_entry_set_text(GTK_ENTRY(wordBox),"");
  gtk_selection_convert(GTK_WIDGET(wordBox),GDK_SELECTION_PRIMARY,
			GDK_TARGET_STRING,GDK_CURRENT_TIME);
};

TAG GetAddress(const NATIVE_STRING& s){
  int len=s.length();
  if (len==0) return TAG(0,0);
  if (s[0]!=':') return TAG(0,0);
  int nDelim=0;
  for(int i=1;i<len;i++){
    if (s[i]==':') {
      nDelim++;
      if (nDelim>1) return TAG(0,0);
      if (!isxdigit(s[i]) && s[i]!=':') return TAG(0,0);
    }
  }
  char* bp;
  int block=strtol(s.c_str()+1,&bp,0);
  int offset=strtol(bp+1,NULL,0);
  return TAG(block,offset);
}

void edit_callback(GtkWidget *widget, GtkWidget *entry){
  EUC_STRING entry_text = _CE(gtk_entry_get_text(GTK_ENTRY(entry)));
  if (currentDict!=NULL){
    currentDict->FindWordHead(entry_text,-0x90);
    currentDict->sel->Setup(PrevLines(),ForwLines());
    MakeIndexList(currentDict->sel,false);
  }
}

void enter_callback(GtkWidget *widget, GtkWidget *entry){
  EUC_STRING entry_text = _CE(gtk_entry_get_text(GTK_ENTRY(entry)));
  TAG t=GetAddress(entry_text);
  if (t==TAG(0,0)){
    if (resultList==NULL){
      edit_callback(widget,entry);
    }
    if (currentDict!=NULL && currentDict->sel!=NULL){
      MakeIndexList(currentDict->sel,true);
    }
  } else {
    hist.Append(t);
    DisplayHonmon(t);
  } 
}

void down_callback(GtkWidget *widget, GtkWidget *entry){
  if (currentDict!=NULL && currentDict->sel!=NULL){
    currentDict->sel->Next();
    currentDict->sel->Setup(PrevLines(),ForwLines());
    MakeIndexList(currentDict->sel,true);
  }
}

void up_callback(GtkWidget *widget, GtkWidget *entry){
  if (currentDict!=NULL && currentDict->sel!=NULL){
    currentDict->sel->Prev();
    currentDict->sel->Setup(PrevLines(),ForwLines());
    MakeIndexList(currentDict->sel,true);
  }
}

void IndexSelectCallback(GtkWidget *widget, gpointer action){
  SetSelectedIndexMenu((guint)action);
}

void SetIndexMenu(void){
  GtkWidget* w;
  for(int i=0;i<0xff;i++){
    tblIndexToMenu[i]=-1;
    tblMenuToIndex[i]=-1;
  }
  gtk_widget_destroy(currentIndexMenu);
  currentIndexMenu=gtk_menu_new();
  gtk_menu_append(GTK_MENU(currentIndexMenu),gtk_tearoff_menu_item_new());
  int count=0;
  for(int i=0;i<0xff;i++){
    if (currentDict->IndexExist(i)) {
      if (!isMenuKey(i,currentDict->isEB)) continue;
      char buf[256];
      if (currentDict->IndexName(i)!=NULL){
#ifdef DEBUG
	sprintf(buf,"%02X %s",i,currentDict->IndexName(i));
#else
	strcpy(buf,currentDict->IndexName(i));
#endif
      } else {
#ifdef DEBUG
	sprintf(buf,_("%02X Unknown Index"),i);
#else
	strcpy(buf,_("Unknown Index"));
#endif
      }
      gtk_menu_append(GTK_MENU(currentIndexMenu),
		      w=gtk_menu_item_new_with_label(buf));
      tblIndexToMenu[i]=count;
      tblMenuToIndex[count]=i;
      gtk_signal_connect(GTK_OBJECT(w),"activate",
			 (GtkSignalFunc)IndexSelectCallback,(gpointer)count);
      count++;
    }
  }
  for(int i=0;i<currentDict->nmIndex();i++){
    gtk_menu_append(GTK_MENU(currentIndexMenu),
	    w=gtk_menu_item_new_with_label(currentDict->MIndexName(i)));
    tblIndexToMenu[i+0x100]=count;
    tblMenuToIndex[count]=i*0x100+0xff;
    gtk_signal_connect(GTK_OBJECT(w),"activate",
		(GtkSignalFunc)IndexSelectCallback,(gpointer)count);
    count++;
  }
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(currentIndexMenuBase),
			    currentIndexMenu);
  gtk_widget_show_all(currentIndexMenuBase);
}

void DicSelectCallback(GtkWidget *widget, gpointer action){
  SetSelectedDicMenu((guint)action);
  if (currentDict!=NULL && currentDict->nIndex()>0){
    currentGaiji=currentDict->Gaiji();
    SetIndexMenu();
  }
}

void SetDicMenu(void){
  int menuType=preference.GetIntValue("/ebdic/preference/dict-list-type");

  gtk_widget_destroy(currentDictMenu);
  currentDictMenu=gtk_menu_new();

  GtkWidget* w;
  if (catalogs.books.size()==0) { 
    char* label=strdup(_("No Dictionary"));
    w=gtk_menu_item_new_with_label(label);
    free(label);
    gtk_menu_append(GTK_MENU(currentDictMenu),w);
    gtk_widget_show_all(currentDictMenu);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(currentDictMenuBase),
			      currentDictMenu);
    return;
  };

  gtk_menu_append(GTK_MENU(currentDictMenu),gtk_tearoff_menu_item_new());

  int count=0;
  for(unsigned int i=0;i<catalogs.books.size();i++){
    GtkWidget *w, *m2;
    if (menuType==1){
      if (catalogs.books[i].title.length()==0){
	char buf[256];
	sprintf(buf,"%s %d",_("Dictionary"),i);
	w=gtk_menu_item_new_with_label(buf);
      } else {
	w=gtk_menu_item_new_with_label(catalogs.books[i].title.c_str());
      }
      m2=gtk_menu_new();
      gtk_menu_item_set_submenu(GTK_MENU_ITEM(w),m2);
    } else {
      m2=currentDictMenu;
      w=NULL;
    }

    for(unsigned int j=0;j<catalogs.books[i].dict.size();j++){
      const DICT& dict=catalogs.books[i].dict[j];
      GtkWidget* w2=gtk_menu_item_new_with_label(dict.DicName().c_str());
      if ((dict.Type()&0xf0)==0xf0) gtk_widget_set_sensitive(w2,FALSE);
      gtk_signal_connect(GTK_OBJECT(w2),"activate",
			 (GtkSignalFunc)DicSelectCallback,(gpointer)count);
      if (count<12){
	gtk_widget_add_accelerator(w2,"activate",accelGroup,GDK_F1+count,
				   GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
      } else if (count<24){
	gtk_widget_add_accelerator(w2,"activate",accelGroup,GDK_F1+count-12,
				   GDK_SHIFT_MASK,GTK_ACCEL_VISIBLE);
      }
      count++;
      gtk_menu_append(GTK_MENU(m2),w2);
    }
    if (menuType==1) {
      gtk_menu_append(GTK_MENU(currentDictMenu),w);
    }
  }
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(currentDictMenuBase),
			    currentDictMenu);
  gtk_widget_show_all(currentDictMenuBase);

  SetSelectedDicMenu(preference.currentDictNum);
  if (currentDict!=NULL && currentDict->nIndex()>0){
    currentGaiji=currentDict->Gaiji();
    SetIndexMenu();
  }
}

void FileSelect(void){
  NATIVE_STRING fileName=FileDialog(_("Select Config File or Catalog File"),
			     "catalog*");
  if (fileName.length()!=0) {
    preference.Read(fileName.c_str());
  }
}

void focus_callback(GtkWidget *widget, gpointer action){
  gtk_widget_grab_focus(wordBox);
}

void HISTORY::Initialize(){
  tag.clear();
};

void HISTORY::Append(const TAG& t){
  if (tag.size()>cHistSize) {
    tag.pop_back();
  }
  tag.push_front(t);
  Debug::DebugOut(Debug::DISPLAY,"HIST APPEND=%05d\n",hist.tag.size());
}

TAG HISTORY::Next() {
  if (tag.size()==0) return TAG(0,0);
  tag.push_front(tag.back());
  tag.pop_back();
  return tag.front();
}

TAG HISTORY::Prev() {
  if (tag.size()==0) return TAG(0,0);
  tag.push_back(tag.front());
  tag.pop_front();
  return tag.front();
}

TAG HISTORY::Last() const {
  if (tag.size()==0) return TAG(0,0);
  return tag.front();
}

bool hist_prev(GtkWidget* widget, gpointer action){
  Debug::DebugOut(Debug::DISPLAY,"HIST=%05d\n",hist.tag.size());
  DisplayHonmon(hist.Prev());
  return true;
}

void hist_next(GtkWidget* widget, gpointer action){
  Debug::DebugOut(Debug::DISPLAY,"HIST=%05d\n",hist.tag.size());
  DisplayHonmon(hist.Next());
}

static gint timeoutWaitNumber=0;

void Refresh(GtkWidget* widget, GdkEvent* event){
  if (timeoutWaitNumber>0){
    gtk_timeout_remove(timeoutWaitNumber);
  }
  // timeoutWaitNumber=gtk_timeout_add(1000,SelectionPolling,NULL);
  if (hist.tag.size()>0){
    DisplayHonmon(hist.Last());
  }
}

int WordBoxKeyPressEvent(GtkWidget* widget,GdkEventKey* event){
  if (event->type!=GDK_KEY_PRESS) {
    return FALSE;
  }
  switch(event->keyval){
  case GDK_Up:
    gtk_signal_emit_by_name (GTK_OBJECT(upButton), "clicked");
    return TRUE;
  case GDK_Down:
    gtk_signal_emit_by_name (GTK_OBJECT(downButton), "clicked");
    return TRUE;
  case GDK_Page_Up:
    gtk_signal_emit_by_name (GTK_OBJECT(pageUpButton), "clicked");
    return TRUE;
  case GDK_Page_Down:
    gtk_signal_emit_by_name (GTK_OBJECT(pageDownButton), "clicked");
    return TRUE;
  default:
    return FALSE;
  }
}

gint TagJump(GtkWidget* widget,gpointer itag){
  DICCHAR* pch=static_cast<DICCHAR*>(itag);
  TAG tag;
  tag=pch->Tag();
  if (pch->Attr().id==0x1f4a || pch->Attr().id==0x1f4b){
    TAG t=currentDict->RandomJump(tag);
    DisplayHonmon(t);
    hist.Append(t);
    /*
  } else if (pch->Attr().id==0x1f4b){
    TAG t=currentDict->NextJump(tag);
    DisplayHonmon(t);
    hist.Append(t);
    */
  } else if (pch->Attr().notText){
    Debug::DebugOut(Debug::TEMP,"MultiMedia: Code=%x SubCode=%x\n",pch->Code(),pch->Attr().id);
    DispatchMultiMedia(pch);
    return false;
  } else {
    Debug::DebugOut(Debug::TEMP,"Jump: %d/%d\n",tag.Block(),tag.Offset());
    DisplayHonmon(tag);
    hist.Append(tag);
  }
  return true;
}

gint SelectionPolling(GtkWidget* w){
  //  fprintf(stderr,"Timeout\n");

  static char buf[128];
  static int modifyFlag;
  EUC_STRING entry_text = _CE(gtk_entry_get_text(GTK_ENTRY(hiddenWordBox)));
  gtk_entry_set_text(GTK_ENTRY(hiddenWordBox),"");
  gtk_selection_convert(GTK_WIDGET(hiddenWordBox),GDK_SELECTION_PRIMARY,
			GDK_TARGET_STRING,GDK_CURRENT_TIME);

  const char *p0=buf,*p1=entry_text.c_str();
  int i;

  // to avoid bug ...  same as  strncmp
  for(i=0;i<128;i++){
    if (*p0==0 || *p1==0 || *p0!=*p1) break;
    p0++;
    p1++;
  }
  // fprintf(stderr,"Match %d\n",i);
  if (!(i==128 || (*p0==0 && *p1==0))){
    modifyFlag=1;
    strncpy(buf,entry_text.c_str(),128);
    //    fprintf(stderr,"Modify %s\n",entry_text);
  } else if (modifyFlag==1) {
    modifyFlag=0;
    gtk_entry_set_text(GTK_ENTRY(wordBox),_EC(entry_text).c_str());
    //    fprintf(stderr,"Select %s\n",entry_text);
  }
  return 0;
}
