// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#include "gui.h"
#include "global.h"

static GtkWidget *simpleMenu,*fullMenu;
GtkWidget *dictMenuBase1,*dictMenuBase2,*currentDictMenuBase,*currentDictMenu;
GtkWidget *indexMenuBase1,*indexMenuBase2,*currentIndexMenuBase;
GtkWidget *currentIndexMenu;
GtkWidget *configMenuBase1,*configMenuBase2,*currentConfigMenuBase;
GtkWidget *currentConfigMenu;
static bool initialized=false;

static GtkWidget* new_pixmap (char **data,GdkWindow *window,
			      GdkColor *background){
  GtkWidget *wpixmap;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  pixmap = gdk_pixmap_create_from_xpm_d(window,&mask,background,data);
  wpixmap = gtk_pixmap_new (pixmap, mask);
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
  return wpixmap;
}

// #include "folder.xpm"
#include "left.xpm"
#include "right.xpm"
#include "down.xpm"
// #include "quit.xpm"


static void IF_Dmy(gpointer data,guint action,GtkWidget* w){
  fprintf(stderr,"ToDo: ============= Menu '%s'",gtk_item_factory_path_from_widget(w));
}

static void MenuToggle(gpointer data,guint action,GtkWidget* w){
  if (!initialized) return;
  gtk_widget_ref(currentDictMenu);
  gtk_widget_ref(currentIndexMenu);
  gtk_widget_ref(currentConfigMenu);
  gtk_menu_item_remove_submenu(GTK_MENU_ITEM(currentDictMenuBase));
  gtk_menu_item_remove_submenu(GTK_MENU_ITEM(currentIndexMenuBase));
  gtk_menu_item_remove_submenu(GTK_MENU_ITEM(currentConfigMenuBase));
  preference.SetBoolValue(PP "full-menu-mode",action!=0);
  if (action!=0){
    gtk_widget_hide(simpleMenu);
    gtk_widget_show(fullMenu);
    currentDictMenuBase=dictMenuBase1;
    currentIndexMenuBase=indexMenuBase1;
    currentConfigMenuBase=configMenuBase1;
  } else {
    gtk_widget_show(simpleMenu);
    gtk_widget_hide(fullMenu);
    currentDictMenuBase=dictMenuBase2;
    currentIndexMenuBase=indexMenuBase2;
    currentConfigMenuBase=configMenuBase2;
  }
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(currentDictMenuBase),
  			    currentDictMenu);
  gtk_widget_unref(currentDictMenu);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(currentIndexMenuBase),
  			    currentIndexMenu);
  gtk_widget_unref(currentIndexMenu);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(currentConfigMenuBase),
  			    currentConfigMenu);
  gtk_widget_unref(currentConfigMenu);
}

static void WritePreference(void){
  preference.Write();
}

extern void MainMap();
extern void PanedMap();

static void SetSplitVertical(gpointer data,guint action,GtkWidget* w){
  if (!initialized) return;

  GtkWidget* box;
  if (action==0){
    // Horizontal
    box=gtk_hpaned_new();
    preference.SetBoolValue(PP "split-vertical",false);
  } else {
    // Vertical
    box=gtk_vpaned_new();
    preference.SetBoolValue(PP "split-vertical",true);
  }
  GtkWidget* w1=gtk_hbox_new(FALSE,0);
  GtkWidget* w2=gtk_hbox_new(FALSE,0);
  gtk_widget_reparent(resultScroll,w1);
  gtk_widget_reparent(resultText,w2);
  gtk_paned_add1(GTK_PANED(box),w1);
  gtk_paned_add2(GTK_PANED(box),w2);

  int ww=preference.GetIntValue("/ebdic/preference/geometry/hit-window-width");
  gtk_widget_set_usize(w1,ww,ww);

  gtk_widget_show_all(box);
  gtk_widget_destroy(hpaned);
  hpaned=box;
  gtk_box_pack_start(GTK_BOX(mainBox), hpaned, true, true,1);
  gtk_signal_connect (GTK_OBJECT (hpaned), "map",
                      GTK_SIGNAL_FUNC (PanedMap), NULL);
  gtk_widget_show (hpaned);
}

void PreferenceChanged(){
  MainMap();
  PanedMap();
  SetDicMenu();
  SetSplitVertical(NULL,preference.GetBoolValue(PP "split-vertical")?1:0,NULL);
  MenuToggle(NULL,preference.GetBoolValue(PP "full-menu-mode")?1:0,NULL);
}

static void ReadPreference(void){
  preference.Read();
  PreferenceChanged();
}

static void ResetPreference(void){
  preference.Reset();
  PreferenceChanged();
}

static void SetDicListType(gpointer data,guint action,GtkWidget* w){
  if (!initialized) return;

  char* str=gtk_item_factory_path_from_widget(w);
  if (str==NULL || strlen(str)==0) return;
  int result=str[strlen(str)-1]-'1';
  if (result<0 || result>2) return;
  preference.SetIntValue(PP "dict-list-type",result);
  SetDicMenu();
}

typedef GtkItemFactoryCallback ICB;
extern void CreateDictionaryTree(void);

static GtkItemFactoryEntry menuItems[]={
  { N_("/_File"),NULL,0,0,"<Branch>"},
  { N_("/File/_Open Catalog File"),"<control>O",
	ICB(FileSelect),0,NULL },
  { N_("/File/sep1"),NULL,0,0,"<Separator>" },
  { N_("/File/_Quit"),"<control>Q",ICB(winDestroy),0,NULL },

  { N_("/_Edit"),NULL,0,0,"<Branch>" },
  { N_("/Edit/Copy Text"),"<control>c",ICB(IF_Dmy),0,NULL},
  { N_("/Edit/Paste Search Keyword"),"<control>v",ICB(selection_paste),0,NULL},

  { N_("/_Dictionary"),NULL,0,0,"<Branch>" },
  { N_("/Dictionary/tearoff1"),NULL,0,0,"<Tearoff>" },

  { N_("/_Menu Index"),NULL,0,0,"<Branch>" },
  { N_("/Menu Index/tearoff1"),NULL,0,0,"<Tearoff>" },

  { N_("/_Preferences"),NULL,0,0,"<Branch>" },
  { N_("/Preferences/MenuType/_Simple Menu"),NULL,ICB(MenuToggle),0,"<RadioItem>" },
  { N_("/Preferences/MenuType/_Full Menu"),NULL,ICB(MenuToggle),1, 
                                             N_("/Preferences/MenuType/Simple Menu") },
  { N_("/Preferences/_DictList"),NULL,0,0,"<Branch>" },
  { N_("/Preferences/DictList/Type _1"),NULL,ICB(SetDicListType),1,"<RadioItem>" },
  { N_("/Preferences/DictList/Type _2"),NULL,ICB(SetDicListType),2,
                                              N_("/Preferences/DictList/Type 1") },
  { N_("/Preferences/DictList/Type _3"),NULL,ICB(SetDicListType),3,
                                              N_("/Preferences/DictList/Type 1") },
  { N_("/Preferences/_Layout"),NULL,0,0,"<Branch>" },
  { N_("/Preferences/Layout/_Horizontal"),NULL,ICB(SetSplitVertical),0,"<RadioItem>"},
  { N_("/Preferences/Layout/_Vertical"),  NULL,ICB(SetSplitVertical),1,
                                               N_("/Preferences/Layout/Horizontal")},
  { N_("/Preferences/Hit List"),NULL,ICB(IF_Dmy),0,NULL },
  { N_("/Preferences/sep1"),NULL,0,0,"<Separator>" },
  { N_("/Preferences/Reset Preferences"),NULL,ICB(ResetPreference),0,NULL },
  { N_("/Preferences/Load Preferences"),NULL,ICB(ReadPreference),0,NULL },
  { N_("/Preferences/Save Preferences"),NULL,ICB(WritePreference),0,NULL },
  { N_("/Preferences/sep2"),NULL,0,0,"<Separator>" },
  { N_("/Preferences/Config Dict"),NULL,ICB(CreateDictionaryTree),0,NULL },
  { N_("/_Help"),NULL,0,0,"<Branch>" },
  { N_("/_Help/_About This Program"),NULL,ICB(IF_Dmy),0,NULL }
};

static GtkItemFactoryEntry simpleMenuItems[]={
  { N_("/_File"),NULL,0,0,"<Branch>"},
  { N_("/File/_Open Catalog File"),"<control>O",
      ICB(FileSelect),0,NULL },
  { N_("/File/sep1"),NULL,0,0,"<Separator>" },
  { N_("/File/_Preferences"),NULL,0,0,"<Branch>" },
  { N_("/File/sep2"),NULL,0,0,"<Separator>" },
  { N_("/File/_Quit"),"<control>Q",ICB(winDestroy),0,NULL },

  { N_("/_Dictionary"),NULL,0,0,"<Branch>" },

  { N_("/_Menu Index"),NULL,0,0,"<Branch>" },
};


GtkItemFactory *ifact,*ifact2;
GtkWidget* CreateToolBar(GtkWidget* topWindow){
  GtkAccelGroup* a_gr=gtk_accel_group_new();
  ifact=gtk_item_factory_new(GTK_TYPE_MENU_BAR,"<main>",a_gr);
  gtk_object_set_data_full (GTK_OBJECT(topWindow),"<main>",ifact,
			    (GtkDestroyNotify)gtk_object_unref);
  gtk_accel_group_attach(a_gr, GTK_OBJECT(topWindow));
  int nMenuItems=sizeof(menuItems)/sizeof(GtkItemFactoryEntry);
  for(int i=0;i<nMenuItems;i++){
    menuItems[i].path=strdup(_(menuItems[i].path));
    if (menuItems[i].item_type != NULL) {
      menuItems[i].item_type=strdup(_(menuItems[i].item_type));
    }
  }
  gtk_item_factory_create_items(ifact,nMenuItems,menuItems, NULL);

  ifact2=gtk_item_factory_new(GTK_TYPE_MENU_BAR,"<simple>",a_gr);
  gtk_object_set_data_full (GTK_OBJECT(topWindow),"<simple>",ifact2,
			    (GtkDestroyNotify)gtk_object_unref);
  int nMenuItems2=sizeof(simpleMenuItems)/sizeof(GtkItemFactoryEntry);
  for(int i=0;i<nMenuItems2;i++){
    simpleMenuItems[i].path=strdup(_(simpleMenuItems[i].path));
  }
  gtk_item_factory_create_items(ifact2, 
			sizeof(simpleMenuItems)/sizeof(GtkItemFactoryEntry),
				simpleMenuItems, NULL);

  fullMenu=gtk_item_factory_get_widget (ifact, "<main>");
  simpleMenu=gtk_item_factory_get_widget (ifact2, "<simple>");

  dictMenuBase1=gtk_item_factory_get_item(ifact,_("<main>/Dictionary"));
  dictMenuBase2=gtk_item_factory_get_item(ifact2,_("<simple>/Dictionary"));
  currentDictMenuBase=dictMenuBase1;
  gtk_widget_destroy(gtk_item_factory_get_widget(ifact2,
						 _("<simple>/Dictionary")));
		
  currentDictMenu=gtk_item_factory_get_widget(ifact,_("<main>/Dictionary"));

  indexMenuBase1=gtk_item_factory_get_item(ifact,_("<main>/Menu Index"));
  indexMenuBase2=gtk_item_factory_get_item(ifact2,_("<simple>/Menu Index"));
  currentIndexMenuBase=indexMenuBase1;
  gtk_widget_destroy(gtk_item_factory_get_widget(ifact2,
						 _("<simple>/Menu Index")));
  currentIndexMenu=gtk_item_factory_get_widget(ifact,_("<main>/Menu Index"));


  configMenuBase1=gtk_item_factory_get_item(ifact,_("<main>/Preferences"));
  configMenuBase2=gtk_item_factory_get_item(ifact2,
					    _("<simple>/File/Preferences"));
  currentConfigMenuBase=configMenuBase1;
  gtk_widget_destroy(gtk_item_factory_get_widget(ifact2,
					 _("<simple>/File/Preferences")));
  currentConfigMenu=gtk_item_factory_get_widget(ifact,_("<main>/Preferences"));

  GtkWidget* bar=gtk_vbox_new(FALSE,0);

  gtk_box_pack_start_defaults(GTK_BOX(bar),fullMenu);
  gtk_box_pack_start_defaults(GTK_BOX(bar),simpleMenu);

  gtk_widget_show_all(bar);
  gtk_widget_hide(simpleMenu);

  /* Setup Radio Buttons */
  {
    if (preference.GetBoolValue(PP "full-menu-mode")) {
      gtk_check_menu_item_set_active
	(GTK_CHECK_MENU_ITEM(gtk_item_factory_get_item
	 (ifact,_("/Preferences/MenuType/Full Menu"))),TRUE);
    }
    int dlt=preference.GetIntValue(PP "dict-list-type");
    if (dlt>0 && dlt<3) {
      char buf[80];
      sprintf(buf,_("/Preferences/DictList/Type %d"),dlt+1);
      gtk_check_menu_item_set_active
	(GTK_CHECK_MENU_ITEM(gtk_item_factory_get_item
			     (ifact,buf)),TRUE);
    }
    if (preference.GetBoolValue(PP "split-vertical")) {
      gtk_check_menu_item_set_active
	(GTK_CHECK_MENU_ITEM(gtk_item_factory_get_item
	 (ifact,_("/Preferences/Layout/Vertical"))),TRUE);
    }    
  }
    
  
  // ********** Create Word Line **********
  GtkWidget* wordBar=gtk_hbox_new(FALSE,0);

  GtkWidget* prevButton=gtk_button_new();
  gtk_container_add(GTK_CONTAINER(prevButton),
			  new_pixmap(left_xpm,topWindow->window,
				     &topWindow->style->bg[GTK_STATE_NORMAL]));
  gtk_signal_connect(GTK_OBJECT(prevButton), "clicked",
		     GTK_SIGNAL_FUNC(hist_prev),prevButton);
  gtk_box_pack_start(GTK_BOX(wordBar),prevButton,FALSE,FALSE,0);

  GtkWidget* nextButton=gtk_button_new();
  gtk_container_add(GTK_CONTAINER(nextButton),
				  new_pixmap(right_xpm,topWindow->window,
				  &topWindow->style->bg[GTK_STATE_NORMAL]));
  gtk_signal_connect(GTK_OBJECT(nextButton), "clicked",
		     GTK_SIGNAL_FUNC(hist_next),nextButton);
  gtk_box_pack_start(GTK_BOX(wordBar),nextButton,FALSE,FALSE,0);


  GtkWidget* nextItemButton=gtk_button_new();
  gtk_container_add(GTK_CONTAINER(nextItemButton),
				  new_pixmap(down_xpm,topWindow->window,
				  &topWindow->style->bg[GTK_STATE_NORMAL]));
  gtk_signal_connect(GTK_OBJECT(nextItemButton), "clicked",
		     GTK_SIGNAL_FUNC(hist_next),nextItemButton);
  gtk_box_pack_start(GTK_BOX(wordBar),nextItemButton,FALSE,FALSE,0);


  dicTitle=gtk_label_new("");
  gtk_box_pack_start_defaults(GTK_BOX(wordBar),dicTitle);

  wordBox=gtk_entry_new_with_max_length(100);
  gtk_signal_connect(GTK_OBJECT(wordBox), "activate",
		     GTK_SIGNAL_FUNC(enter_callback),wordBox);
  gtk_signal_connect(GTK_OBJECT(wordBox), "changed",
		     GTK_SIGNAL_FUNC(edit_callback),wordBox);
  gtk_entry_set_text (GTK_ENTRY (wordBox), "");
  gtk_widget_set_usize( GTK_WIDGET (wordBox), 60, 30);

  gtk_signal_connect(GTK_OBJECT(wordBox),"event",
		     GTK_SIGNAL_FUNC(WordBoxKeyPressEvent),wordBox);

  gtk_box_pack_start_defaults(GTK_BOX(wordBar),wordBox);

  gtk_box_pack_start_defaults(GTK_BOX(bar),wordBar);
  gtk_widget_show_all(wordBar);

  GtkWidget* handle_box=gtk_handle_box_new();
  gtk_container_add(GTK_CONTAINER(handle_box),bar);
  gtk_widget_show(handle_box);
  initialized=true;
  return handle_box;
}

