// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#include <cstdio>
#include "def.h"

dword GetDWord(byte *buf) {
  return (buf[0]<<24)+(buf[1]<<16)+(buf[2]<<8)+buf[3];
}

dword GetDWord(FILE *fp){
  byte tmp[4];
  fread(tmp,1,4,fp);
  return GetDWord(tmp);
};

word GetWord(byte *buf) {
  return (buf[0]<<8)+buf[1];
}

word GetRWord(byte *buf) {
  return (buf[1]<<8)+buf[0];
}
dword GetRDWord(byte *buf) {
  return (buf[3]<<24)+(buf[2]<<16)+(buf[1]<<8)+buf[0];
}


dword GetWord(FILE *fp){
  byte tmp[2];
  fread(tmp,1,2,fp);
  return GetWord(tmp);
};

bool PutDWord(dword d,byte *buf){
  if (buf==NULL) return false;
  buf[0]=(d>>24)&255;
  buf[1]=(d>>16)&255;
  buf[2]=(d>>8)&255;
  buf[3]=d&255;
  return true;
}

bool PutDWord(dword d,FILE *fp){
  byte buf[4];
  if (fp==NULL) return false;
  PutDWord(d,buf);
  if (fwrite(buf,1,4,fp)!=4) return false;
  return true;
}

bool PutWord(word d,byte *buf){
  if (buf==NULL) return false;
  buf[0]=(d>>8)&255;
  buf[1]=d&255;
  return true;
}

bool PutWord(word d,FILE *fp){
  byte buf[2];
  if (fp==NULL) return false;
  PutWord(d,buf);
  if (fwrite(buf,1,2,fp)!=2) return false;
  return true;
}

bool PutRDWord(dword d,byte *buf){
  if (buf==NULL) return false;
  buf[3]=(d>>24)&255;
  buf[2]=(d>>16)&255;
  buf[1]=(d>>8)&255;
  buf[0]=d&255;
  return true;
}

bool PutRDWord(dword d,FILE *fp){
  byte buf[4];
  if (fp==NULL) return false;
  PutRDWord(d,buf);
  if (fwrite(buf,1,4,fp)!=4) return false;
  return true;
}

bool PutRWord(word d,byte *buf){
  if (buf==NULL) return false;
  buf[1]=(d>>8)&255;
  buf[0]=d&255;
  return true;
}

bool PutRWord(word d,FILE *fp){
  byte buf[2];
  if (fp==NULL) return false;
  PutRWord(d,buf);
  if (fwrite(buf,1,2,fp)!=2) return false;
  return true;
}

int GetBCD(byte* buf,int nDigits){
  int retValue=0;
  for(int i=0;i<nDigits;i++){
    retValue*=10;
    if ((i & 1)==0){
      retValue+=(buf[i/2]>>4)&15;
    } else {
      retValue+=buf[i/2] & 15;
    }
  }
  return retValue;
}

