// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#include "tag.h"

#ifndef NULL
#define NULL 0
#endif

TAG::TAG(byte* data){
  block=GetDWord(data);
  offset=GetWord(data+4);
};

TAG::TAG(const TAG& t)
:block(t.block),offset(t.offset)
{};

const TAG& TAG::operator=(const TAG& t) {
  block=t.block;
  offset=t.offset;
  return *this;
};

void TAG::Block(int p){
  block=p;
  return;
};

void TAG::Offset(int o){
  offset=o;
  return;
};

int TAG::Offset() const {
  return offset;
};

int TAG::Block() const {
  return block;
};

bool operator == (const TAG& t,const TAG& t2){
  if (t.block==t2.block && t.offset==t2.offset) return true;
  return false;
};

bool operator != (const TAG& t,const TAG& t2){
  if (t.block!=t2.block || t.offset!=t2.offset) return true;
  return false;
};

bool operator < (const TAG& t,const TAG& t2){
  if (t.block<t2.block) return true;
  if (t.block==t2.block && t.offset<t2.offset) return true;
  return false;
};

