// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999-2000 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#include <cstdio>
#include <cstdlib>
#include "def.h"
#include "codeconv.h"

int main(int argc,char** argv){
  char buf[2048],buf2[2048];
  while(argc>1){

    int nBooks;

    argc--;
    argv++;
    FILE* fp=fopen(argv[0],"r");
    if (fp==NULL) continue;
    fread(buf,1,2048,fp);
    fclose(fp);
    byte* ubuf=reinterpret_cast<byte*>(buf);
    
    nBooks=GetWord(ubuf);

    printf("Ͽ̾ե PATH=%s\n",argv[0]);
    printf("  Ͽҿ = %d\n",nBooks);
    ubuf+=2;
    printf("  ͽΰ1 = ");
    for(int i=0;i<14;i++){
      printf("%02x ",*(ubuf++));
    }
    printf("\n");

    for(int i=0;i<nBooks;i++){
      byte* bookTop=ubuf;
      printf("  ҥե %d\n",i);
      printf("  ͽΰ2 = %02x %02x\n",ubuf[0],ubuf[1]);
      ubuf+=2;
      memcpy(buf2,reinterpret_cast<char*>(ubuf),80);
      ubuf+=80;
      buf2[80]=0;
      for(int j=79;j>0;--j){
	if (buf2[j]==0x20) {
	  buf2[j]=0;
	} else {
	  break;
	}
      }
      printf("  ̾ = %s\n",CODECONV::Jis2Euc(JIS_STRING(buf2)).c_str());
      memcpy(buf2,reinterpret_cast<char*>(ubuf),8);
      ubuf+=8;
      buf2[8]=0;
      printf("  ҥǥ쥯ȥ̾ = %s\n",buf2);
      printf("  ҥեǥ쥯ȥ = %d\n",GetDWord(ubuf));
      ubuf+=4;
      printf("  ҴϿ = %d\n",GetWord(ubuf));
      ubuf+=2;
      printf("  ͽΰ3 = %02x %02x %02x %02x\n",
	     ubuf[0],ubuf[1],ubuf[2],ubuf[3]);
      ubuf+=4;
      for(int j=0;j<8;j++){
	memcpy(buf2,reinterpret_cast<char*>(ubuf),8);
	ubuf+=8;
	buf2[8]=0;
	printf("   = %s\n",buf2);
      }
      printf("\n");

      byte* ubuf2=bookTop+164*nBooks;

      for(int i=0;i<164;i+=12){
	printf("      "); 
	for(int k=0;k<12;k++){
	  if (i+k<164){
	    printf("%02x ",ubuf2[i+k]);
	  } else {
	    printf("   ");
	  }
	}
	printf("   ");
	for(int k=0;k<12;k++){
	  if (i+k<164){
	    if (ubuf2[i+k]>=0x20 & ubuf2[i+k]<0x7f) {
	      putchar(ubuf2[i+k]);
	    } else {
	      printf(".");
	    }
	  } else {
	    printf(" ");
	  }
	}
	printf("\n");
      }
      printf("\n\n");
    }
  }
  exit(0);
}
