#include <cstdio>
#include <cstring>
#include "def.h"
#include "bfile.h"

const int MAX_SECTOR=100*64*75;

bool FindTag(int len,BlockIO* bf,bool fullMode){
  int isEBXA=false;
  int maxEBXALBA=0;
  int flag[MAX_SECTOR];
  for(int i=0;i<MAX_SECTOR;i++) flag[i]=0;
  for(int i=0;i<len;i++){
    TAG t=bf->Tell();
    int ch=bf->GetByte();
    //    fprintf(stderr," %02x\n",ch);
    if (ch==0x1f){
      i++;
      int ch2=bf->GetByte();
      //      fprintf(stderr,"   %02x\n",ch2);
      switch(ch2){
      case 0x33:
	isEBXA=true;
	break;
      case 0x53:
	if (isEBXA==true){
	  i+=8;
	  int type=bf->GetWord();
	  int sMin=bf->GetBCD(2);
	  int sSec=bf->GetBCD(2);
	  int sFrame=bf->GetBCD(2);
	  int eMin=bf->GetBCD(2);
	  int eSec=bf->GetBCD(2);
	  int eFrame=bf->GetBCD(2);
	  int sLBA=(sMin*60+sSec)*75+sFrame;
	  int eLBA=(eMin*60+eSec)*75+eFrame;
  //	  fprintf(stderr,"%d:%d\n",bf->Tell().Block(),bf->Tell().Offset());
	  printf("S:EB:%06d:%06d:%06d\n",type,
		 sLBA,eLBA);
	  if (!fullMode){
	    if (eLBA>maxEBXALBA) maxEBXALBA=eLBA;
	    for(int j=sLBA;j<=eLBA;j+=16){
	      flag[j]++;
	    }
	  }
	}
	isEBXA=false;
	break;
      case 0x4d:
      case 0x3c:
	{
	  int type=bf->GetWord();
	  int unknown=bf->GetBCD(4);
	  int x=bf->GetBCD(4);
	  int y=bf->GetBCD(4);
	  int w=bf->GetBCD(4);
	  int h=bf->GetBCD(4);
	  int block=bf->GetBCD(8);
	  int offset=bf->GetBCD(4);
	  unsigned char ubuf[4];
	  
	  if (!fullMode){
	    TAG t=bf->Tell();
	    bf->Seek(block,offset);
	    bf->Read(ubuf,4);
	    bf->Read(ubuf,4);
	    bf->Read(ubuf,4);
	    bf->Seek(t);
	  }
	  
	  printf("B:EP:(%08d,%04d):1f%02x:%04x:%04d:(%4d,%4d):"
		 "w%4d:h%4d:(%08d:%04d):%02X%02X\n",
		 t.Block(),t.Offset(),ch2,
		 type,unknown,x,y,w,h,block,offset,
		 ubuf[0],ubuf[1]
		 );
	  fflush(stdout);
	}
	break;
      default:
	break;
      }
    } else if (ch == 0xff){
      TAG tt=bf->Tell();
      unsigned char ubuf[3];
      ch=bf->Read(ubuf,3);
      if (ubuf[0]==0xd8 && ubuf[1]==0xff && ubuf[2]==0xe0){
	printf("JPEG @ %08X:%04X\n",tt.Block(),tt.Offset());
      } else {
	bf->Seek(tt);
      }
    } else if (ch == 'J'){
      TAG tt=bf->Tell();
      unsigned char ubuf[3];
      ch=bf->Read(ubuf,3);
      if (ubuf[0]=='F' && ubuf[1]=='I' && ubuf[2]=='F'){
	printf("JPEG @ %08X:%04X\n",tt.Block(),tt.Offset());
      } else {
	bf->Seek(tt);
      }
    }
    //    if ((i&0xffff)==0) fprintf(stderr,"%d/%d\n",i>>11,size);
  }
  return true;
}

int main(int argc,char** argv){
  unsigned char ubuf[cBlockSize];
  char *buf=reinterpret_cast<char*>(ubuf);
  bool isStream=false;
  bool fullMode=false;
  int start,size,len;

  if (argv[1][0]=='-' && argv[1][1]=='f') {
    fullMode=true;
    argv++;
  }

  BlockIO *bf=OpenDict(argv[1]);
  bf->ReadBlock(1,ubuf);

  if (fullMode){
    start=1;
    size=999999;
    bf->Seek(1,0);
  } else if (strncmp(buf,"WING",4)==0){
    isStream=true;
    start=1;
    size=GetRDWord(ubuf+4);
    bf->Seek(1,12);
  } else {
    int nIndex=GetWord(ubuf);
    for(int i=0;i<nIndex;i++){
      if (buf[(i+1)*16]==0) {
	start=GetDWord(ubuf+(i+1)*16+2);
	size=GetDWord(ubuf+(i+1)*16+6);
	fprintf(stderr,"Honmon Start,End = %d,%d\n",start,start+size);
      };
    }
    bf->Seek(start,0);
    len=size*cBlockSize;
  }

  if (isStream){
    fprintf(stderr,"size=%d\n",size);
    while(bf->LTell()<size){
      TAG t=bf->Tell();
      bf->Read(ubuf,4);
      buf[4]=0;
      fprintf(stderr,"%s\n",buf);
      if (strncmp(buf,"next",4)==0){
	bf->GetDWord();
	int type=bf->GetWord();
	int n0=bf->GetWord();
	TAG t0=bf->GetBCDTag();
	int n1=bf->GetWord();
	TAG t1=bf->GetBCDTag();
	int n2=bf->GetWord();
	TAG t2=bf->GetBCDTag();
	int n3=bf->GetWord();
	printf("stream:next:BP:(%06d,%04d):%04x:(%06d,%04d):"
	       "(%06d,%04d):(%06d,%04d)\n",
	       t.Block(),t.Offset(),
	       type,
	       t0.Block(),t0.Offset(),
	       t1.Block(),t1.Offset(),
	       t2.Block(),t2.Offset()
	       );
	if (t0==TAG(0,0)) break;
	bf->Seek(t0);
	continue;
      } else if (strncmp(buf,"fmt ",4)==0){
	break;
      } else if (strncmp(buf,"scrp",4)!=0){
	int j=bf->GetRDWord();
	j+=bf->LTell();
	bf->Seek(j);
	fprintf(stderr,"%x\n",bf->LTell());
	continue;
      } 

      int len=bf->GetRDWord();
      fprintf(stderr,"scrp %x / %d\n",bf->LTell(),len);
      int next=len+bf->LTell();
      FindTag(len,bf,fullMode);
      bf->Seek(next);
    }
  } else {
    FindTag(len,bf,fullMode);
  }

  delete bf;
}

