/*
    Copyright (c) 2006-2008 by amdfanatyk <amdfanatyk@o2.pl>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "kmlistview.h"
#include "types.h"

#include <qcursor.h>

KMListView::KMListView(QWidget * parent, const char * name) : KListView(parent, name)
{
	setAcceptDrops(true);
	viewport()->setAcceptDrops(true);

	dndPerm = false;
}

KMListView::~KMListView()
{
}

void KMListView::setSelected(QListViewItem * item, bool selected)
{
	if (selected)
		setCurrentItem(item);

	KListView::setSelected(item, selected);
}

void KMListView::selectAll()
{
	KListView::selectAll(true);
}

void KMListView::clearSelection()
{
	QListViewItems items = selectedItems();
	QListViewItemsIterator it(items);
	QListViewItem * item = 0;

	while ((item = it.current()))
	{
		setSelected(item, false);
		++it;
	}
}

QListViewItem * KMListView::selectedItem() const
{
	return selectedItems().getFirst();
}

bool KMListView::acceptDrag(QDropEvent * event) const
{
	return QTextDrag::canDecode(event);
}

void KMListView::contentsMousePressEvent(QMouseEvent * e)
{
	switch (e->button())
	{
		case Qt::LeftButton:
			if ((!itemAt(contentsToViewport(e->pos()))) && (childCount()))
				return;

			if ((int)selectedItems().count() != childCount())
			{
				if ((e->state() & Qt::ControlButton) != Qt::ControlButton)
					dndPerm = true;
			}
			else
				clearSelection();
		break;
		case Qt::RightButton:
			emit rightMouseButtonClicked(QCursor::pos());
			return;
		break;
		default:
		break;
	}

	KListView::contentsMousePressEvent(e);

	if (!selectedItems().count())
		setSelected(currentItem(), true);
}

void KMListView::contentsMouseReleaseEvent(QMouseEvent * e)
{
	QListViewItem * item = itemAt(contentsToViewport(e->pos()));

	if (!item)
		goto skip;

	if (dndPerm)
	{
		bool move = true;

		QListViewItems items = selectedItems();
		QListViewItemsIterator it(items);
		QListViewItem * current = 0;

		while ((current = it.current()))
		{
			if (item == current)
			{
				move = false;
				break;
			}

			++it;
		}

		if (move)
			emit mouseButtonReleased(e->pos());
	}

skip:
	dndPerm = false;

	viewport()->setCursor(Qt::ArrowCursor);
}

void KMListView::contentsMouseMoveEvent(QMouseEvent * e)
{
	if (!dndPerm)
		return;

	emit dragging();

	viewport()->setCursor(Qt::UpArrowCursor);

	int mPos = contentsToViewport(e->pos()).y();

	if ((mPos >= 0) && (mPos <= 20))
		scrollBy(0, -10);
	else
	{
		if ((mPos <= height()) && (mPos >= height() - 60))
			scrollBy(0, 10);
	}
}

void KMListView::keyPressEvent(QKeyEvent * e)
{
	emit keyPressed(e);
}
