#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#define LOG_DOMAIN "gvn-remove"

#include <gtk/gtk.h>
#include "gvn-addremove.h"

#define FORCE           GTK_TOGGLE_BUTTON(gnubversion_get_widget("force") )

const char *appname = "gvn-remove";
const char *appwidget_name = "removeApp";
const char *get_initial_progressmessage()
{
    return _("Preparing Removal...");
}

const char *get_fileselector_title(void)
{
    return _("Paths to Remove:");
}

const char *get_tick_column_title(void)
{
    return _("Remove");
}

void set_gui_options(struct baton *baton)
{
    gtk_toggle_button_set_active ( FORCE, baton->force);
}

void get_gui_options(struct baton *baton)
{
    baton->force = gtk_toggle_button_get_active ( FORCE );
}

/* Decides which files should be included in the FileSelector */
gboolean include_func (const gchar *path, 
                      svn_wc_status2_t *status, 
                      gpointer user_data)
{
    switch (status->text_status)
    {
        case svn_wc_status_none: /** does not exist */
        case svn_wc_status_added: /** is scheduled for addition */
        case svn_wc_status_deleted: /** scheduled for deletion */
        case svn_wc_status_external: /** an unversioned path populated by an svn:externals property */
        case svn_wc_status_incomplete: /** a directory doesn't contain a complete entries list */
        case svn_wc_status_ignored: /** is unversioned but configured to be ignored */
        case svn_wc_status_unversioned: /** is not a versioned thing in this wc */
            return FALSE;
        case svn_wc_status_normal: /** exists, but uninteresting */
        case svn_wc_status_missing: /** under v.c., but is missing */
        case svn_wc_status_replaced: /** was deleted and then re-added */
        case svn_wc_status_modified: /** text or props have been modified */
        case svn_wc_status_merged: /** local mods received repos mods */
        case svn_wc_status_conflicted: /** local mods received conflicting repos mods */
        case svn_wc_status_obstructed: /** an unversioned resource is in the way of the versioned resource */
            return TRUE;

        default:
            g_warning("Unknown text status %d - ignoring file %p", status->text_status, path);
            return FALSE;
    }
}

GOptionEntry *get_option_entries(
        const gchar ***args,
        struct baton *baton)
{
    GOptionEntry option_entries[] = 
    {
        /* ... your application's command line options go here ... */
        {
            "force", 0,
            0, 
            G_OPTION_ARG_NONE,
            &baton->force,
            _("force operation to run"),
            NULL
        },
        { G_OPTION_REMAINING, 0, 0, G_OPTION_ARG_FILENAME_ARRAY,
          args,
          "Special option that collects any remaining arguments for us" },
        { NULL }
    };

    GOptionEntry *retval = g_malloc(sizeof(option_entries));

    memcpy(retval, option_entries, sizeof(option_entries));

    return retval;
}

svn_error_t * do_add_remove(
    apr_array_header_t *targets,
    struct baton *baton)
{
    return svn_client_delete2( NULL,
                                targets,
                                baton->force,
                                gnubversion_svn_client_ctx,
                                gnubversion_apr_pool);
}
