#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#define G_LOG_DOMAIN "main"

#include <gnome.h>
#include <glade/glade.h>
#include <assert.h>
#include "gvn-addremove.h"

#define MAIN_WINDOW gnubversion_get_widget (appwidget_name)
#define FILESELECTOR GNUBVERSION_FILESELECTOR (gnubversion_get_widget ("fileselector"))

GLADE_CALLBACK void
okButton_clicked_cb ( GtkWidget *widget, gpointer userdata );

static void fileselector_ticks_changed(
        GnubVersionFileSelector *selector, 
        GnubVersionFileSelectorStore *store, 
        gpointer data);

static void
update_okButton(GtkButton *widget, GnubVersionFileSelectorStore *store);

static void 
on_progresswindow_closed (GnubVersionProgressWindow *window, gpointer data);

static void 
on_task_finished (GnubVersionProgressWindow *window, gboolean successfull, gpointer data);

int 
main (
    int argc, 
    char **argv, 
    char **env
    )
{
    int exitcode = 0;
    const gchar **args;
    struct baton baton;

    #ifdef ENABLE_NLS
        bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
        textdomain (PACKAGE);
    #endif

    baton.ignore_externals = FALSE;
    baton.no_ignore = FALSE;
    baton.non_recursive = FALSE;
    baton.force = FALSE;
    baton.recursive = FALSE;

    args = NULL;

    GOptionEntry *option_entries;
    option_entries = get_option_entries(&args, &baton);

    GOptionContext *option_context;
    GnomeProgram *my_app;

    option_context = g_option_context_new ( "filename [ filename ...]" );

    g_option_context_add_main_entries (option_context, option_entries, GETTEXT_PACKAGE);

    g_option_context_add_group ( option_context, gnubversion_get_option_group() );

    my_app = gnome_program_init( appname, VERSION,
                                 LIBGNOMEUI_MODULE, argc, argv,
                                 GNOME_PARAM_GOPTION_CONTEXT, option_context,
                                 GNOME_PARAM_NONE);
    gnubversion_init_with_glade (appname);

    /* Initialize the options */
    set_gui_options(&baton);

    /* Initialize the list of paths to update */
    GnubVersionFileSelectorStore *model;

    model = gnubversion_fileselectorstore_new ();

    gnubversion_fileselectorstore_populate_from_array (
        model, 
        args,
        NULL,
        FALSE, /* do_update */
        FALSE, /* ignore_externals */
        TRUE, /* recursive */
        FALSE, /* no ignore */
        TRUE,  /* get_all */
        include_func,  /* include */
        NULL   /* user_data */
        );

    GtkButton *okButton ;
    okButton = GTK_BUTTON (gnubversion_get_widget ("okButton"));

    update_okButton (okButton, model);

    GnubVersionFileSelector *fileselector;
    fileselector = FILESELECTOR;

    gnubversion_fileselector_set_model (fileselector, model);
    gnubversion_fileselector_set_label_text (fileselector, get_fileselector_title());
    gnubversion_fileselector_set_tick_column_title (fileselector, get_tick_column_title());
    gnubversion_fileselector_connect__ticks_changed (fileselector, fileselector_ticks_changed, okButton);

    gtk_widget_show_all (MAIN_WINDOW);

    if (gnubversion_get_options()->non_interactive)
        okButton_clicked_cb( gnubversion_get_widget("okButton"), NULL);

    gvn_debug("Entering gtkmain");
    gtk_main();
    gvn_debug("gtkmain done");

    gnubversion_shutdown ();
    g_object_unref ( my_app );
    return exitcode;
}

static void fileselector_ticks_changed(
        GnubVersionFileSelector *selector, 
        GnubVersionFileSelectorStore *store, 
        gpointer data)
{
    update_okButton (GTK_BUTTON (data), store);
}

static void
update_okButton(GtkButton *button, GnubVersionFileSelectorStore *store)
{
    gtk_widget_set_sensitive (GTK_WIDGET (button), gnubversion_fileselectorstore_count_ticks (store) > 0);
}

GLADE_CALLBACK void
okButton_clicked_cb ( GtkWidget *widget, gpointer userdata )
{
    gvn_debug("OK button clicked");

    struct baton *baton = g_malloc(sizeof(struct baton));

    baton->store = gnubversion_fileselector_get_model (FILESELECTOR);

    {
        const char **files;
        files = gnubversion_fileselectorstore_get_ticked_fullnames (baton->store);

        const char **f;
        for (f = files; *f != NULL; f++)
        {
            gvn_debug("filename: %s", *f);
        }
    }

    get_gui_options(baton);

    gtk_widget_hide (MAIN_WINDOW);

    baton->progressWindow = gnubversion_progresswindow_new( get_initial_progressmessage());
    gnubversion_auth_baton->progressWindow = baton->progressWindow;

    gnubversion_progresswindow_connect__window_closed(baton->progressWindow, on_progresswindow_closed, NULL);

    if (gnubversion_get_options()->non_interactive)
        gnubversion_progresswindow_connect__task_finished(baton->progressWindow, on_task_finished, NULL);

    gtk_widget_show ( GTK_WIDGET (baton->progressWindow));

    GError *err = NULL;
    GThread *thread;
    thread = g_thread_create(worker_thread_main, baton, TRUE, &err);

    if (thread == NULL)
    {
        g_object_unref(baton->progressWindow);
        g_free(baton);

        gnubversion_error(NULL, _("Cannot create worker thread: %s"), err->message);
        gtk_widget_show (MAIN_WINDOW);
        g_error_free(err);
    }
}

static void 
on_progresswindow_closed (GnubVersionProgressWindow *window, gpointer data)
{
    gtk_main_quit();
}

/* This function only gets used in non-interactive mode */
static void 
on_task_finished (GnubVersionProgressWindow *window, gboolean successfull, gpointer data)
{
    gtk_main_quit();
}
