#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#define G_LOG_DOMAIN "commit_list"
#include "gvn-commit.h"

#include <gnubversion.h>

#include <assert.h>
#include <string.h>


struct status_baton {
    GnubVersionFileSelectorStore *store;
    char *arg_path;
};

static gboolean
do_include (const gchar *path,
            svn_wc_status2_t *status,
            gpointer user_data)
{
    if (!statuskind_committable(status->text_status) && !statuskind_committable(status->prop_status))
        return FALSE;
    else
        return TRUE;
}

static GnubVersionFileSelectorStore *
init_model (gboolean non_recursive, const char **args)
{
    GnubVersionFileSelectorStore *store;

    store = gnubversion_fileselectorstore_new();

    // FIXME: Do not ignore return code here...
    gnubversion_fileselectorstore_populate_from_array(store, 
                                                args,
                                                NULL,
                                                FALSE, /* do_update */
                                                FALSE, /* FIXME: ignore_externals */
                                                !non_recursive,
                                                FALSE, /* no_ignore */
                                                FALSE, /* get_all */
                                                do_include,
                                                NULL);
    return store;
}

GnubVersionFileSelectorStore *
commit_list_init(gboolean non_recursive, const char **args)
{
    GnubVersionFileSelectorStore *store;

    store = init_model (non_recursive, args);

    GnubVersionFileSelector *selector = GNUBVERSION_FILESELECTOR(gnubversion_get_widget ("fileSelector"));
    gnubversion_fileselector_set_model(selector, store);

    // let the view hold a reference. we're getting rid of ours
    g_object_unref (G_OBJECT (store));

    return store;
}
