#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include "gnubversion-private.h"
#include "gnubversion-relevant.h"
#include "gnubversion-status.h"
#include "gnubversion-gerror.h"

#include <string.h>

static guint32 
relevant(enum svn_wc_status_kind status)
{
    guint32 actions = GVN_ACTION_NONE;

    actions |= GVN_ACTION_STATUS;
    actions |= GVN_ACTION_CLEANUP;
    actions |= GVN_ACTION_SWITCH;
    actions |= GVN_ACTION_MKDIR;

    switch (status)
    {
        case svn_wc_status_normal:
            actions |= GVN_ACTION_BLAME;
            actions |= GVN_ACTION_COPY;
            actions |= GVN_ACTION_COMMIT;
            actions |= GVN_ACTION_DELETE;
            actions |= GVN_ACTION_LOG;
            actions |= GVN_ACTION_MERGE;
            actions |= GVN_ACTION_MOVE; 
            actions |= GVN_ACTION_UPDATE; 
            actions |= GVN_ACTION_PROPERTIES; 
            break;
        case svn_wc_status_added:
            actions |= GVN_ACTION_COMMIT;
            actions |= GVN_ACTION_UPDATE; 
            actions |= GVN_ACTION_REVERT; 
            actions |= GVN_ACTION_PROPERTIES; 
            break;
        case svn_wc_status_modified:
            actions |= GVN_ACTION_COMMIT;
            actions |= GVN_ACTION_UPDATE; 
            actions |= GVN_ACTION_REVERT; 
            actions |= GVN_ACTION_BLAME; 
            actions |= GVN_ACTION_DIFF; 
            actions |= GVN_ACTION_LOG; 
            actions |= GVN_ACTION_MERGE; 
            actions |= GVN_ACTION_PROPERTIES; 
            break;
        case svn_wc_status_deleted:
            actions |= GVN_ACTION_COMMIT;
            actions |= GVN_ACTION_UPDATE; 
            actions |= GVN_ACTION_REVERT; 
            actions |= GVN_ACTION_BLAME;
            actions |= GVN_ACTION_LOG;
            break;
        case svn_wc_status_conflicted:
            actions |= GVN_ACTION_BLAME;
            actions |= GVN_ACTION_DIFF;
            actions |= GVN_ACTION_LOG;
            actions |= GVN_ACTION_UPDATE; 
            actions |= GVN_ACTION_RESOLVED; 
            actions |= GVN_ACTION_REVERT; 
            actions |= GVN_ACTION_PROPERTIES; 
            break;
        case svn_wc_status_merged:
            actions |= GVN_ACTION_COMMIT;
            actions |= GVN_ACTION_BLAME;
            actions |= GVN_ACTION_DIFF;
            actions |= GVN_ACTION_LOG;
            actions |= GVN_ACTION_UPDATE; 
            actions |= GVN_ACTION_REVERT; 
            actions |= GVN_ACTION_PROPERTIES; 
            break;
        case svn_wc_status_unversioned:
            actions |= GVN_ACTION_ADD;
            break;
        case svn_wc_status_ignored:
            break;
        default:
            break;
    }
    return actions;
}

guint32
gnubversion_relevant_actions_status(
    enum svn_wc_status_kind text_status, 
    enum svn_wc_status_kind prop_status
    )
{
    return relevant(text_status) | relevant(prop_status);
}

guint32 
gnubversion_relevant_actions_uri(const char *uri)
{
    guint32 actions;
    
    GnubVersionStatus *gvs = NULL;

    actions = GVN_ACTION_NONE;
    gvs = gnubversion_status_new_from_uri(uri);

    if (gvs->error) {
        if ( (gvs->error->domain == GNUBVERSION_QUARK_SVN )
            && (gvs->error->code == SVN_ERR_WC_NOT_DIRECTORY)) {
            actions |= GVN_ACTION_CHECKOUT;
            actions |= GVN_ACTION_IMPORT;
        }
    } else {
        // FIXME: Free *gvs...
        actions |= relevant(gvs->status->text_status);
        actions |= relevant(gvs->status->prop_status);
    }
        
    return actions;
}

GString *gnubversion_relevant_string(guint32 relevant)
{
    GString *str = g_string_new("[");
    gboolean first = TRUE;
    gnubversion_action_map_t *i;

    for (i = gnubversion_action_map; i->mask != 0; i++)
    {
        if (relevant & i->mask)
        {
            if (!first)
                str = g_string_append(str, ", ");

            first = FALSE;
            str = g_string_append(str, i->str);
        }
    }
    str = g_string_append(str, "]");
    return str;
}
