#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include "gnubversion-private.h"
#include "gnubversion-revision.h"

#include <glib/gi18n.h>

GString *gnubversion_revision_to_string(svn_revnum_t revision)
{
    GString *str = NULL;

    if (revision == SVN_IGNORED_REVNUM) {
        str = g_string_new(_("n/a"));
    } else if (revision == SVN_INVALID_REVNUM) {
        str = g_string_new(_("n/a"));
    } else if (SVN_IS_VALID_REVNUM(revision)) {
        str = g_string_new("");
        g_string_printf(str, "%"SVN_REVNUM_T_FMT, revision);
    } else {
        // We have a strange revision number: It is not invalid. It is not ignored. 
        // And it is not valid either!?
        str = g_string_new(_("weird revnum"));
    }
    return str;
}
