/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "honokatimer.h"
#include <signal.h>
#include <sys/wait.h>

using namespace Honoka;

HonokaTimer::HonokaTimer()
{
    bef = 1;
    eventCount = 0;
    timer_pid = -1;
    scim::HelperInfo info(
        HONOKA_TIMER_UUID,
        "Honoka Timer",
        "",
        "Honoka Timer",
        SCIM_HELPER_STAND_ALONE);
    String display = getenv("DISPLAY");
    id = agent.open_connection(info,display);
}


HonokaTimer::~HonokaTimer()
{
    if (id != -1) agent.close_connection();
    if (timer_pid > 0) {
        kill(timer_pid,SIGKILL);
        wait(NULL);
    }
}

HonokaTimer * HonokaTimer::_self = 0;



/*!
    \fn HonokaTimer::self()
 */
HonokaTimer * HonokaTimer::self()
{
    if (!_self) {
        _self = new HonokaTimer();
        _self->exec();
    }
    return _self;
}


/*!
    \fn HonokaTimer::destruct()
 */
void HonokaTimer::destruct()
{
    if (_self == 0) return;
    delete _self;
    _self = 0;
}


/*!
    \fn HonokaTimer::timer()
 */
void HonokaTimer::timer()
{
    Transaction trans;
    uint32 counter = 1;
    pid_t p = getpid();
    while(1) {
        usleep(HONOKA_TIMER_INTERVAL);
        trans.clear();
        trans.put_command(HONOKA_TRANS_TIMER);
        trans.put_data((uint32)p);
        trans.put_data(counter);
        agent.send_imengine_event(-1,"8bb03c1c-db6c-41b1-91bd-b7fb7dd70343",trans);
        counter ++;
        if (counter >= 0xffffffff) counter = 1; // んー、なんだかなぁ。
    }
}


/*!
    \fn HonokaTimer::exec()
 */
void HonokaTimer::exec()
{
    timer_pid = fork();
    if (timer_pid == 0) timer();
}


/*!
    \fn HonokaTimer::decode(const Transaction &trans)
 */
uint32 HonokaTimer::decode(const Transaction &trans)
{
    TransactionReader reader(trans);
    int cmd;
    if (reader.get_command(cmd)) {
        if (cmd == HONOKA_TRANS_TIMER) {
            uint32 p,c;
            reader.get_data(p);
            reader.get_data(c);
            if (p != (uint32)timer_pid) return 0;
            return c;
        }
    }
    return 0;
}


/*!
    \fn HonokaTimer::eventFilter(const Transaction &trans)
 */
vector<int> HonokaTimer::eventFilter(const Transaction &trans)
{
    vector<int> res;
    uint32 c = decode(trans);
    if (c == 0) return res;
    for(uint32 i = bef;i != c;i ++) {
        multimap<uint32,int>::iterator it;
        while(events.count(i)) {
            it = events.find(i);
            res.push_back(it->second);
            events.erase(it);
        }
        if (i == 0xffffffff) i = 0;
    }
    bef = c;
    return res;
}


/*!
    \fn HonokaTimer::appendDelayEvent(uint32 delay)
 */
int HonokaTimer::appendDelayEvent(uint32 delay)
{
    uint32 t;
    eventCount ++;
    if ((0xffffffff - bef) <= delay) t = delay - (0xffffffff - bef) + 1;
    else t = bef + delay;
    events.insert(pair<uint32,int>(t,eventCount));
    return eventCount;
}
