/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MULTICONVERTOR_H
#define MULTICONVERTOR_H

#include <vector>
#include <set>
#include <convertor.h>
#include <honoka_imengine.h>

/**
@author TAM (Teppei Tamra)
*/

class HonokaInstance;

class MultiResultList
{
public:
    Convertor *convertor;
    ResultList list;
};

class MultiConvertor : public Convertor
{
public:
    MultiConvertor(ConfigPointer cfg , HonokaInstance *i);

    ~MultiConvertor();
    virtual bool isConnected();
    virtual void reset();
    virtual void setYomiText(WideString yomi);
    virtual int ren_conversion();
    virtual int setPos(int p);
    virtual int getPos();
    virtual ResultList getResultList(int p = -1 ,ResultType kt = DEFAULT);
    virtual bool select(int p);
    virtual bool resizeRegion(int w);
    virtual void updateFrequency();
    virtual bool connect();
    virtual void disconnect();
    virtual String getName();
    virtual String getPropertyName();
    virtual const vector<Segment> getSegmentList();
    static void aline(Convertor *master,Convertor *slave);

protected:
    HonokaInstance *instance;
    vector<MultiResultList> results;
    ResultList result;
    vector<WideString> texts;
    vector<WideString> yomi;
    Convertor *def;
    set<Convertor *> nuc;
};

#endif
