/*
 * IIIMF-SKK, Japanese Language Engine for
 *                        IIIMF (Internet/Intranet Input Method Framework)
 *
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */
                                                                                                          
/* $Id: palette.h,v 1.1.2.1 2003/08/01 13:47:53 famao Exp $ */
                                                                                                          
/* vi:set ts=4 sw=4: */

#ifndef HAVE_PALETTE_H
#define HAVE_PALETTE_H

#include <gtk/gtk.h>

typedef struct _Palette Palette;

#define PALETTE_WINDOW(X) (X)->toplevel->window
#define PALETTE_WIDGET(X) (X)->toplevel
#define PALETTE_TOOLBAR(X) (X)->toolbar
#define PALETTE_FLAGS(X) (X)->flags

#define PALETTE_WM_DETECTED ( 1 << 1 )
#define PALETTE_TRAY_DETECTED ( 1 << 2)

#define PALETTE_SET_FLAGS(X,Y) ((X)->flags |= Y)

struct _Palette
{
	GtkWidget *toplevel;
	GtkWidget *toolbar;
	gint running_wm;
	gint flags;

	gboolean (*detected_wm) (Palette *palette, gint wm_type, gint new_detected);
	gboolean (*detected_tray) (Palette *palette, gint tray_type, gint new_detected);
};

Palette *palette_new (void);

GtkWidget *palette_add_widget (Palette *palette, GtkWidget *widget, const gchar *tooltip);
GtkWidget *palette_add_button (Palette *palette, GtkWidget *pixmap, const gchar *name, const gchar *tooltip);

GtkWidget *palette_get_element_label_nth (Palette *palette, gint nth);
GtkWidget *palette_get_element_icon_nth (Palette *palette, gint nth);

void palette_show (Palette *palette);

#endif
