/*
 * IIIMF-Canna, Japanese Language Engine for 
 *                        IIIMF (Internet/Intranet Input Method Framework)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Shingo Akagaki <dora@momonga-linux.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: xaux_common.h,v 1.4 2002/09/16 11:06:48 famao Exp $ */

/* vi:set ts=4 sw=4: */


/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#pragma ident	"@(#)xaux_common.h 1.7 99/11/29"

#ifndef	XAUX_COMMON_H
#define	XAUX_COMMON_H

#define	ME_SO	"xaux_so"
#define	ME_EXT	"xaux_ext"

#define	XAUX_SOWIN_SUFFIX	"_sowin"
#define	XAUX_EXTWIN_SUFFIX	"_extwin"
#define	XAUX_XS_SUFFIX		"_xs"
#define	XAUX_SX_SUFFIX		"_sx"

#define	XAUX_RETRYINT_EXTWIN	1
#define	XAUX_MAXRETRY_EXTWIN	10

#define	XAUX_MAXCLASSNAMELEN	255
#define	XAUX_MAXSUFFIXLEN	16

#define	SX_PROP_ATOM_AUX_NAME(prop)	(*((CARD32 *)((prop) + 0)))
#define	SX_PROP_TYPE(prop)		(*((CARD16 *)((prop) + 4)))
#define	SX_PROP_INDEX(prop)		(*((CARD16 *)((prop) + 6)))
#define	SX_PROP_IMID(prop)		(*((CARD16 *)((prop) + 8)))
#define	SX_PROP_ICID(prop)		(*((CARD16 *)((prop) + 10)))
#define	SX_SIZE_PROP_STARTDONE		12
#define	SX_PROP_SOWIN(prop)		(*((CARD32 *)((prop) + 12)))
#define	SX_PROP_CLIENTWIN(prop)		(*((CARD32 *)((prop) + 16)))
#define	SX_PROP_FOCUSWIN(prop)		(*((CARD32 *)((prop) + 20)))
#define	SX_PROP_POSX(prop)		(*((CARD16 *)((prop) + 24)))
#define	SX_PROP_POSY(prop)		(*((CARD16 *)((prop) + 26)))
#define	SX_PROP_INT_COUNT(prop)		(*((CARD16 *)((prop) + 28)))
#define	SX_PROP_STR_COUNT(prop)		(*((CARD16 *)((prop) + 30)))
#define SX_SIZE_PROP_HEADER_DRAW	32
#define	SX_PROP_INT_LIST(prop)		((CARD32 *)((prop) + 32))
#define	SX_PROP_STR_LIST(prop) \
	((unsigned char *)((prop) + 32) \
		+ SX_PROP_INT_COUNT((prop)) * 4)

#define	XS_PROP_ATOM_AUX_NAME(prop)	(*((CARD32 *)((prop) + 0)))
#define	XS_PROP_IMID(prop)		(*((CARD16 *)((prop) + 4)))
#define	XS_PROP_ICID(prop)		(*((CARD16 *)((prop) + 6)))
#define	XS_PROP_INT_COUNT(prop)		(*((CARD16 *)((prop) + 8)))
#define	XS_PROP_STR_COUNT(prop)		(*((CARD16 *)((prop) + 10)))
#define XS_SIZE_PROP_HEADER_SETVALUE	12
#define	XS_PROP_INT_LIST(prop)		((CARD32 *)((prop) + 12))
#define	XS_PROP_STR_LIST(prop) \
	((unsigned char *)((prop) + 12) \
		+ XS_PROP_INT_COUNT((prop)) * 4)

#define	XAUX_SX_NATOMS			64
#define	XAUX_XS_NATOMS			64

typedef struct xaux_class_struct {
	const char	*classname;	/* aux_name */
	int		index;		/* aux_index */
	const char	*extexec;	/* full path of aux_ext executable */
	Window		sowin;		/* aux.so's window */
	Window		extwin;		/* aux_ext's window */
	Atom		atom_classname;	/* "${CLASSNAME}" */
	Atom		atom_sowin;	/* "${CLASSNAME}_sowin" */
	Atom		atom_extwin;	/* "${CLASSNAME}_extwin" */
	Atom		atom_sx[XAUX_SX_NATOMS]; /* "${CLASSNAME}_sx */
	size_t		atom_sx_idx;	/* next atom_sx to use */
	Atom		atom_xs[XAUX_XS_NATOMS]; /* "${CLASSNAME}_xs */
	size_t		atom_xs_idx;	/* next atom_xs to use */
	const CARD16	*utfname;	/* UTF-16 version of classname */
} xaux_class_t;

static const int	padding[4] = {0, 3, 2, 1};

#endif	/* !XAUX_COMMON_H */
