/*
 * IIIMF-Canna, Japanese Language Engine for
 *                        IIIMF (Internet/Intranet Input Method Framework)
 *
 * Copyright (C) 2002 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Shingo Akagaki <dora@momonga-linux.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: im_aux.h,v 1.3.2.1 2003/08/01 13:47:56 famao Exp $ */


#include "SunIM.h"

typedef struct _IMAuxCallbacks {
    void (*mode_change)(iml_session_t *s,int mode);
    void (*code_defined)(iml_session_t *s,IMText* commit_str);
    void (*dict_add)(iml_session_t *s,int type,IMText *result,IMText *annotation);
}IMAuxCallbacks;

void im_aux_setup (iml_session_t *s,IMAuxCallbacks *callbacks);
IMObjectDescriptorStruct* im_aux_get_objects (void);
void im_aux_menu_add (iml_session_t *s,int id,unsigned char* str);
void im_aux_dict_add (iml_session_t *s, const char *query_str);
void im_aux_mode_change (iml_session_t *s, int mode);
void im_aux_statusline_draw (iml_session_t *s,char* currentMode);
void im_aux_process_event (iml_session_t *s, IMAuxDrawCallbackStruct *aux);
