/*
 * IIIMF-SKK, Japanese Language Engine for
 *                        IIIMF (Internet/Intranet Input Method Framework)
 *
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */
                                                                                                          
/* $Id: palette.c,v 1.12 2003/03/14 02:25:30 famao Exp $ */
                                                                                                          
/* vi:set ts=4 sw=4: */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "palette.h"
#include "wmutil.h"


static void _initialize_palette (Palette *palette);
static GdkFilterReturn _configure_filter (GdkXEvent *gdk_xevent, GdkEvent *event, gpointer user_data);

static GdkFilterReturn
_configure_filter (GdkXEvent *gdk_xevent, GdkEvent *event, gpointer user_data)
{
	XEvent *e;
	Palette *palette = (Palette *)user_data;
	static gint old_wm = WM_IS_UNKNOWN;
	e = (XEvent *) gdk_xevent;
#if 0
	if (e->type == ConfigureNotify) {
		if (((PALETTE_FLAGS(palette) & PALETTE_WM_DETECTED) &&
				(PALETTE_FLAGS(palette) & PALETTE_TRAY_DETECTED))) {
			gdk_window_remove_filter (PALETTE_WINDOW (palette),
					_configure_filter, user_data);
		}
#endif
		palette->running_wm = wmutil_window_check_wm_type ();
		if (palette->running_wm) {
			gint new_wm_type = (palette->running_wm ^ old_wm);
			if (new_wm_type) {
				g_message ("IIIMF-SKK detected WM %d", palette->running_wm);
				g_message ("IIIMF-SKK Append WM Type %d", new_wm_type);
				palette->detected_wm (palette, palette->running_wm, new_wm_type);
				if (palette->running_wm & WM_CAN_TRAY)
					palette->detected_tray (palette, palette->running_wm, new_wm_type);
			}
#if 0
			if (palette->detected_wm && 
					!(PALETTE_FLAGS(palette) & PALETTE_WM_DETECTED)) {
				if (palette->detected_wm (palette, palette->running_wm))
					PALETTE_SET_FLAGS(palette, PALETTE_WM_DETECTED);
				g_message ("flags %d", PALETTE_FLAGS(palette));
			}
			if (palette->detected_tray &&
					(palette->running_wm & WM_CAN_TRAY) &&
					!(PALETTE_FLAGS(palette) & PALETTE_TRAY_DETECTED)) {
				if (palette->detected_tray (palette, palette->running_wm))
					PALETTE_SET_FLAGS(palette, PALETTE_TRAY_DETECTED);
			}
#endif
		}
		old_wm = palette->running_wm;
#if 0
	}
#endif
	return GDK_FILTER_CONTINUE;
}

static void
_initialize_palette (Palette *palette)
{
	GtkWidget *vbox;
	GtkWidget *handlebox;

	PALETTE_WIDGET (palette) = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_widget_realize (PALETTE_WIDGET (palette));

#ifdef USE_GTK2	
	PALETTE_TOOLBAR (palette) = gtk_toolbar_new ();
	gtk_toolbar_set_style (GTK_TOOLBAR (PALETTE_TOOLBAR (palette)),
			GTK_TOOLBAR_BOTH_HORIZ);
#else
	PALETTE_TOOLBAR (palette) = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL,
			GTK_TOOLBAR_ICONS);
#endif	
	gtk_widget_show (PALETTE_TOOLBAR (palette));

	vbox = gtk_vbox_new (FALSE, FALSE);
	gtk_widget_show (vbox);

	handlebox = gtk_handle_box_new ();
	gtk_widget_show (handlebox);

	gtk_container_add (GTK_CONTAINER (PALETTE_WIDGET (palette)), vbox);
	gtk_box_pack_start (GTK_BOX (vbox), handlebox, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER (handlebox), PALETTE_TOOLBAR (palette));

	gdk_window_set_decorations (PALETTE_WINDOW (palette), 0);
	gdk_window_add_filter (PALETTE_WINDOW (palette), 
			_configure_filter, palette);
}

Palette *
palette_new (void)
{
	Palette *ret;
	ret = g_new0 (Palette, 1);
	ret->toplevel = NULL;
	ret->toolbar = NULL;
	ret->running_wm = WM_IS_UNKNOWN;
	ret->flags = 0;
	ret->detected_wm = NULL;
	ret->detected_tray = NULL;
	_initialize_palette (ret);
	return ret;
}

GtkWidget *
palette_add_widget (Palette *palette, GtkWidget *widget, const gchar *tooltip)
{
	GtkWidget *button;
	if (!palette)
		return NULL;
	button = gtk_toolbar_append_element (GTK_TOOLBAR (PALETTE_TOOLBAR (palette)),
			GTK_TOOLBAR_CHILD_WIDGET, widget, NULL, tooltip, 
			NULL, NULL, NULL, NULL);
	if (GTK_IS_BUTTON (button))
		gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);
	return button;
}

GtkWidget *
palette_add_button (Palette *palette, GtkWidget *pixmap, const gchar *name, const gchar *tooltip)
{
	GtkWidget *button;
	if (!palette)
		return NULL;
	button = gtk_toolbar_append_element (GTK_TOOLBAR (PALETTE_TOOLBAR (palette)),
			GTK_TOOLBAR_CHILD_BUTTON, NULL, name, tooltip,
			NULL, pixmap, NULL, NULL);
	gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);
	return button;
}

static GtkToolbarChild *
_palette_get_element_nth (Palette *palette, gint nth)
{
	GtkToolbarChild *child;
	if (!palette)
		return NULL;
	child = (GtkToolbarChild *)g_list_nth_data (
			g_list_first (GTK_TOOLBAR (PALETTE_TOOLBAR (palette))->children),
			nth);
	return child;
}

GtkWidget *
palette_get_element_label_nth (Palette *palette, gint nth)
{
	GtkToolbarChild *child;
	child = _palette_get_element_nth (palette, nth);
	if (!child)
		return NULL;
	if (child->label) {
		return child->label;
	}
	if (child->widget) {
		return (GtkWidget*) gtk_object_get_data (GTK_OBJECT (child->widget), "_pixmap_button_label");
	}
	return NULL;
}

GtkWidget *
palette_get_element_icon_nth (Palette *palette, gint nth)
{
	GtkToolbarChild *child;
	child = _palette_get_element_nth (palette, nth);
	if (!child)
		return NULL;
	if (child->icon) {
		return child->icon;
	}
	if (child->widget) {
		return (GtkWidget*) gtk_object_get_data (GTK_OBJECT (child->widget), "_pixmap_button_icon");
	}
	return NULL;
}

void
palette_show (Palette *palette)
{
	if (!palette)
		return;
	gtk_widget_show (PALETTE_WIDGET (palette));
}
