/*
 * IIIMF-SKK, Japanese Language Engine for
 *                        IIIMF (Internet/Intranet Input Method Framework)
 * 
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkpalette.h,v 1.2 2003/02/19 17:44:50 famao Exp $ */

/* vi:set ts=4 sw=4: */

#ifndef HAVE_SKKPALETTE_H
#define HAVE_SKKPALETTE_H

#include <gtk/gtk.h>
#include "palette.h"
#include "skktray.h"

typedef struct _SkkPalette SkkPalette;

#define SKK_PALETTE(X) (X)->palette
#define SKK_PALETTE_WINDOW(X) ((X)->palette->toplevel->window)
#define SKK_PALETTE_WIDGET(X) ((X)->palette->toplevel)
#define SKK_PALETTE_TOOLBAR(X) ((X)->palette->toolbar)
#define SKK_PALETTE_MENU(X) (X)->status_menu
#define SKK_TRAY(X) (X)->tray

struct _SkkPalette {
	Palette *palette;
	TrayWindow *tray;
	GtkWidget *status_menu;
	/* FIXME */
	GtkWidget *codetable;
};

SkkPalette *skk_palette_new (void);
#endif
