/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.boot;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.boot.Module;
import org.pentaho.reporting.libraries.base.boot.ModuleInitializeException;
import org.pentaho.reporting.libraries.base.boot.SubSystem;

public class PackageState {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$org$pentaho$reporting$libraries$base$boot$PackageState == null ? (class$org$pentaho$reporting$libraries$base$boot$PackageState = PackageState.class$("org.pentaho.reporting.libraries.base.boot.PackageState")) : class$org$pentaho$reporting$libraries$base$boot$PackageState));
    public static final int STATE_NEW = 0;
    public static final int STATE_CONFIGURED = 1;
    public static final int STATE_INITIALIZED = 2;
    public static final int STATE_ERROR = -2;
    private final Module module;
    private int state;
    static /* synthetic */ Class class$org$pentaho$reporting$libraries$base$boot$PackageState;

    public PackageState(Module module) {
        this(module, 0);
    }

    public PackageState(Module module, int state) {
        if (module == null) {
            throw new NullPointerException("Module must not be null.");
        }
        if (state != 1 && state != -2 && state != 2 && state != 0) {
            throw new IllegalArgumentException("State is not valid");
        }
        this.module = module;
        this.state = state;
    }

    public boolean configure(SubSystem subSystem) {
        if (subSystem == null) {
            throw new NullPointerException();
        }
        if (this.state == 0) {
            try {
                this.module.configure(subSystem);
                this.state = 1;
                return true;
            }
            catch (NoClassDefFoundError noClassDef) {
                LOGGER.warn((Object)("Unable to load module classes for " + this.module.getName() + ':' + noClassDef.getMessage()));
                this.state = -2;
            }
            catch (Exception e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.warn((Object)("Unable to configure the module " + this.module.getName()), (Throwable)e);
                } else if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)("Unable to configure the module " + this.module.getName()));
                }
                this.state = -2;
            }
        }
        return false;
    }

    public Module getModule() {
        return this.module;
    }

    public int getState() {
        return this.state;
    }

    public boolean initialize(SubSystem subSystem) {
        if (subSystem == null) {
            throw new NullPointerException();
        }
        if (this.state == 1) {
            try {
                this.module.initialize(subSystem);
                this.state = 2;
                return true;
            }
            catch (NoClassDefFoundError noClassDef) {
                LOGGER.warn((Object)("Unable to load module classes for " + this.module.getName() + ':' + noClassDef.getMessage()));
                this.state = -2;
            }
            catch (ModuleInitializeException me) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.warn((Object)("Unable to initialize the module " + this.module.getName()), (Throwable)me);
                } else if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)("Unable to initialize the module " + this.module.getName()));
                }
                this.state = -2;
            }
            catch (Exception e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.warn((Object)("Unable to initialize the module " + this.module.getName()), (Throwable)e);
                } else if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)("Unable to initialize the module " + this.module.getName()));
                }
                this.state = -2;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageState)) {
            return false;
        }
        PackageState packageState = (PackageState)o;
        return this.module.getModuleClass().equals(packageState.module.getModuleClass());
    }

    public int hashCode() {
        return this.module.hashCode();
    }

    public void markError() {
        this.state = -2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

