/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.serializer;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.serializer.ClassComparator;
import org.jfree.serializer.JCommonSerializerBoot;
import org.jfree.serializer.SerializeMethod;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class SerializerHelper {
    private static Log logger = LogFactory.getLog((Class)(class$org$jfree$serializer$SerializerHelper == null ? (class$org$jfree$serializer$SerializerHelper = SerializerHelper.class$("org.jfree.serializer.SerializerHelper")) : class$org$jfree$serializer$SerializerHelper));
    private static SerializerHelper singleton;
    private final HashMap methods;
    private final ClassComparator comparator = new ClassComparator();
    static /* synthetic */ Class class$org$jfree$serializer$SerializerHelper;
    static /* synthetic */ Class class$org$jfree$serializer$SerializeMethod;

    public static synchronized SerializerHelper getInstance() {
        if (singleton == null) {
            singleton = new SerializerHelper();
            singleton.registerMethods();
        }
        return singleton;
    }

    protected static void setInstance(SerializerHelper helper) {
        singleton = helper;
    }

    protected SerializerHelper() {
        this.methods = new HashMap();
    }

    public synchronized void registerMethod(SerializeMethod method) {
        this.methods.put(method.getObjectClass(), method);
    }

    protected void registerMethods() {
        Configuration config = JCommonSerializerBoot.getInstance().getGlobalConfig();
        Iterator sit = config.findPropertyKeys("org.jfree.serializer.handler.");
        while (sit.hasNext()) {
            String configkey = (String)sit.next();
            String c = config.getConfigProperty(configkey);
            Object maybeModule = ObjectUtilities.loadAndInstantiate((String)c, (Class)(class$org$jfree$serializer$SerializerHelper == null ? SerializerHelper.class$("org.jfree.serializer.SerializerHelper") : class$org$jfree$serializer$SerializerHelper), (Class)(class$org$jfree$serializer$SerializeMethod == null ? SerializerHelper.class$("org.jfree.serializer.SerializeMethod") : class$org$jfree$serializer$SerializeMethod));
            if (maybeModule != null) {
                SerializeMethod module = (SerializeMethod)maybeModule;
                this.registerMethod(module);
                continue;
            }
            logger.warn((Object)("Invalid SerializeMethod implementation: " + c));
        }
    }

    public synchronized void unregisterMethod(SerializeMethod method) {
        this.methods.remove(method.getObjectClass());
    }

    protected HashMap getMethods() {
        return this.methods;
    }

    protected ClassComparator getComparator() {
        return this.comparator;
    }

    protected SerializeMethod getSerializer(Class c) {
        SerializeMethod sm = (SerializeMethod)this.methods.get(c);
        if (sm != null) {
            return sm;
        }
        return this.getSuperClassObjectDescription(c);
    }

    protected SerializeMethod getSuperClassObjectDescription(Class d) {
        SerializeMethod knownSuperClass = null;
        Iterator keys = this.methods.keySet().iterator();
        while (keys.hasNext()) {
            Class keyClass = (Class)keys.next();
            if (!keyClass.isAssignableFrom(d)) continue;
            SerializeMethod od = (SerializeMethod)this.methods.get(keyClass);
            if (knownSuperClass == null) {
                knownSuperClass = od;
                continue;
            }
            if (!this.comparator.isComparable(knownSuperClass.getObjectClass(), od.getObjectClass()) || this.comparator.compare(knownSuperClass.getObjectClass(), od.getObjectClass()) >= 0) continue;
            knownSuperClass = od;
        }
        return knownSuperClass;
    }

    public synchronized void writeObject(Object o, ObjectOutputStream out) throws IOException {
        if (o == null) {
            out.writeByte(0);
            return;
        }
        if (o instanceof Serializable) {
            out.writeByte(1);
            out.writeObject(o);
            return;
        }
        SerializeMethod m = this.getSerializer(o.getClass());
        if (m == null) {
            throw new NotSerializableException(o.getClass().getName());
        }
        out.writeByte(2);
        out.writeObject(m.getObjectClass());
        m.writeObject(o, out);
    }

    public synchronized Object readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (type == 1) {
            return in.readObject();
        }
        Class c = (Class)in.readObject();
        SerializeMethod m = this.getSerializer(c);
        if (m == null) {
            throw new NotSerializableException(c.getName());
        }
        return m.readObject(in);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

